/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles;

import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.roles.CaseRolesPresenter;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.client.util.CommaListValuesConverter;
import org.jbpm.workbench.cm.client.util.FormGroup;
import org.jbpm.workbench.cm.client.util.FormLabel;
import org.jbpm.workbench.cm.client.util.InlineNotification;
import org.jbpm.workbench.cm.client.util.Modal;
import org.jbpm.workbench.cm.client.util.Popover;
import org.jbpm.workbench.cm.client.util.ValidationState;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class EditRoleAssignmentViewImpl
extends AbstractView<CaseRolesPresenter>
implements CaseRolesPresenter.EditRoleAssignmentView {
    @Inject
    @DataField(value="alert")
    private InlineNotification notification;
    @Inject
    @DataField(value="role-name-group")
    FormGroup roleNameGroup;
    @Inject
    @DataField(value="role-name-help")
    Span roleNameHelp;
    @Inject
    @Bound
    @DataField(value="role-name-text")
    Span name;
    @Inject
    @DataField(value="role-name-label")
    FormLabel roleNameLabel;
    @Inject
    @DataField(value="assignment-label")
    FormLabel assignmentLabel;
    @Inject
    @DataField(value="roles-help")
    private Popover rolesHelp;
    @Inject
    @Bound(converter=CommaListValuesConverter.class)
    @DataField(value="user-name-input")
    TextInput users;
    @Inject
    @DataField(value="user-name-group")
    FormGroup userNameGroup;
    @Inject
    @Bound(converter=CommaListValuesConverter.class)
    @DataField(value="group-name-input")
    TextInput groups;
    @Inject
    @DataField(value="group-name-help")
    Span groupNameHelp;
    @Inject
    @DataField(value="group-name-group")
    FormGroup groupNameGroup;
    @Inject
    @DataField(value="modal")
    private Modal modal;
    @Inject
    @AutoBound
    private DataBinder<CaseRoleAssignmentSummary> binder;
    private Command okCommand;
    @Inject
    private TranslationService translationService;

    @PostConstruct
    public void init() {
        this.roleNameLabel.addRequiredIndicator();
        this.assignmentLabel.addRequiredIndicator();
        this.rolesHelp.setContent(this.translationService.getTranslation("RolesInfoText"));
        this.notification.setType(InlineNotification.InlineNotificationType.DANGER);
    }

    @Override
    public void init(CaseRolesPresenter presenter) {
    }

    public void setValue(CaseRoleAssignmentSummary caseRoleAssignmentSummary) {
        this.binder.setModel((Object)caseRoleAssignmentSummary);
    }

    public CaseRoleAssignmentSummary getValue() {
        return (CaseRoleAssignmentSummary)this.binder.getModel();
    }

    @Override
    public void showValidationError(List<String> messages) {
        if (messages.isEmpty()) {
            return;
        }
        this.notification.setMessage(messages);
        DOMUtil.removeCSSClass((HTMLElement)this.notification.getElement(), (String)"hidden");
    }

    @Override
    public void show(Command okCommand) {
        this.clearErrorMessages();
        this.okCommand = okCommand;
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    private boolean validateForm() {
        boolean validForm = true;
        this.clearErrorMessages();
        CaseRoleAssignmentSummary model = this.getValue();
        if (!model.hasAssignment()) {
            this.users.focus();
            this.userNameGroup.setValidationState(ValidationState.ERROR);
            this.groupNameGroup.setValidationState(ValidationState.ERROR);
            this.showValidationError(Arrays.asList(this.translationService.format("PleaseIntroUserOrGroupToCreateAssignment", new Object[0])));
            validForm = false;
        }
        if (validForm) {
            this.roleNameGroup.setValidationState(ValidationState.SUCCESS);
            this.userNameGroup.setValidationState(ValidationState.SUCCESS);
            this.groupNameGroup.setValidationState(ValidationState.SUCCESS);
        }
        return validForm;
    }

    private void clearErrorMessages() {
        DOMUtil.addCSSClass((HTMLElement)this.notification.getElement(), (String)"hidden");
        this.notification.setMessage("");
        this.roleNameHelp.setTextContent("");
        this.groupNameHelp.setTextContent("");
        this.roleNameGroup.clearValidationState();
        this.userNameGroup.clearValidationState();
        this.groupNameGroup.clearValidationState();
    }

    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    @EventHandler(value={"assign"})
    public void onAssignClick(@ForEvent(value={"click"}) MouseEvent event) {
        if (!this.validateForm()) {
            return;
        }
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
    }

    @EventHandler(value={"cancel"})
    public void onCancelClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }
}

