/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.details;

import org.jbpm.workbench.cm.client.details.CaseDetailsPresenter;
import org.jbpm.workbench.cm.client.events.CaseRefreshEvent;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseDetailsPresenterTest
extends AbstractCaseInstancePresenterTest {
    @Mock
    CaseDetailsPresenter.CaseDetailsView view;
    @InjectMocks
    CaseDetailsPresenter presenter;

    public CaseDetailsPresenter getPresenter() {
        return this.presenter;
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testFindCaseInstance() {
        this.presenter.findCaseInstance();
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setValue((Object)new CaseInstanceSummary());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.never())).getCaseInstance(Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testOnStartup() {
        String serverTemplateId = "serverTemplateId";
        CaseInstanceSummary cis = this.setupCaseInstance("serverTemplateId");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setValue((Object)new CaseInstanceSummary());
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setValue((Object)cis);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).getCaseInstance("serverTemplateId", cis.getContainerId(), cis.getCaseId());
    }

    @Test
    public void testOnCaseRefreshEvent() {
        String serverTemplateId = "serverTemplateId";
        CaseInstanceSummary cis = this.setupCaseInstance("serverTemplateId");
        this.presenter.onCaseRefreshEvent(new CaseRefreshEvent(cis.getCaseId()));
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setValue((Object)new CaseInstanceSummary());
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setValue((Object)cis);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)2))).getCaseInstance("serverTemplateId", cis.getContainerId(), cis.getCaseId());
    }
}

