/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.stages;

import java.util.Arrays;
import java.util.List;
import org.jbpm.workbench.cm.client.stages.CaseStageItemViewImpl;
import org.jbpm.workbench.cm.client.stages.CaseStagesPresenter;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseStageSummary;
import org.jbpm.workbench.cm.util.CaseStageStatus;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseStagesPresenterTest
extends AbstractCaseInstancePresenterTest {
    private CaseStageItemViewImpl caseStageItemViewMock;
    @Mock
    private CaseStagesPresenter.CaseStagesView caseStagesView;
    @Spy
    @InjectMocks
    private CaseStagesPresenter presenter;

    public CaseStagesPresenter getPresenter() {
        return this.presenter;
    }

    @Before
    public void setup() {
        this.caseStageItemViewMock = (CaseStageItemViewImpl)Mockito.mock(CaseStageItemViewImpl.class);
    }

    @Test
    public void testClearAndLoadCaseInstance() {
        List<CaseStageSummary> stages = Arrays.asList(this.createCaseStageSummary(CaseStageStatus.AVAILABLE.getStatus()), this.createCaseStageSummary(CaseStageStatus.COMPLETED.getStatus()));
        Mockito.when((Object)this.caseManagementService.getCaseStages((String)Mockito.any(), (String)Mockito.any())).thenReturn(stages);
        CaseInstanceSummary cis = CaseStagesPresenterTest.newCaseInstanceSummary();
        this.setupCaseInstance(cis, "serverTemplateId");
        ((CaseStagesPresenter.CaseStagesView)Mockito.verify((Object)this.caseStagesView)).removeAllStages();
        ((CaseStagesPresenter.CaseStagesView)Mockito.verify((Object)this.caseStagesView)).setCaseStagesList(stages);
        ((CaseStagesPresenter.CaseStagesView)Mockito.verify((Object)this.caseStagesView)).getCaseStageComponentList();
        ((CaseStagesPresenter)Mockito.verify((Object)this.presenter)).setStages();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.caseStagesView});
    }

    @Test
    public void testSetStage_stageActive() {
        Mockito.when((Object)this.caseStageItemViewMock.getValue()).thenReturn((Object)this.createCaseStageSummary(CaseStageStatus.ACTIVE.getStatus()));
        this.getPresenter().setStage(this.caseStageItemViewMock);
        ((CaseStageItemViewImpl)Mockito.verify((Object)this.caseStageItemViewMock)).showStageActive();
    }

    @Test
    public void testSetStage_stageNotActive() {
        Mockito.when((Object)this.caseStageItemViewMock.getValue()).thenReturn((Object)this.createCaseStageSummary(CaseStageStatus.AVAILABLE.getStatus()), (Object[])new CaseStageSummary[]{this.createCaseStageSummary(CaseStageStatus.COMPLETED.getStatus()), this.createCaseStageSummary(CaseStageStatus.CANCELED.getStatus())});
        this.getPresenter().setStage(this.caseStageItemViewMock);
        this.getPresenter().setStage(this.caseStageItemViewMock);
        this.getPresenter().setStage(this.caseStageItemViewMock);
        ((CaseStageItemViewImpl)Mockito.verify((Object)this.caseStageItemViewMock, (VerificationMode)Mockito.never())).showStageActive();
    }
}

