/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.actions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.cm.client.actions.CaseActionItemView;
import org.jbpm.workbench.cm.client.actions.CaseActionsPresenter;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.workbench.cm.model.CaseActionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseStageSummary;
import org.jbpm.workbench.cm.model.ProcessDefinitionSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.jbpm.workbench.cm.util.Actions;
import org.jbpm.workbench.cm.util.CaseActionStatus;
import org.jbpm.workbench.cm.util.CaseActionType;
import org.jbpm.workbench.cm.util.CaseStageStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class ActionsPresenterTest
extends AbstractCaseInstancePresenterTest {
    @Mock(name="view")
    private CaseActionsPresenter.CaseActionsView caseAllActionsView;
    @Mock(name="NewActionView")
    private CaseActionsPresenter.NewActionView newActionViewMock;
    @Mock
    private User identity;
    @Mock
    private Actions actions;
    @Spy
    @InjectMocks
    private CaseActionsPresenter presenter;
    private CaseActionItemView caseActionItemViewMock;
    private CaseInstanceSummary cis;
    private List<CaseActionSummary> caseActionSummaryList = Lists.newArrayList((Object[])new CaseActionSummary[]{ActionsPresenterTest.createCaseActionSummary()});
    private final String taskName = "dynTask-name";
    private final String actors = "dynTask-actors";
    private final String groups = "dynTask-groups";
    private final String description = "dynTask-description";
    private final ProcessDefinitionSummary processDefinitionSummary = ProcessDefinitionSummary.builder().id("processDefinitionId").build();

    private static CaseActionSummary createCaseActionSummary() {
        return CaseActionSummary.builder().id(Long.valueOf(1L)).name("actionName").build();
    }

    public CaseActionsPresenter getPresenter() {
        return this.presenter;
    }

    @Before
    public void setup() {
        this.caseActionItemViewMock = (CaseActionItemView)Mockito.mock(CaseActionItemView.class);
        this.cis = ActionsPresenterTest.newCaseInstanceSummary();
        this.cis.setStages(new ArrayList<CaseStageSummary>(Arrays.asList(this.createCaseStageSummary(CaseStageStatus.AVAILABLE.getStatus()), this.createCaseStageSummary(CaseStageStatus.ACTIVE.getStatus()))));
        Mockito.when((Object)this.caseManagementService.getCaseActions(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.actions);
        Mockito.when((Object)this.actions.getAvailableActions()).thenReturn(this.caseActionSummaryList);
        Mockito.when((Object)this.actions.getInProgressAction()).thenReturn(this.caseActionSummaryList);
        Mockito.when((Object)this.actions.getCompleteActions()).thenReturn(this.caseActionSummaryList);
    }

    @Test
    public void clearAndLoadCaseInstanceTest() {
        Mockito.when((Object)this.caseManagementService.getProcessDefinitions("containerId")).thenReturn(Collections.singletonList(ProcessDefinitionSummary.builder().id("processId").name("SubProcess_1").build()));
        this.setupCaseInstance(this.cis, "serverTemplateId");
        this.verifyCaseInstanceCleared();
        this.verifyCaseInstanceLoaded();
    }

    private void verifyCaseInstanceCleared() {
        ((CaseActionsPresenter.CaseActionsView)Mockito.verify((Object)this.caseAllActionsView)).removeAllTasks();
        ((CaseActionsPresenter.NewActionView)Mockito.verify((Object)this.newActionViewMock)).clearAllStages();
        ((CaseActionsPresenter.NewActionView)Mockito.verify((Object)this.newActionViewMock)).clearAllProcessDefinitions();
    }

    private void verifyCaseInstanceLoaded() {
        List allStagesList = this.cis.getStages();
        ((CaseActionsPresenter.CaseActionsView)Mockito.verify((Object)this.caseAllActionsView)).updateListHeaders();
        ((CaseActionsPresenter)Mockito.verify((Object)this.presenter)).setCaseStagesList(allStagesList);
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseActionsPresenter.NewActionView)Mockito.verify((Object)this.newActionViewMock)).addStages((List)captor.capture());
        Assert.assertEquals((long)1L, (long)((List)captor.getValue()).size());
        Assert.assertEquals((Object)CaseStageStatus.ACTIVE.getStatus(), (Object)((CaseStageSummary)((List)captor.getValue()).get(0)).getStatus());
        this.verifySubProcessesLoaded();
        this.verifyActionsLoaded();
    }

    private void verifySubProcessesLoaded() {
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).getProcessDefinitions("containerId");
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseActionsPresenter.NewActionView)Mockito.verify((Object)this.newActionViewMock)).setProcessDefinitions((List)captor.capture());
        Assert.assertEquals((long)1L, (long)((List)captor.getValue()).size());
        Assert.assertEquals((Object)"SubProcess_1", ((List)captor.getValue()).get(0));
    }

    private void verifyActionsLoaded() {
        ((CaseActionsPresenter)Mockito.verify((Object)this.presenter)).refreshData(true);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).getCaseActions("serverTemplateId", "containerId", "caseId", this.identity.getIdentifier());
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseActionsPresenter.CaseActionsView)Mockito.verify((Object)this.caseAllActionsView)).setAvailableActionsList((List)captor.capture());
        Assert.assertEquals((long)(this.caseActionSummaryList.size() + 2), (long)((List)captor.getValue()).size());
        Assert.assertEquals((Object)CaseActionType.DYNAMIC_USER_TASK, (Object)((CaseActionSummary)((List)captor.getValue()).get(0)).getActionType());
        Assert.assertEquals((Object)CaseActionType.DYNAMIC_SUBPROCESS_TASK, (Object)((CaseActionSummary)((List)captor.getValue()).get(1)).getActionType());
        ((CaseActionsPresenter.CaseActionsView)Mockito.verify((Object)this.caseAllActionsView)).setInProgressActionsList(this.caseActionSummaryList);
        ((CaseActionsPresenter.CaseActionsView)Mockito.verify((Object)this.caseAllActionsView)).setCompletedActionsList(this.caseActionSummaryList);
    }

    @Test
    public void testSetAdHocAction_statusAvailable() {
        CaseActionSummary caseActionSummary = this.createCaseActionSummary(CaseActionStatus.AVAILABLE);
        caseActionSummary.setActionType(CaseActionType.AD_HOC_TASK);
        Mockito.when((Object)this.caseActionItemViewMock.getValue()).thenReturn((Object)caseActionSummary);
        this.verifyAvailableActionIsSet(this.translationService.format("AvailableIn", new Object[0]) + ": " + this.translationService.format("Case", new Object[0]));
    }

    @Test
    public void testSetAdHocActionInStage_statusAvailable() {
        CaseActionSummary caseActionSummary = this.createCaseActionSummary(CaseActionStatus.AVAILABLE);
        caseActionSummary.setActionType(CaseActionType.AD_HOC_TASK);
        caseActionSummary.setStage(CaseStageSummary.builder().name("Stage_Id").build());
        Mockito.when((Object)this.caseActionItemViewMock.getValue()).thenReturn((Object)caseActionSummary);
        this.verifyAvailableActionIsSet(this.translationService.format("AvailableIn", new Object[0]) + ": Stage_Id");
    }

    @Test
    public void testSetDynamicAction_statusAvailable() {
        CaseActionSummary caseActionSummary = this.createCaseActionSummary(CaseActionStatus.AVAILABLE);
        caseActionSummary.setActionType(CaseActionType.DYNAMIC_USER_TASK);
        Mockito.when((Object)this.caseActionItemViewMock.getValue()).thenReturn((Object)caseActionSummary);
        this.verifyAvailableActionIsSet(this.translationService.format("Dynamic", new Object[0]));
        ArgumentCaptor caseActionActionCaptor = ArgumentCaptor.forClass(CaseActionsPresenter.CaseActionAction.class);
        ((CaseActionItemView)Mockito.verify((Object)this.caseActionItemViewMock)).addAction((CaseActionsPresenter.CaseActionAction)caseActionActionCaptor.capture());
        Assert.assertEquals((Object)this.translationService.format("ActionStart", new Object[0]), (Object)((CaseActionsPresenter.CaseActionAction)caseActionActionCaptor.getValue()).label());
        ((CaseActionsPresenter.CaseActionAction)caseActionActionCaptor.getValue()).execute();
        CaseActionType actionType = caseActionSummary.getActionType();
        ((CaseActionsPresenter)Mockito.verify((Object)this.presenter)).setNewDynamicAction(actionType);
        ((CaseActionsPresenter.NewActionView)Mockito.verify((Object)this.newActionViewMock)).show((CaseActionType)Mockito.eq((Object)actionType), (Command)Mockito.any(Command.class));
    }

    private void verifyAvailableActionIsSet(String actionInfo) {
        this.getPresenter().setAction(this.caseActionItemViewMock);
        ((CaseActionsPresenter)Mockito.verify((Object)this.presenter)).prepareAction(this.caseActionItemViewMock);
        ((CaseActionItemView)Mockito.verify((Object)this.caseActionItemViewMock)).addActionInfo(actionInfo);
        ((CaseActionItemView)Mockito.verify((Object)this.caseActionItemViewMock)).addAction((CaseActionsPresenter.CaseActionAction)Mockito.any(CaseActionsPresenter.CaseActionAction.class));
    }

    @Test
    public void testSetAction_statusInProgress() {
        CaseActionSummary caseActionSummaryWithoutOwner = this.createCaseActionSummary(CaseActionStatus.IN_PROGRESS);
        caseActionSummaryWithoutOwner.setType("HumanTaskNode");
        CaseActionSummary caseActionSummaryWithOwner = this.createCaseActionSummary(CaseActionStatus.IN_PROGRESS);
        caseActionSummaryWithOwner.setActualOwner("owner");
        caseActionSummaryWithOwner.setType("HumanTaskNode");
        Mockito.when((Object)this.caseActionItemViewMock.getValue()).thenReturn((Object)caseActionSummaryWithoutOwner, (Object[])new CaseActionSummary[]{caseActionSummaryWithOwner});
        this.getPresenter().setAction(this.caseActionItemViewMock);
        ((CaseActionItemView)Mockito.verify((Object)this.caseActionItemViewMock)).addActionInfo(" ( HumanTask ) ");
        this.getPresenter().setAction(this.caseActionItemViewMock);
        ((CaseActionItemView)Mockito.verify((Object)this.caseActionItemViewMock, (VerificationMode)Mockito.times((int)2))).addCreationDate();
        ((CaseActionItemView)Mockito.verify((Object)this.caseActionItemViewMock)).addActionInfo(" ( HumanTask - owner ) ");
        ((CaseActionsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).prepareAction((CaseActionItemView)Mockito.any(CaseActionItemView.class));
    }

    @Test
    public void testSetAction_statusCompleted() {
        CaseActionSummary caseActionSummary = this.createCaseActionSummary(CaseActionStatus.COMPLETED);
        caseActionSummary.setType("HumanTaskNode");
        Mockito.when((Object)this.caseActionItemViewMock.getValue()).thenReturn((Object)caseActionSummary);
        this.getPresenter().setAction(this.caseActionItemViewMock);
        ((CaseActionItemView)Mockito.verify((Object)this.caseActionItemViewMock)).addCreationDate();
        ((CaseActionItemView)Mockito.verify((Object)this.caseActionItemViewMock)).addActionInfo(" ( HumanTask ) ");
        ((CaseActionsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).prepareAction((CaseActionItemView)Mockito.any(CaseActionItemView.class));
    }

    @Test
    public void testSetAction_NodeTypes() {
        this.assertActionInfo("HumanTaskNode", " ( HumanTask ) ");
        this.assertActionInfo("MilestoneNode", " ( Milestone ) ");
        this.assertActionInfo("SubProcessNode", " ( SubProcess ) ");
        this.assertActionInfo("RandomNode", null, CaseActionStatus.IN_PROGRESS, Mockito.never());
        this.assertActionInfo("RandomNode", null, CaseActionStatus.COMPLETED, Mockito.never());
    }

    protected void assertActionInfo(String nodeType, String text) {
        this.assertActionInfo(nodeType, text, CaseActionStatus.IN_PROGRESS, Mockito.times((int)1));
        this.assertActionInfo(nodeType, text, CaseActionStatus.COMPLETED, Mockito.times((int)1));
    }

    protected void assertActionInfo(String nodeType, String text, CaseActionStatus status, VerificationMode mode) {
        CaseActionSummary caseActionSummary = this.createCaseActionSummary(status);
        caseActionSummary.setType(nodeType);
        Mockito.when((Object)this.caseActionItemViewMock.getValue()).thenReturn((Object)caseActionSummary);
        this.getPresenter().setAction(this.caseActionItemViewMock);
        ((CaseActionItemView)Mockito.verify((Object)this.caseActionItemViewMock, (VerificationMode)mode)).addActionInfo(text);
        Mockito.reset((Object[])new CaseActionItemView[]{this.caseActionItemViewMock});
    }

    private CaseActionSummary createCaseActionSummary(CaseActionStatus status) {
        CaseActionSummary caseActionSummary = ActionsPresenterTest.createCaseActionSummary();
        caseActionSummary.setActionStatus(status);
        return caseActionSummary;
    }

    @Test
    public void testAddDynamicUserTaskAction() {
        this.verifyDynamicActionAdded(CaseActionType.DYNAMIC_USER_TASK, null);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).addDynamicUserTask(Mockito.anyString(), Mockito.anyString(), (String)Mockito.eq((Object)"dynTask-name"), (String)Mockito.eq((Object)"dynTask-description"), (String)Mockito.eq((Object)"dynTask-actors"), (String)Mockito.eq((Object)"dynTask-groups"), (Map)Mockito.eq(null));
    }

    @Test
    public void testAddDynamicUserTaskActionToStage() {
        String stageId = "stageId";
        this.verifyDynamicActionAdded(CaseActionType.DYNAMIC_USER_TASK, "stageId");
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).addDynamicUserTaskToStage(Mockito.anyString(), Mockito.anyString(), (String)Mockito.eq((Object)"stageId"), (String)Mockito.eq((Object)"dynTask-name"), (String)Mockito.eq((Object)"dynTask-description"), (String)Mockito.eq((Object)"dynTask-actors"), (String)Mockito.eq((Object)"dynTask-groups"), (Map)Mockito.eq(null));
    }

    @Test
    public void testAddDynamicSubProcessTaskAction() {
        this.verifyDynamicActionAdded(CaseActionType.DYNAMIC_SUBPROCESS_TASK, null);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).addDynamicSubProcess(Mockito.anyString(), Mockito.anyString(), (String)Mockito.eq((Object)this.processDefinitionSummary.getId()), (Map)Mockito.eq(null));
    }

    @Test
    public void testAddDynamicSubProcessTaskActionToStage() {
        String stageId = "stageId";
        this.verifyDynamicActionAdded(CaseActionType.DYNAMIC_SUBPROCESS_TASK, "stageId");
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).addDynamicSubProcessToStage(Mockito.anyString(), Mockito.anyString(), (String)Mockito.eq((Object)"stageId"), (String)Mockito.eq((Object)this.processDefinitionSummary.getId()), (Map)Mockito.eq(null));
    }

    private void verifyDynamicActionAdded(CaseActionType actionType, String stageId) {
        CaseActionSummary caseActionSummary = this.createCaseActionSummary(CaseActionStatus.AVAILABLE);
        caseActionSummary.setActionType(actionType);
        Mockito.when((Object)this.caseActionItemViewMock.getValue()).thenReturn((Object)caseActionSummary);
        this.verifyAvailableActionIsSet(this.translationService.format("Dynamic", new Object[0]));
        ArgumentCaptor caseActionActionCaptor = ArgumentCaptor.forClass(CaseActionsPresenter.CaseActionAction.class);
        ((CaseActionItemView)Mockito.verify((Object)this.caseActionItemViewMock)).addAction((CaseActionsPresenter.CaseActionAction)caseActionActionCaptor.capture());
        ((CaseActionsPresenter.CaseActionAction)caseActionActionCaptor.getValue()).execute();
        switch (actionType) {
            case DYNAMIC_USER_TASK: {
                Mockito.when((Object)this.newActionViewMock.getTaskName()).thenReturn((Object)"dynTask-name");
                Mockito.when((Object)this.newActionViewMock.getDescription()).thenReturn((Object)"dynTask-description");
                Mockito.when((Object)this.newActionViewMock.getActors()).thenReturn((Object)"dynTask-actors");
                Mockito.when((Object)this.newActionViewMock.getGroups()).thenReturn((Object)"dynTask-groups");
                Mockito.when((Object)this.newActionViewMock.getStageId()).thenReturn((Object)stageId);
                ArgumentCaptor okCommandCaptor = ArgumentCaptor.forClass(Command.class);
                ((CaseActionsPresenter.NewActionView)Mockito.verify((Object)this.newActionViewMock)).show((CaseActionType)Mockito.eq((Object)caseActionSummary.getActionType()), (Command)okCommandCaptor.capture());
                ((Command)okCommandCaptor.getValue()).execute();
                ((CaseActionsPresenter)Mockito.verify((Object)this.presenter)).addDynamicUserTaskAction((String)Mockito.eq((Object)"dynTask-name"), (String)Mockito.eq((Object)"dynTask-description"), (String)Mockito.eq((Object)"dynTask-actors"), (String)Mockito.eq((Object)"dynTask-groups"), (String)Mockito.eq((Object)stageId));
                break;
            }
            case DYNAMIC_SUBPROCESS_TASK: {
                String processDefinitionName = "dynTask-processDefinitionName";
                Mockito.when((Object)this.newActionViewMock.getProcessDefinitionName()).thenReturn((Object)"dynTask-processDefinitionName");
                Mockito.when((Object)this.newActionViewMock.getStageId()).thenReturn((Object)stageId);
                this.presenter.getProcessDefinitionSummaryMap().put("dynTask-processDefinitionName", this.processDefinitionSummary);
                ArgumentCaptor okCommandCaptor = ArgumentCaptor.forClass(Command.class);
                ((CaseActionsPresenter.NewActionView)Mockito.verify((Object)this.newActionViewMock)).show((CaseActionType)Mockito.eq((Object)caseActionSummary.getActionType()), (Command)okCommandCaptor.capture());
                ((Command)okCommandCaptor.getValue()).execute();
                ((CaseActionsPresenter)Mockito.verify((Object)this.presenter)).addDynamicSubprocessTaskAction((String)Mockito.eq((Object)"dynTask-processDefinitionName"), (String)Mockito.eq((Object)stageId));
                break;
            }
        }
    }

    @Test
    public void testTriggerAdHocFragment() {
        String adhocFragmentName = "adhocFrag-name";
        this.setupCaseInstance(this.cis, "serverTemplateId");
        this.presenter.triggerAdHocAction(adhocFragmentName);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).triggerAdHocAction((String)Mockito.eq((Object)"containerId"), (String)Mockito.eq((Object)"caseId"), (String)Mockito.eq((Object)adhocFragmentName), (Map)Mockito.any());
    }
}

