/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jbpm.workbench.cm.client.roles.CaseRoleItemView;
import org.jbpm.workbench.cm.client.roles.CaseRolesPresenter;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.workbench.cm.client.util.CaseRolesValidations;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseRolesPresenterTest
extends AbstractCaseInstancePresenterTest {
    private static final String USER = "User";
    private static final String GROUP = "Group";
    private static final String CASE_ROLE = "Role";
    private static final String CASE_DEFINITION_ID = "org.jbpm.case";
    final String serverTemplateId = "serverTemplateId";
    final CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
    @Mock
    CaseRolesPresenter.CaseRolesView view;
    @Mock
    CaseRolesValidations caseRolesValidations;
    @Mock
    CaseRolesPresenter.EditRoleAssignmentView editRoleAssignmentView;
    @Spy
    @InjectMocks
    CaseRolesPresenter presenter;
    CaseDefinitionSummary caseDefinition;
    private CaseRoleItemView caseRole;

    public CaseRolesPresenter getPresenter() {
        return this.presenter;
    }

    @Before
    public void setUp() {
        this.caseRole = (CaseRoleItemView)Mockito.mock(CaseRoleItemView.class);
    }

    @Test
    public void testClearCaseInstance() {
        ArrayList<CaseRoleAssignmentSummary> caseRoleAssignmentSummaryList = new ArrayList<CaseRoleAssignmentSummary>();
        caseRoleAssignmentSummaryList.add(CaseRoleAssignmentSummary.builder().name(CASE_ROLE).build());
        this.presenter.setCaseRolesAssignments(caseRoleAssignmentSummaryList);
        Assert.assertEquals((long)1L, (long)this.presenter.getCaseRolesAssignments().size());
        this.presenter.clearCaseInstance();
        Assert.assertEquals((long)0L, (long)this.presenter.getCaseRolesAssignments().size());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).removeAllRoles();
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).setBadge(0);
    }

    @Test
    public void testLoadCaseInstance_nonExistentCaseInstance() {
        this.presenter.loadCaseInstance(null);
        Assert.assertEquals((long)0L, (long)this.presenter.getCaseRolesAssignments().size());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.view});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.caseManagementService});
    }

    @Test
    public void testLoadCaseInstance_caseInstanceWithoutAssignments() {
        this.presenter.loadCaseInstance(this.caseInstance);
        Assert.assertEquals((long)0L, (long)this.presenter.getCaseRolesAssignments().size());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.view});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.caseManagementService});
    }

    @Test
    public void testLoadCaseInstance_caseInstanceWithoutCaseDefinitionId() {
        this.caseInstance.setCaseDefinitionId(null);
        this.caseInstance.setRoleAssignments(Collections.singletonList(CaseRoleAssignmentSummary.builder().name(CASE_ROLE).groups(Collections.singletonList(GROUP)).users(Collections.singletonList(USER)).build()));
        this.presenter.loadCaseInstance(this.caseInstance);
        Assert.assertEquals((long)0L, (long)this.presenter.getCaseRolesAssignments().size());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.view});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.caseManagementService});
    }

    @Test
    public void testLoadCaseInstance_nonExistentCaseDefinition() {
        this.caseInstance.setRoleAssignments(Collections.singletonList(CaseRoleAssignmentSummary.builder().name(CASE_ROLE).groups(Collections.singletonList(GROUP)).users(Collections.singletonList(USER)).build()));
        Mockito.when((Object)this.caseManagementService.getCaseDefinition(Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn(null);
        this.presenter.loadCaseInstance(this.caseInstance);
        Assert.assertEquals((long)0L, (long)this.presenter.getCaseRolesAssignments().size());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testLoadCaseInstance() {
        this.caseDefinition = CaseDefinitionSummary.builder().roles(Collections.singletonMap(CASE_ROLE, 3)).build();
        this.caseInstance.setRoleAssignments(Collections.singletonList(CaseRoleAssignmentSummary.builder().name(CASE_ROLE).groups(Collections.singletonList(GROUP)).users(Collections.singletonList(USER)).build()));
        this.setCaseDefinitionID(CASE_DEFINITION_ID, this.caseDefinition, this.caseInstance);
        Mockito.when((Object)this.caseManagementService.getCaseDefinition("serverTemplateId", this.caseInstance.getContainerId(), this.caseInstance.getCaseDefinitionId())).thenReturn((Object)this.caseDefinition);
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)"All");
        this.setupCaseInstance(this.caseInstance, "serverTemplateId");
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).removeAllRoles();
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).setBadge(0);
        ArgumentCaptor allRoleAssignments = ArgumentCaptor.forClass(List.class);
        ((CaseRolesPresenter)Mockito.verify((Object)this.presenter)).setCaseRolesAssignments((List)allRoleAssignments.capture());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).setBadge(this.caseInstance.getRoleAssignments().size());
        ((CaseRolesPresenter)Mockito.verify((Object)this.presenter)).filterCaseRoles();
        ArgumentCaptor displayedRoleAssignments = ArgumentCaptor.forClass(List.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).displayCaseRolesList((List)displayedRoleAssignments.capture());
        Assert.assertEquals((long)this.caseInstance.getRoleAssignments().size(), (long)((List)allRoleAssignments.getValue()).size());
        Assert.assertEquals((long)((List)allRoleAssignments.getValue()).size(), (long)((List)displayedRoleAssignments.getValue()).size());
        Assert.assertEquals((Object)CASE_ROLE, (Object)((CaseRoleAssignmentSummary)((List)displayedRoleAssignments.getValue()).get(0)).getName());
        Assert.assertEquals((Object)USER, ((CaseRoleAssignmentSummary)((List)displayedRoleAssignments.getValue()).get(0)).getUsers().get(0));
        Assert.assertEquals((Object)GROUP, ((CaseRoleAssignmentSummary)((List)displayedRoleAssignments.getValue()).get(0)).getGroups().get(0));
    }

    private void setCaseDefinitionID(String caseDefinitionID, CaseDefinitionSummary caseDefinition, CaseInstanceSummary caseInstance) {
        caseDefinition.setId(caseDefinitionID);
        caseInstance.setCaseDefinitionId(caseDefinitionID);
    }

    @Test
    public void testFilterCaseRoles_withoutResult() {
        this.caseInstance.setRoleAssignments(Collections.singletonList(CaseRoleAssignmentSummary.builder().name(CASE_ROLE).build()));
        this.presenter.setCaseRolesAssignments(this.caseInstance.getRoleAssignments());
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)"Assigned");
        this.presenter.filterCaseRoles();
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).displayEmptyList();
    }

    @Test
    public void testFilterCaseRoles_withResult() {
        String caseRole_1 = "Role_1";
        String caseRole_2 = "Role_2";
        String caseRole_3 = "Role_3";
        this.caseInstance.setRoleAssignments(Arrays.asList(this.createTestCaseRoleAssignmentSummary("Role_1", Collections.singletonList(USER), Collections.singletonList(GROUP)), this.createTestCaseRoleAssignmentSummary("Role_2", Collections.EMPTY_LIST, Collections.EMPTY_LIST), this.createTestCaseRoleAssignmentSummary("Role_3", Collections.EMPTY_LIST, Collections.singletonList(GROUP))));
        this.presenter.setCaseRolesAssignments(this.caseInstance.getRoleAssignments());
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)"All");
        this.presenter.filterCaseRoles();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).displayCaseRolesList((List)captor.capture());
        Assert.assertEquals((long)3L, (long)((List)captor.getValue()).size());
        Assert.assertEquals((Object)"Role_1", (Object)((CaseRoleAssignmentSummary)((List)captor.getValue()).get(0)).getName());
        Assert.assertEquals((Object)"Role_2", (Object)((CaseRoleAssignmentSummary)((List)captor.getValue()).get(1)).getName());
        Assert.assertEquals((Object)"Role_3", (Object)((CaseRoleAssignmentSummary)((List)captor.getValue()).get(2)).getName());
        Assert.assertEquals((Object)USER, ((CaseRoleAssignmentSummary)((List)captor.getValue()).get(0)).getUsers().get(0));
        Assert.assertEquals((Object)GROUP, ((CaseRoleAssignmentSummary)((List)captor.getValue()).get(0)).getGroups().get(0));
        Assert.assertEquals((Object)GROUP, ((CaseRoleAssignmentSummary)((List)captor.getValue()).get(2)).getGroups().get(0));
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)"Assigned");
        this.presenter.filterCaseRoles();
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(List.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).displayCaseRolesList((List)captor2.capture());
        Assert.assertEquals((long)2L, (long)((List)captor2.getValue()).size());
        Assert.assertEquals((Object)"Role_1", (Object)((CaseRoleAssignmentSummary)((List)captor2.getValue()).get(0)).getName());
        Assert.assertEquals((Object)"Role_3", (Object)((CaseRoleAssignmentSummary)((List)captor2.getValue()).get(1)).getName());
        Assert.assertEquals((Object)USER, ((CaseRoleAssignmentSummary)((List)captor2.getValue()).get(0)).getUsers().get(0));
        Assert.assertEquals((Object)GROUP, ((CaseRoleAssignmentSummary)((List)captor2.getValue()).get(0)).getGroups().get(0));
        Assert.assertEquals((Object)GROUP, ((CaseRoleAssignmentSummary)((List)captor2.getValue()).get(1)).getGroups().get(0));
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)"Unassigned");
        this.presenter.filterCaseRoles();
        ArgumentCaptor captor3 = ArgumentCaptor.forClass(List.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).displayCaseRolesList((List)captor3.capture());
        Assert.assertEquals((long)1L, (long)((List)captor3.getValue()).size());
        Assert.assertEquals((Object)"Role_2", (Object)((CaseRoleAssignmentSummary)((List)captor3.getValue()).get(0)).getName());
    }

    private CaseRoleAssignmentSummary createTestCaseRoleAssignmentSummary(String roleName, List<String> users, List<String> groups) {
        return CaseRoleAssignmentSummary.builder().name(roleName).users(users).groups(groups).build();
    }

    @Test
    public void testSetCaseRoleActions_ownerRole() {
        Mockito.when((Object)this.caseRole.getValue()).thenReturn((Object)CaseRoleAssignmentSummary.builder().name("owner").users(Collections.singletonList(USER)).build());
        this.presenter.setCaseRoleActions(this.caseRole);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).displayOwnerActions();
    }

    @Test
    public void testSetCaseRoleActions_roleWithExistingAssignments() {
        Mockito.when((Object)this.caseRole.getValue()).thenReturn((Object)CaseRoleAssignmentSummary.builder().name(CASE_ROLE).users(Collections.singletonList(USER)).build());
        this.presenter.setCaseRoleActions(this.caseRole);
        ArgumentCaptor caseRoleAction = ArgumentCaptor.forClass(CaseRolesPresenter.CaseRoleAction.class);
        ((CaseRolesPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).addCaseRoleAction((CaseRoleItemView)Matchers.eq((Object)this.caseRole), (CaseRolesPresenter.CaseRoleAction)caseRoleAction.capture());
        CaseRolesPresenter.CaseRoleAction editAction = (CaseRolesPresenter.CaseRoleAction)caseRoleAction.getAllValues().get(0);
        Assert.assertEquals((Object)"Edit", (Object)editAction.label());
        Assert.assertTrue((boolean)editAction.isEnabled());
        editAction.execute();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).showEditRoleAssignmentDialog();
        CaseRolesPresenter.CaseRoleAction removeAllAssignmentsAction = (CaseRolesPresenter.CaseRoleAction)caseRoleAction.getAllValues().get(1);
        Assert.assertEquals((Object)"RemoveAllAssignments", (Object)removeAllAssignmentsAction.label());
        Assert.assertTrue((boolean)removeAllAssignmentsAction.isEnabled());
        removeAllAssignmentsAction.execute();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).showRemoveAllAssignmentsPopup();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole, (VerificationMode)Mockito.never())).displayOwnerActions();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole, (VerificationMode)Mockito.times((int)2))).displayEnabledAction((CaseRolesPresenter.CaseRoleAction)Mockito.any(CaseRolesPresenter.CaseRoleAction.class));
    }

    @Test
    public void testSetCaseRoleActions_roleWithoutAssignments() {
        Mockito.when((Object)this.caseRole.getValue()).thenReturn((Object)CaseRoleAssignmentSummary.builder().name(CASE_ROLE).build());
        this.presenter.setCaseRoleActions(this.caseRole);
        ArgumentCaptor caseRoleAction = ArgumentCaptor.forClass(CaseRolesPresenter.CaseRoleAction.class);
        ((CaseRolesPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).addCaseRoleAction((CaseRoleItemView)Matchers.eq((Object)this.caseRole), (CaseRolesPresenter.CaseRoleAction)caseRoleAction.capture());
        CaseRolesPresenter.CaseRoleAction assignAction = (CaseRolesPresenter.CaseRoleAction)caseRoleAction.getAllValues().get(0);
        Assert.assertEquals((Object)"Assign", (Object)assignAction.label());
        Assert.assertTrue((boolean)assignAction.isEnabled());
        assignAction.execute();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).showEditRoleAssignmentDialog();
        CaseRolesPresenter.CaseRoleAction removeAllAssignmentsAction = (CaseRolesPresenter.CaseRoleAction)caseRoleAction.getAllValues().get(1);
        Assert.assertEquals((Object)"RemoveAllAssignments", (Object)removeAllAssignmentsAction.label());
        Assert.assertFalse((boolean)removeAllAssignmentsAction.isEnabled());
        removeAllAssignmentsAction.execute();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).showRemoveAllAssignmentsPopup();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole, (VerificationMode)Mockito.never())).displayOwnerActions();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).displayEnabledAction((CaseRolesPresenter.CaseRoleAction)Mockito.any(CaseRolesPresenter.CaseRoleAction.class));
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).displayDisabledAction((CaseRolesPresenter.CaseRoleAction)Mockito.any(CaseRolesPresenter.CaseRoleAction.class));
    }

    @Test
    public void testSetCaseRoleAssignments_ownerRole() {
        int assignmentsListMaxWidth = 70;
        Mockito.when((Object)this.caseRole.getValue()).thenReturn((Object)CaseRoleAssignmentSummary.builder().name("owner").users(Collections.singletonList(USER)).build());
        this.presenter.setCaseRoleAssignments(this.caseRole, 70);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).displayOwnerAssignment();
    }

    @Test
    public void testSetCaseRoleAssignments_roleWithoutAssignments() {
        int assignmentsListMaxWidth = 70;
        Mockito.when((Object)this.caseRole.getValue()).thenReturn((Object)CaseRoleAssignmentSummary.builder().name(CASE_ROLE).build());
        this.presenter.setCaseRoleAssignments(this.caseRole, 70);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).displayUnassigned();
    }

    @Test
    public void testSetCaseRoleAssignments_roleWithUserAssignmentsOnly() {
        int assignmentsListMaxWidth = 70;
        CaseRoleAssignmentSummary caseRoleAssignmentSummary = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).users(Collections.singletonList(USER)).build();
        Mockito.when((Object)this.caseRole.getValue()).thenReturn((Object)caseRoleAssignmentSummary);
        this.presenter.setCaseRoleAssignments(this.caseRole, 70);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole, (VerificationMode)Mockito.never())).hideUserAssignments();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).hideGroupAssignments();
        ArgumentCaptor itemsList = ArgumentCaptor.forClass(List.class);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).displayAssignmentsList((String)Matchers.eq((Object)CaseRoleItemView.USERS_LINE_ID), Matchers.eq((int)70), (List)itemsList.capture());
        Assert.assertEquals((long)caseRoleAssignmentSummary.getUsers().size(), (long)((List)itemsList.getValue()).size());
        CaseRolesPresenter.CaseAssignmentItem assignmentItem = (CaseRolesPresenter.CaseAssignmentItem)((List)itemsList.getValue()).get(0);
        String assignedUser = (String)caseRoleAssignmentSummary.getUsers().get(0);
        Assert.assertEquals((Object)assignedUser, (Object)assignmentItem.label());
        assignmentItem.execute();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).showRemoveUserAssignmentPopup(assignedUser);
    }

    @Test
    public void testSetCaseRoleAssignments_roleWithGroupAssignmentsOnly() {
        int assignmentsListMaxWidth = 70;
        CaseRoleAssignmentSummary caseRoleAssignmentSummary = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).groups(Collections.singletonList(GROUP)).build();
        Mockito.when((Object)this.caseRole.getValue()).thenReturn((Object)caseRoleAssignmentSummary);
        this.presenter.setCaseRoleAssignments(this.caseRole, 70);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).hideUserAssignments();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole, (VerificationMode)Mockito.never())).hideGroupAssignments();
        ArgumentCaptor itemsList = ArgumentCaptor.forClass(List.class);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).displayAssignmentsList((String)Matchers.eq((Object)CaseRoleItemView.GROUP_LINE_ID), Matchers.eq((int)70), (List)itemsList.capture());
        Assert.assertEquals((long)caseRoleAssignmentSummary.getGroups().size(), (long)((List)itemsList.getValue()).size());
        CaseRolesPresenter.CaseAssignmentItem assignmentItem = (CaseRolesPresenter.CaseAssignmentItem)((List)itemsList.getValue()).get(0);
        String assignedGroup = (String)caseRoleAssignmentSummary.getGroups().get(0);
        Assert.assertEquals((Object)assignedGroup, (Object)assignmentItem.label());
        assignmentItem.execute();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).showRemoveGroupAssignmentPopup(assignedGroup);
    }

    @Test
    public void testSetCaseRoleAssignments_roleWithUserAndGroupAssignments() {
        int assignmentsListMaxWidth = 70;
        CaseRoleAssignmentSummary caseRoleAssignmentSummary = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).users(Collections.singletonList(USER)).groups(Collections.singletonList(GROUP)).build();
        Mockito.when((Object)this.caseRole.getValue()).thenReturn((Object)caseRoleAssignmentSummary);
        this.presenter.setCaseRoleAssignments(this.caseRole, 70);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole, (VerificationMode)Mockito.never())).hideUserAssignments();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole, (VerificationMode)Mockito.never())).hideGroupAssignments();
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole, (VerificationMode)Mockito.times((int)2))).displayAssignmentsList(Matchers.anyString(), Matchers.eq((int)70), Mockito.anyListOf(CaseRolesPresenter.CaseAssignmentItem.class));
    }

    @Test
    public void testAssignToRole_noAssignmentsProvided() {
        CaseRoleAssignmentSummary newRoleAssignments = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).build();
        this.presenter.assignToRole(this.caseRole, newRoleAssignments);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).showErrorState();
        ArgumentCaptor errorList = ArgumentCaptor.forClass(List.class);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).showAssignmentErrors((List)errorList.capture());
        boolean errorsNumber = true;
        Assert.assertEquals((long)1L, (long)((List)errorList.getValue()).size());
        Assert.assertEquals((Object)"PleaseIntroUserOrGroupToCreateAssignment", ((List)errorList.getValue()).get(0));
    }

    @Test
    public void testAssignToRole_providedAssignmentsInvalid() {
        CaseRoleAssignmentSummary newRoleAssignments = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).users(Collections.singletonList(USER)).build();
        String error = "testError";
        Mockito.when((Object)this.caseRolesValidations.validateRolesAssignments(this.caseDefinition, Collections.singletonList(newRoleAssignments))).thenReturn(Collections.singletonList("testError"));
        this.presenter.assignToRole(this.caseRole, newRoleAssignments);
        ArgumentCaptor caseRoleAssignmentErrors = ArgumentCaptor.forClass(List.class);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).showAssignmentErrors((List)caseRoleAssignmentErrors.capture());
        boolean errorsNumber = true;
        Assert.assertEquals((long)1L, (long)((List)caseRoleAssignmentErrors.getValue()).size());
        Assert.assertEquals((Object)"testError", ((List)caseRoleAssignmentErrors.getValue()).get(0));
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole, (VerificationMode)Mockito.never())).hideEditRoleAssignmentDialog();
    }

    @Test
    public void testAssignToRole_providedAssignmentsCorrect() {
        CaseRoleAssignmentSummary currentRoleAssignments = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).build();
        CaseRoleAssignmentSummary newRoleAssignments = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).users(Collections.singletonList(USER)).build();
        Mockito.when((Object)this.caseRolesValidations.validateRolesAssignments(this.caseDefinition, Collections.singletonList(newRoleAssignments))).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.caseRole.getValue()).thenReturn((Object)currentRoleAssignments);
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)"All");
        this.presenter.assignToRole(this.caseRole, newRoleAssignments);
        ((CaseRoleItemView)Mockito.verify((Object)this.caseRole)).hideEditRoleAssignmentDialog();
        ((CaseRolesPresenter)Mockito.verify((Object)this.presenter)).storeRoleAssignments((CaseRoleAssignmentSummary)Mockito.any(CaseRoleAssignmentSummary.class), Mockito.anyListOf(String.class), Mockito.anyListOf(String.class));
    }

    @Test
    public void testStoreRoleAssignments_noChangesInRoleAssignments() {
        CaseRoleAssignmentSummary cras = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).users(Collections.singletonList(USER)).groups(Collections.singletonList(GROUP)).build();
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)"All");
        this.presenter.storeRoleAssignments(cras, new ArrayList<String>(Arrays.asList(USER)), new ArrayList<String>(Arrays.asList(GROUP)));
        this.verifyStoreRoleAssignmentsCalls(0, 0, 0, 0);
    }

    @Test
    public void testStoreRoleAssignments_removePreviousUser() {
        CaseRoleAssignmentSummary cras = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).users(Arrays.asList(USER, "test_user")).groups(Arrays.asList(GROUP, "test_group")).build();
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)"All");
        this.presenter.storeRoleAssignments(cras, new ArrayList<String>(Arrays.asList(USER)), new ArrayList<String>(Arrays.asList(GROUP)));
        this.verifyStoreRoleAssignmentsCalls(0, 0, 1, 1);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeUserFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"test_user"));
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeGroupFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"test_group"));
    }

    @Test
    public void testStoreRoleAssignments_replaceAssignment() {
        CaseRoleAssignmentSummary cras = this.createTestCaseRoleAssignmentSummary(CASE_ROLE, Collections.singletonList("test_user"), Collections.singletonList("test_group"));
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)"All");
        this.presenter.storeRoleAssignments(cras, new ArrayList<String>(Arrays.asList(USER)), new ArrayList<String>(Arrays.asList(GROUP)));
        this.verifyStoreRoleAssignmentsCalls(1, 1, 1, 1);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).assignUserToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)USER));
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).assignGroupToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)GROUP));
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeUserFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"test_user"));
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeGroupFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"test_group"));
    }

    private void verifyStoreRoleAssignmentsCalls(int timesAddUser, int timesAddGroup, int timesRemoveUser, int timesRemoveGroup) {
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)timesAddUser))).assignUserToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)timesAddGroup))).assignGroupToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)timesRemoveUser))).removeUserFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)timesRemoveGroup))).removeGroupFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testRemoveUserFromRole() {
        ArrayList<String> assignedUsersList = new ArrayList<String>();
        assignedUsersList.add(USER);
        CaseRoleAssignmentSummary roleAssignments = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).users(assignedUsersList).build();
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)"All");
        this.presenter.removeUserFromRole(USER, roleAssignments);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeUserFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)CASE_ROLE), (String)Matchers.eq((Object)USER));
        Assert.assertTrue((boolean)roleAssignments.getUsers().isEmpty());
        ((CaseRolesPresenter)Mockito.verify((Object)this.presenter)).filterCaseRoles();
    }

    @Test
    public void testRemoveGroupFromRole() {
        ArrayList<String> assignedGroupsList = new ArrayList<String>();
        assignedGroupsList.add(GROUP);
        CaseRoleAssignmentSummary roleAssignments = CaseRoleAssignmentSummary.builder().name(CASE_ROLE).groups(assignedGroupsList).build();
        Mockito.when((Object)this.view.getFilterValue()).thenReturn((Object)"All");
        this.presenter.removeGroupFromRole(GROUP, roleAssignments);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeGroupFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)CASE_ROLE), (String)Matchers.eq((Object)GROUP));
        Assert.assertTrue((boolean)roleAssignments.getGroups().isEmpty());
        ((CaseRolesPresenter)Mockito.verify((Object)this.presenter)).filterCaseRoles();
    }
}

