/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles;

import com.google.gwt.user.client.TakesValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.workbench.cm.client.roles.CaseRoleItemView;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenter;
import org.jbpm.workbench.cm.client.util.CaseRolesAssignmentFilterBy;
import org.jbpm.workbench.cm.client.util.CaseRolesValidations;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

@Dependent
@WorkbenchScreen(identifier="Case Roles")
public class CaseRolesPresenter
extends AbstractCaseInstancePresenter<CaseRolesView> {
    public static final String SCREEN_ID = "Case Roles";
    public static final String CASE_OWNER_ROLE = "owner";
    private CaseDefinitionSummary caseDefinition;
    private List<CaseRoleAssignmentSummary> caseRolesAssignments = new ArrayList<CaseRoleAssignmentSummary>();
    @Inject
    private CaseRolesValidations caseRolesValidations;

    @WorkbenchPartTitle
    public String getTittle() {
        return this.translationService.format("Roles", new Object[0]);
    }

    void setCaseRolesAssignments(List<CaseRoleAssignmentSummary> caseRolesAssignments) {
        this.caseRolesAssignments = caseRolesAssignments;
    }

    List<CaseRoleAssignmentSummary> getCaseRolesAssignments() {
        return this.caseRolesAssignments;
    }

    @Override
    protected void clearCaseInstance() {
        this.getCaseRolesAssignments().clear();
        ((CaseRolesView)this.view).removeAllRoles();
        ((CaseRolesView)this.view).setBadge(this.getCaseRolesAssignments().size());
    }

    @Override
    protected void loadCaseInstance(CaseInstanceSummary cis) {
        this.loadCaseRoles(cis);
    }

    protected void loadCaseRoles(CaseInstanceSummary cis) {
        if (cis == null || cis.getCaseDefinitionId() == null || cis.getRoleAssignments().isEmpty()) {
            return;
        }
        ((CaseManagementService)this.caseService.call(cds -> {
            if (cds == null) {
                return;
            }
            this.caseDefinition = cds;
            this.setCaseRolesAssignments(cis.getRoleAssignments());
            ((CaseRolesView)this.view).setBadge(this.getCaseRolesAssignments().size());
            this.filterCaseRoles();
        })).getCaseDefinition(this.serverTemplateId, this.containerId, cis.getCaseDefinitionId());
    }

    public void filterCaseRoles() {
        List<Object> filteredCaseRoles;
        switch (CaseRolesAssignmentFilterBy.valueOf(((CaseRolesView)this.view).getFilterValue().toUpperCase())) {
            case ASSIGNED: {
                filteredCaseRoles = this.getCaseRolesAssignments().stream().filter(CaseRoleAssignmentSummary::hasAssignment).collect(Collectors.toList());
                break;
            }
            case UNASSIGNED: {
                filteredCaseRoles = this.getCaseRolesAssignments().stream().filter(caseRoleAssignmentSummary -> !caseRoleAssignmentSummary.hasAssignment()).collect(Collectors.toList());
                break;
            }
            default: {
                filteredCaseRoles = this.getCaseRolesAssignments();
            }
        }
        if (filteredCaseRoles.isEmpty()) {
            ((CaseRolesView)this.view).displayEmptyList();
        } else {
            ((CaseRolesView)this.view).displayCaseRolesList(filteredCaseRoles);
        }
    }

    public void setCaseRoleActions(final CaseRoleItemView caseRole) {
        CaseRoleAssignmentSummary caseRoleAssignmentSummary = caseRole.getValue();
        if (CASE_OWNER_ROLE.equals(caseRoleAssignmentSummary.getName())) {
            caseRole.displayOwnerActions();
        } else {
            final boolean hasAssignment = caseRoleAssignmentSummary.hasAssignment();
            this.addCaseRoleAction(caseRole, new CaseRoleAction(){

                @Override
                public String label() {
                    if (hasAssignment) {
                        return CaseRolesPresenter.this.translationService.format("Edit", new Object[0]);
                    }
                    return CaseRolesPresenter.this.translationService.format("Assign", new Object[0]);
                }

                @Override
                public boolean isEnabled() {
                    return true;
                }

                public void execute() {
                    caseRole.showEditRoleAssignmentDialog();
                }
            });
            this.addCaseRoleAction(caseRole, new CaseRoleAction(){

                @Override
                public String label() {
                    return CaseRolesPresenter.this.translationService.format("RemoveAllAssignments", new Object[0]);
                }

                @Override
                public boolean isEnabled() {
                    return hasAssignment;
                }

                public void execute() {
                    caseRole.showRemoveAllAssignmentsPopup();
                }
            });
        }
    }

    void addCaseRoleAction(CaseRoleItemView caseRole, CaseRoleAction caseRoleAction) {
        if (caseRoleAction.isEnabled()) {
            caseRole.displayEnabledAction(caseRoleAction);
        } else {
            caseRole.displayDisabledAction(caseRoleAction);
        }
    }

    public void setCaseRoleAssignments(CaseRoleItemView caseRole, int assignmentsListMaxWidth) {
        CaseRoleAssignmentSummary caseRoleAssignmentSummary = caseRole.getValue();
        if (!caseRoleAssignmentSummary.hasAssignment()) {
            caseRole.displayUnassigned();
            return;
        }
        if (CASE_OWNER_ROLE.equals(caseRoleAssignmentSummary.getName())) {
            caseRole.displayOwnerAssignment();
        } else {
            ArrayList<CaseAssignmentItem> itemsList;
            if (caseRoleAssignmentSummary.getUsers().size() == 0) {
                caseRole.hideUserAssignments();
            } else {
                itemsList = new ArrayList<CaseAssignmentItem>();
                caseRoleAssignmentSummary.getUsers().forEach(user -> itemsList.add(new CaseAssignmentItem((String)user, caseRole){
                    final /* synthetic */ String val$user;
                    final /* synthetic */ CaseRoleItemView val$caseRole;
                    {
                        this.val$user = string;
                        this.val$caseRole = caseRoleItemView;
                    }

                    @Override
                    public String label() {
                        return this.val$user;
                    }

                    public void execute() {
                        this.val$caseRole.showRemoveUserAssignmentPopup(this.val$user);
                    }
                }));
                caseRole.displayAssignmentsList(CaseRoleItemView.USERS_LINE_ID, assignmentsListMaxWidth, itemsList);
            }
            if (caseRoleAssignmentSummary.getGroups().size() == 0) {
                caseRole.hideGroupAssignments();
            } else {
                itemsList = new ArrayList();
                caseRoleAssignmentSummary.getGroups().forEach(group -> itemsList.add(new CaseAssignmentItem((String)group, caseRole){
                    final /* synthetic */ String val$group;
                    final /* synthetic */ CaseRoleItemView val$caseRole;
                    {
                        this.val$group = string;
                        this.val$caseRole = caseRoleItemView;
                    }

                    @Override
                    public String label() {
                        return this.val$group;
                    }

                    public void execute() {
                        this.val$caseRole.showRemoveGroupAssignmentPopup(this.val$group);
                    }
                }));
                caseRole.displayAssignmentsList(CaseRoleItemView.GROUP_LINE_ID, assignmentsListMaxWidth, itemsList);
            }
        }
    }

    void assignToRole(CaseRoleItemView caseRole, CaseRoleAssignmentSummary newRoleAssignments) {
        if (!newRoleAssignments.hasAssignment()) {
            caseRole.showErrorState();
            caseRole.showAssignmentErrors(Collections.singletonList(this.translationService.format("PleaseIntroUserOrGroupToCreateAssignment", new Object[0])));
            return;
        }
        List<String> caseRoleAssignmentErrors = this.caseRolesValidations.validateRolesAssignments(this.caseDefinition, Collections.singletonList(newRoleAssignments));
        if (!caseRoleAssignmentErrors.isEmpty()) {
            caseRole.showAssignmentErrors(caseRoleAssignmentErrors);
        } else {
            caseRole.hideEditRoleAssignmentDialog();
            CaseRoleAssignmentSummary currentRoleAssignments = caseRole.getValue();
            this.storeRoleAssignments(currentRoleAssignments, newRoleAssignments.getUsers(), newRoleAssignments.getGroups());
        }
    }

    public void storeRoleAssignments(CaseRoleAssignmentSummary currentRoleAssignments, List<String> users, List<String> groups) {
        String roleName = currentRoleAssignments.getName();
        List prevUserAssignments = currentRoleAssignments.getUsers();
        List prevGroupsAssignments = currentRoleAssignments.getGroups();
        List<String> newUserAssignments = users.stream().distinct().collect(Collectors.toList());
        List<String> newGroupsAssignments = groups.stream().distinct().collect(Collectors.toList());
        currentRoleAssignments.setUsers(new ArrayList(newUserAssignments));
        currentRoleAssignments.setGroups(new ArrayList(newGroupsAssignments));
        this.filterCaseRoles();
        ArrayList usersToRemove = new ArrayList(prevUserAssignments);
        usersToRemove.removeAll(newUserAssignments);
        usersToRemove.forEach(user -> ((CaseManagementService)this.caseService.call()).removeUserFromRole(this.serverTemplateId, this.containerId, this.caseId, roleName, user));
        newUserAssignments.removeAll(prevUserAssignments);
        newUserAssignments.forEach(user -> ((CaseManagementService)this.caseService.call()).assignUserToRole(this.serverTemplateId, this.containerId, this.caseId, roleName, user));
        ArrayList groupsToRemove = new ArrayList(prevGroupsAssignments);
        groupsToRemove.removeAll(newGroupsAssignments);
        groupsToRemove.forEach(group -> ((CaseManagementService)this.caseService.call()).removeGroupFromRole(this.serverTemplateId, this.containerId, this.caseId, roleName, group));
        newGroupsAssignments.removeAll(prevGroupsAssignments);
        newGroupsAssignments.forEach(group -> ((CaseManagementService)this.caseService.call()).assignGroupToRole(this.serverTemplateId, this.containerId, this.caseId, roleName, group));
    }

    protected void removeUserFromRole(String userName, CaseRoleAssignmentSummary caseRoleAssignmentSummary) {
        ((CaseManagementService)this.caseService.call(Void2 -> {
            List users = caseRoleAssignmentSummary.getUsers();
            users.remove(userName);
            caseRoleAssignmentSummary.setUsers(users);
            this.filterCaseRoles();
        })).removeUserFromRole(this.serverTemplateId, this.containerId, this.caseId, caseRoleAssignmentSummary.getName(), userName);
    }

    protected void removeGroupFromRole(String groupName, CaseRoleAssignmentSummary caseRoleAssignmentSummary) {
        ((CaseManagementService)this.caseService.call(Void2 -> {
            List groups = caseRoleAssignmentSummary.getGroups();
            groups.remove(groupName);
            caseRoleAssignmentSummary.setGroups(groups);
            this.filterCaseRoles();
        })).removeGroupFromRole(this.serverTemplateId, this.containerId, this.caseId, caseRoleAssignmentSummary.getName(), groupName);
    }

    public static interface CaseAssignmentItem
    extends Command {
        public String label();
    }

    public static interface CaseRoleAction
    extends Command {
        public String label();

        public boolean isEnabled();
    }

    public static interface EditRoleAssignmentView
    extends UberElement<CaseRolesPresenter>,
    TakesValue<CaseRoleAssignmentSummary> {
        public void show(Command var1);

        public void hide();

        public void setErrorState();

        public void showValidationError(List<String> var1);
    }

    public static interface CaseRolesView
    extends UberElement<CaseRolesPresenter> {
        public void removeAllRoles();

        public void displayCaseRolesList(List<CaseRoleAssignmentSummary> var1);

        public void displayEmptyList();

        public String getFilterValue();

        public void setBadge(int var1);
    }
}

