/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jbpm.workbench.cm.client.util.CommaListValuesConverter;
import org.junit.Assert;
import org.junit.Test;

public class CommaListValuesConverterTest {
    @Test
    public void testParsingStringToList() {
        this.assertToModelValue(" ", 0, new String[0]);
        this.assertToModelValue("test", 1, "test");
        this.assertToModelValue("test1, test2", 2, "test1", "test2");
        this.assertToModelValue(" test1, test2, ", 2, "test1", "test2");
        this.assertToModelValue(",test1, ,  ,test2  ,, ", 2, "test1", "test2");
        this.assertToModelValue("+;,test1,&, % ,test2", 5, "+;", "%", "test1");
        this.assertToModelValue("test1 test2", 1, "test1 test2");
    }

    @Test
    public void testParsingListToString() {
        this.assertToWidgetValue(Collections.emptyList(), "");
        this.assertToWidgetValue(Arrays.asList("test1", "test2"), "test1, test2");
    }

    private void assertToModelValue(String value, int size, String ... values) {
        List modelValue = new CommaListValuesConverter().toModelValue(value);
        Assert.assertEquals((long)size, (long)modelValue.size());
        for (String expectedValue : values) {
            Assert.assertTrue((boolean)modelValue.contains(expectedValue));
        }
    }

    private void assertToWidgetValue(List<String> values, String value) {
        String widgetValue = new CommaListValuesConverter().toWidgetValue(values);
        Assert.assertEquals((Object)value, (Object)widgetValue);
    }
}

