/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.list;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.list.CaseInstanceListPresenter;
import org.jbpm.workbench.cm.client.list.CaseInstanceListSearchViewImpl;
import org.jbpm.workbench.cm.client.list.CaseInstanceViewImpl;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.util.CaseInstanceSearchRequest;

@Dependent
@Templated(stylesheet="CaseInstanceListViewImpl.css")
public class CaseInstanceListViewImpl
extends AbstractView<CaseInstanceListPresenter>
implements CaseInstanceListPresenter.CaseInstanceListView {
    @Inject
    @DataField(value="search-actions")
    private CaseInstanceListSearchViewImpl actions;
    @Inject
    @DataField(value="empty-list-item")
    private Div emptyContainer;
    @Inject
    @DataField(value="list-view")
    private Div viewContainer;
    @Inject
    @AutoBound
    private DataBinder<List<CaseInstanceSummary>> caseInstanceList;
    @Inject
    @Bound
    @DataField(value="list-container")
    private ListComponent<CaseInstanceSummary, CaseInstanceViewImpl> list;

    @Override
    public void init(CaseInstanceListPresenter presenter) {
        super.init(presenter);
        this.actions.init(presenter);
        this.list.addComponentCreationHandler(v -> v.init(presenter));
    }

    public void setValue(CaseInstanceSearchRequest value) {
        this.actions.setValue(value);
    }

    public CaseInstanceSearchRequest getValue() {
        return this.actions.getValue();
    }

    @Override
    public void setCaseInstanceList(List<CaseInstanceSummary> caseInstanceList) {
        this.caseInstanceList.setModel(caseInstanceList);
        if (caseInstanceList.isEmpty()) {
            DOMUtil.removeCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        }
    }

    public HTMLElement getElement() {
        return this.viewContainer;
    }
}

