/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles;

import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.roles.CaseRolesPresenter;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.client.util.CommaListValuesConverter;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.uberfire.client.views.pfly.widgets.FormGroup;
import org.uberfire.client.views.pfly.widgets.FormLabel;
import org.uberfire.client.views.pfly.widgets.InlineNotification;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Modal;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.client.views.pfly.widgets.ValidationState;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class EditRoleAssignmentViewImpl
extends AbstractView<CaseRolesPresenter>
implements CaseRolesPresenter.EditRoleAssignmentView {
    @Inject
    @DataField(value="role-name-group")
    FormGroup roleNameGroup;
    @Inject
    @DataField(value="role-name-help")
    Span roleNameHelp;
    @Inject
    @Bound
    @DataField(value="role-name-text")
    Span name;
    @Inject
    @DataField(value="role-name-label")
    FormLabel roleNameLabel;
    @Inject
    @DataField(value="assignment-label")
    FormLabel assignmentLabel;
    @Inject
    @Bound(converter=CommaListValuesConverter.class)
    @DataField(value="user-name-input")
    TextInput users;
    @Inject
    @DataField(value="user-name-group")
    FormGroup userNameGroup;
    @Inject
    @Bound(converter=CommaListValuesConverter.class)
    @DataField(value="group-name-input")
    TextInput groups;
    @Inject
    @DataField(value="group-name-help")
    Span groupNameHelp;
    @Inject
    @DataField(value="group-name-group")
    FormGroup groupNameGroup;
    @Inject
    private JQueryProducer.JQuery<Popover> jQueryPopover;
    @Inject
    @DataField(value="alert")
    private InlineNotification notification;
    @Inject
    @DataField(value="roles-help")
    private Anchor rolesHelp;
    @Inject
    @DataField(value="modal")
    private Modal modal;
    @Inject
    @AutoBound
    private DataBinder<CaseRoleAssignmentSummary> binder;
    private Command okCommand;
    @Inject
    private TranslationService translationService;

    @PostConstruct
    public void init() {
        this.roleNameLabel.addRequiredIndicator();
        this.assignmentLabel.addRequiredIndicator();
        this.rolesHelp.setAttribute("data-content", this.translationService.getTranslation("RolesInfoText"));
        ((Popover)this.jQueryPopover.wrap((Element)this.rolesHelp)).popover();
        this.notification.setType(InlineNotification.InlineNotificationType.DANGER);
    }

    @Override
    public void init(CaseRolesPresenter presenter) {
    }

    public CaseRoleAssignmentSummary getValue() {
        return (CaseRoleAssignmentSummary)this.binder.getModel();
    }

    public void setValue(CaseRoleAssignmentSummary caseRoleAssignmentSummary) {
        this.binder.setModel((Object)caseRoleAssignmentSummary);
    }

    @Override
    public void showValidationError(List<String> messages) {
        this.notification.setMessage(messages);
        DOMUtil.removeCSSClass((HTMLElement)this.notification.getElement(), (String)"hidden");
    }

    @Override
    public void show(Command okCommand) {
        this.clearErrorMessages();
        this.okCommand = okCommand;
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void setErrorState() {
        this.users.focus();
        this.userNameGroup.setValidationState(ValidationState.ERROR);
        this.groupNameGroup.setValidationState(ValidationState.ERROR);
    }

    private void clearErrorMessages() {
        DOMUtil.addCSSClass((HTMLElement)this.notification.getElement(), (String)"hidden");
        this.notification.setMessage("");
        this.roleNameHelp.setTextContent("");
        this.groupNameHelp.setTextContent("");
        this.roleNameGroup.clearValidationState();
        this.userNameGroup.clearValidationState();
        this.groupNameGroup.clearValidationState();
    }

    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    @EventHandler(value={"assign"})
    public void onAssignClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.clearErrorMessages();
        Optional.ofNullable(this.okCommand).ifPresent(Command::execute);
    }

    @EventHandler(value={"cancel"})
    public void onCancelClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }
}

