/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.milestones;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.jbpm.workbench.cm.client.milestones.CaseMilestoneListPresenter;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.workbench.cm.client.util.CaseMilestoneStatus;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseMilestoneSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.jbpm.workbench.cm.util.CaseMilestoneSearchRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseMilestonesPresenterTest
extends AbstractCaseInstancePresenterTest {
    final String serverTemplateId = "serverTemplateId";
    final String containerId = "containerId";
    final String caseDefId = "caseDefinitionId";
    final String caseId = "caseId";
    @Mock
    CaseMilestoneListPresenter.CaseMilestoneListView caseMilestoneListView;
    @InjectMocks
    CaseMilestoneListPresenter presenter;
    List<CaseMilestoneSummary> caseMilestonesSummaryList = Lists.newArrayList((Object[])new CaseMilestoneSummary[]{CaseMilestonesPresenterTest.createCaseMilestone()});
    CaseInstanceSummary cis;

    private static CaseMilestoneSummary createCaseMilestone() {
        return CaseMilestoneSummary.builder().identifier("identifier").name("milestoneName").status(CaseMilestoneStatus.AVAILABLE.getStatus()).achieved(false).build();
    }

    public CaseMilestoneListPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    @Before
    public void init() {
        this.caseService = new CallerMock((Object)this.caseManagementService);
        Mockito.when((Object)this.caseManagementService.getCaseMilestones(Mockito.anyString(), Mockito.anyString(), (CaseMilestoneSearchRequest)Mockito.any(CaseMilestoneSearchRequest.class))).thenReturn(this.caseMilestonesSummaryList);
        Mockito.when((Object)this.caseMilestoneListView.getCaseMilestoneSearchRequest()).thenReturn((Object)new CaseMilestoneSearchRequest());
        this.presenter.setCaseService(this.caseService);
        this.cis = CaseInstanceSummary.builder().containerId("containerId").caseId("caseId").caseDefinitionId("caseDefinitionId").build();
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().id("caseDefinitionId").build();
        Mockito.when((Object)this.caseManagementService.getCaseDefinition(this.cis.getContainerId(), this.cis.getCaseDefinitionId())).thenReturn((Object)cds);
        List<CaseMilestoneSummary> milestones = Collections.singletonList(CaseMilestonesPresenterTest.createCaseMilestone());
        Mockito.when((Object)this.caseManagementService.getCaseMilestones(Mockito.anyString(), Mockito.anyString(), (CaseMilestoneSearchRequest)Mockito.any(CaseMilestoneSearchRequest.class))).thenReturn(milestones);
    }

    @Test
    public void testClearCaseInstance() {
        this.presenter.clearCaseInstance();
        this.verifyClearCaseInstance();
    }

    private void verifyClearCaseInstance() {
        ((CaseMilestoneListPresenter.CaseMilestoneListView)Mockito.verify((Object)this.caseMilestoneListView)).removeAllMilestones();
    }

    @Test
    public void testLoadCaseInstance() {
        List<CaseMilestoneSummary> milestones = Collections.singletonList(CaseMilestonesPresenterTest.createCaseMilestone());
        Mockito.when((Object)this.caseManagementService.getCaseMilestones(Mockito.anyString(), Mockito.anyString(), (CaseMilestoneSearchRequest)Mockito.any(CaseMilestoneSearchRequest.class))).thenReturn(milestones);
        this.setupCaseInstance(this.cis);
        this.verifyClearCaseInstance();
        ((CaseMilestoneListPresenter.CaseMilestoneListView)Mockito.verify((Object)this.caseMilestoneListView)).setCaseMilestoneList(milestones);
    }

    @Test
    public void testRefreshData() {
        this.setupCaseInstance(this.cis);
        this.presenter.searchCaseMilestones();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)2))).getCaseMilestones(this.cis.getContainerId(), this.cis.getCaseId(), this.caseMilestoneListView.getCaseMilestoneSearchRequest());
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseMilestoneListPresenter.CaseMilestoneListView)Mockito.verify((Object)this.caseMilestoneListView, (VerificationMode)Mockito.times((int)2))).setCaseMilestoneList((List)captor.capture());
        Assert.assertEquals((long)this.caseMilestonesSummaryList.size(), (long)((List)captor.getValue()).size());
    }
}

