/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.actions;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.actions.CaseActionsListViewImpl;
import org.jbpm.workbench.cm.client.actions.CaseActionsPresenter;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.model.CaseActionSummary;

@Dependent
@Templated
public class CaseActionsViewImpl
extends AbstractView<CaseActionsPresenter>
implements CaseActionsPresenter.CaseActionsView {
    public static final String AVAILABLE_ACTIONS = "AVAILABLE";
    public static final String INPROGRESS_ACTIONS = "IN_PROGRESS";
    public static final String COMPLETED_ACTIONS = "COMPLETED";
    @Inject
    @DataField(value="available-actions")
    CaseActionsListViewImpl availableActions;
    @Inject
    @DataField(value="inprogress-actions")
    CaseActionsListViewImpl inprogressActions;
    @Inject
    @DataField(value="completed-actions")
    CaseActionsListViewImpl completedActions;
    @Inject
    @DataField(value="actions")
    private Div actionsContainer;
    @Inject
    private TranslationService translationService;

    @Override
    public void init(CaseActionsPresenter presenter) {
        this.presenter = presenter;
        this.availableActions.init(presenter);
        this.inprogressActions.init(presenter);
        this.completedActions.init(presenter);
    }

    public HTMLElement getElement() {
        return this.actionsContainer;
    }

    @Override
    public void removeAllTasks() {
        this.availableActions.removeAllTasks();
        this.inprogressActions.removeAllTasks();
        this.completedActions.removeAllTasks();
    }

    @Override
    public void setAvailableActionsList(List<CaseActionSummary> caseActionList) {
        this.availableActions.setCaseActionList(caseActionList);
    }

    @Override
    public void setInProgressActionsList(List<CaseActionSummary> caseActionList) {
        this.inprogressActions.setCaseActionList(caseActionList);
    }

    @Override
    public void setCompletedActionsList(List<CaseActionSummary> caseActionList) {
        this.completedActions.setCaseActionList(caseActionList);
    }

    @Override
    public void updateListHeaders() {
        this.availableActions.updateActionsHeader(this.translationService.format(AVAILABLE_ACTIONS, new Object[0]), "fa", "fa-flag-o", "kie-card__subtitle-icon", "kie-card__subtitle-icon--available");
        this.inprogressActions.updateActionsHeader(this.translationService.format(INPROGRESS_ACTIONS, new Object[0]), "fa", "fa-flag-checkered", "kie-card__subtitle-icon", "kie-card__subtitle-icon--inprogress");
        this.completedActions.updateActionsHeader(this.translationService.format(COMPLETED_ACTIONS, new Object[0]), "fa", "fa-flag", "kie-card__subtitle-icon", "kie-card__subtitle-icon--complete");
    }
}

