/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.client.util.CaseRolesValidations;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseRolesValidationsTest {
    @Mock
    private TranslationService translationService;
    @InjectMocks
    private CaseRolesValidations caseRolesValidations;

    @Test
    public void testValidateRolesAssignments_roleCardinalityReached() {
        Map<String, Integer> role = Collections.singletonMap("test", 1);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(role).build();
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(CaseRoleAssignmentSummary.builder().name("test").users(Collections.singletonList("user1")).build());
        List errors = this.caseRolesValidations.validateRolesAssignments(cds, roles);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format(Mockito.anyString(), new Object[]{Mockito.anyString(), Mockito.anyInt()});
        Assertions.assertThat((List)errors).isEmpty();
    }

    @Test
    public void testValidateRolesAssignments_roleCardinalityExceeded() {
        String caseRole = "test";
        Integer caseRoleCardinality = 1;
        Map<String, Integer> role = Collections.singletonMap("test", caseRoleCardinality);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(role).build();
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(CaseRoleAssignmentSummary.builder().name("test").users(Collections.singletonList("user1")).groups(Collections.singletonList("group1")).build());
        List errors = this.caseRolesValidations.validateRolesAssignments(cds, roles);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format((String)Mockito.eq((Object)"InvalidRoleAssignment"), new Object[]{Mockito.eq((Object)"test"), Mockito.eq((Object)caseRoleCardinality)});
        Assertions.assertThat((List)errors).hasSize(1);
    }

    @Test
    public void testValidateRolesAssignments_multipleRolesCardinalityExceeded() {
        HashMap<String, Integer> roles = new HashMap<String, Integer>();
        Integer roleCardinality = 1;
        roles.put("caseRole1", roleCardinality);
        roles.put("caseRole2", roleCardinality);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(roles).build();
        ArrayList<CaseRoleAssignmentSummary> roleAssignments = new ArrayList<CaseRoleAssignmentSummary>();
        roleAssignments.add(CaseRoleAssignmentSummary.builder().name("caseRole1").users(Collections.singletonList("user1")).groups(Collections.singletonList("group1")).build());
        ArrayList<String> assignedUsers = new ArrayList<String>();
        assignedUsers.add("user2");
        assignedUsers.add("user3");
        roleAssignments.add(CaseRoleAssignmentSummary.builder().name("caseRole2").users(assignedUsers).build());
        List errors = this.caseRolesValidations.validateRolesAssignments(cds, roleAssignments);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.times((int)2))).format((String)Mockito.eq((Object)"InvalidRoleAssignment"), new Object[]{Mockito.anyString(), Mockito.eq((Object)roleCardinality)});
        Assertions.assertThat((List)errors).hasSize(2);
    }

    @Test
    public void testValidateRolesAssignments_roleWithInfiniteCardinality() {
        String caseRole = "test";
        Integer caseRoleCardinality = -1;
        Map<String, Integer> role = Collections.singletonMap("test", caseRoleCardinality);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(role).build();
        CaseRoleAssignmentSummary caseRoleAssignmentSummaryMock = (CaseRoleAssignmentSummary)Mockito.mock(CaseRoleAssignmentSummary.class);
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(caseRoleAssignmentSummaryMock);
        Mockito.when((Object)caseRoleAssignmentSummaryMock.getName()).thenReturn((Object)"test");
        Mockito.when((Object)caseRoleAssignmentSummaryMock.getUsers()).thenReturn(null);
        try {
            this.caseRolesValidations.validateRolesAssignments(cds, roles);
        }
        catch (NullPointerException e) {
            Assert.fail((String)("Case role cardinality = " + caseRoleCardinality + ", role assignments check should be skipped"));
        }
    }
}

