/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.milestones;

import com.google.gwt.user.client.TakesValue;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.milestones.CaseMilestoneListPresenter;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.client.util.CaseMilestoneStatus;
import org.jbpm.workbench.cm.client.util.DateConverter;
import org.jbpm.workbench.cm.model.CaseMilestoneSummary;

@Dependent
@Templated
public class CaseMilestoneItemView
extends AbstractView<CaseMilestoneListPresenter>
implements TakesValue<CaseMilestoneSummary>,
IsElement {
    @Inject
    protected TranslationService translationService;
    @Inject
    @DataField(value="milestone-name")
    @Bound
    Span name;
    @Inject
    @DataField(value="milestone-status")
    Span status;
    @Inject
    @DataField(value="list-group-item")
    Div listGroupItem;
    @Inject
    @AutoBound
    private DataBinder<CaseMilestoneSummary> caseMilestoneSummary;

    @PostConstruct
    public void init() {
        this.tooltip((HTMLElement)this.status);
    }

    public HTMLElement getElement() {
        return this.listGroupItem;
    }

    public CaseMilestoneSummary getValue() {
        return (CaseMilestoneSummary)this.caseMilestoneSummary.getModel();
    }

    public void setValue(CaseMilestoneSummary model) {
        this.caseMilestoneSummary.setModel((Object)model);
        CaseMilestoneStatus milestoneStatus = CaseMilestoneStatus.fromStatus(model.getStatus());
        switch (milestoneStatus) {
            case AVAILABLE: {
                this.showMilestoneStatus(this.translationService.format("MilestoneHasNotBeenCompleted", new Object[0]), "fa-flag", "fa-process-flow-bxms");
                break;
            }
            case COMPLETED: {
                String achievedAtStr = DateConverter.getDateStr(model.getAchievedAt());
                this.showMilestoneStatus(this.translationService.format("MilestoneHasBeenCompleted", new Object[]{achievedAtStr.isEmpty() ? "" : "(" + achievedAtStr + ")"}), "fa-check", "kie-milestones__icon--completed");
                DOMUtil.addCSSClass((HTMLElement)this.listGroupItem, (String)"kie-milestones__item--completed");
                break;
            }
            case TERMINATED: {
                String achievedAtStr = DateConverter.getDateStr(model.getAchievedAt());
                this.showMilestoneStatus(this.translationService.format("MilestoneHasBeenTerminated", new Object[]{achievedAtStr.isEmpty() ? "" : "(" + achievedAtStr + ")"}), "fa-close", "kie-milestones__icon--terminated");
                DOMUtil.addCSSClass((HTMLElement)this.listGroupItem, (String)"kie-milestones__item--terminated");
                break;
            }
        }
    }

    public void showMilestoneStatus(String tooltipTitle, String ... stylesClass) {
        this.status.setAttribute("data-original-title", tooltipTitle);
        for (String styleClass : stylesClass) {
            DOMUtil.addCSSClass((HTMLElement)this.status, (String)styleClass);
        }
    }
}

