/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.util;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;

@Dependent
public class CaseRolesValidations {
    @Inject
    TranslationService translationService;

    public List<String> validateRolesAssignments(CaseDefinitionSummary caseDefinition, List<CaseRoleAssignmentSummary> assignments) {
        ArrayList<String> errors = new ArrayList<String>();
        assignments.forEach(a -> {
            Integer roleCardinality = (Integer)caseDefinition.getRoles().get(a.getName());
            if (roleCardinality == -1) {
                return;
            }
            Integer roleAssignments = a.getUsers().size() + a.getGroups().size();
            if (roleAssignments > roleCardinality) {
                errors.add(this.translationService.format("InvalidRoleAssignment", new Object[]{a.getName(), roleCardinality}));
            }
        });
        return errors;
    }
}

