/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.newcase;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.client.events.CaseCreatedEvent;
import org.jbpm.workbench.cm.client.util.AbstractPresenter;
import org.jbpm.workbench.cm.client.util.CaseRolesValidations;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class NewCaseInstancePresenter
extends AbstractPresenter<NewCaseInstanceView> {
    @Inject
    CaseRolesValidations caseRolesValidations;
    private List<CaseDefinitionSummary> caseDefinitions = Collections.emptyList();
    private Caller<CaseManagementService> caseService;
    private Event<NotificationEvent> notification;
    private Event<CaseCreatedEvent> newCaseEvent;
    @Inject
    private TranslationService translationService;
    @Inject
    private User identity;

    protected void loadCaseRoles(String caseDefinitionId) {
        ((NewCaseInstanceView)this.view).clearRoles();
        Optional<CaseDefinitionSummary> cds = this.getCaseDefinitionSummary(caseDefinitionId);
        cds.ifPresent(d -> ((NewCaseInstanceView)this.view).setRoles(d.getRoles().keySet().stream().filter(r -> !"owner".equals(r)).map(r -> CaseRoleAssignmentSummary.builder().name(r).build()).collect(Collectors.toList())));
    }

    private Optional<CaseDefinitionSummary> getCaseDefinitionSummary(String caseDefinitionId) {
        return this.caseDefinitions.stream().filter(d -> d.getUniqueId().equals(caseDefinitionId)).findFirst();
    }

    public void show() {
        this.loadCaseDefinitions();
    }

    protected void loadCaseDefinitions() {
        ((NewCaseInstanceView)this.view).clearCaseDefinitions();
        this.caseDefinitions.clear();
        ((CaseManagementService)this.caseService.call(definitions -> {
            if (definitions.isEmpty()) {
                this.notification.fire((Object)new NotificationEvent(this.translationService.format("NoCaseDefinition", new Object[0]), NotificationEvent.NotificationType.ERROR));
                return;
            }
            this.caseDefinitions = definitions;
            ((NewCaseInstanceView)this.view).show();
            ((NewCaseInstanceView)this.view).setCaseDefinitions(this.caseDefinitions);
            ((NewCaseInstanceView)this.view).setOwner(this.identity.getIdentifier());
        })).getCaseDefinitions();
    }

    protected void createCaseInstance(String caseDefinitionId, String owner, List<CaseRoleAssignmentSummary> assignments) {
        Optional<CaseDefinitionSummary> cds = this.getCaseDefinitionSummary(caseDefinitionId);
        if (cds.isPresent()) {
            CaseDefinitionSummary caseDefinition = cds.get();
            List<String> assignmentErrors = this.caseRolesValidations.validateRolesAssignments(caseDefinition, assignments);
            if (!assignmentErrors.isEmpty()) {
                ((NewCaseInstanceView)this.view).showError(assignmentErrors);
                return;
            }
            ((CaseManagementService)this.caseService.call(caseId -> {
                ((NewCaseInstanceView)this.view).hide();
                this.notification.fire((Object)new NotificationEvent(this.translationService.format("CaseCreatedWithId", new Object[]{caseId}), NotificationEvent.NotificationType.SUCCESS));
                this.newCaseEvent.fire((Object)new CaseCreatedEvent((String)caseId));
            }, (message, t) -> {
                ((NewCaseInstanceView)this.view).showError(Collections.singletonList(t.getMessage()));
                return false;
            })).startCaseInstance(null, caseDefinition.getContainerId(), caseDefinition.getId(), owner, assignments);
        } else {
            this.notification.fire((Object)new NotificationEvent(this.translationService.format("InvalidCaseDefinition", new Object[0]), NotificationEvent.NotificationType.ERROR));
        }
    }

    @Inject
    public void setNotification(Event<NotificationEvent> notification) {
        this.notification = notification;
    }

    @Inject
    public void setNewCaseEvent(Event<CaseCreatedEvent> newCaseEvent) {
        this.newCaseEvent = newCaseEvent;
    }

    @Inject
    public void setCaseService(Caller<CaseManagementService> caseService) {
        this.caseService = caseService;
    }

    public static interface NewCaseInstanceView
    extends UberElement<NewCaseInstancePresenter> {
        public void show();

        public void hide();

        public void clearCaseDefinitions();

        public void setCaseDefinitions(List<CaseDefinitionSummary> var1);

        public void clearRoles();

        public void setRoles(List<CaseRoleAssignmentSummary> var1);

        public void setOwner(String var1);

        public void showError(List<String> var1);
    }
}

