/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.util;

import java.util.Collections;
import java.util.Date;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenter;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseStageSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.jbpm.workbench.cm.util.CaseStatus;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

public abstract class AbstractCaseInstancePresenterTest {
    protected static final String containerId = "containerId";
    protected static final String caseDefId = "caseDefinitionId";
    protected static final String caseId = "caseId";
    @Mock
    protected CaseManagementService caseManagementService;
    protected Caller<CaseManagementService> caseService;
    @Mock
    protected TranslationService translationService;

    protected static CaseInstanceSummary newCaseInstanceSummary() {
        return CaseInstanceSummary.builder().caseId(caseId).description("description").status(CaseStatus.OPEN).containerId(containerId).owner("admin").completedAt(new Date()).startedAt(new Date()).caseDefinitionId(caseDefId).roleAssignments(Collections.emptyList()).build();
    }

    protected CaseStageSummary createCaseStageSummary(String stageStatus) {
        return CaseStageSummary.builder().identifier("stage").name("stageName").status(stageStatus).build();
    }

    @Before
    public void init() {
        this.caseService = new CallerMock((Object)this.caseManagementService);
        this.getPresenter().setCaseService(this.caseService);
        ((TranslationService)Mockito.doAnswer(im -> im.getArguments()[0]).when((Object)this.translationService)).format(Matchers.anyString(), new Object[0]);
    }

    protected CaseInstanceSummary setupCaseInstance() {
        CaseInstanceSummary cis = AbstractCaseInstancePresenterTest.newCaseInstanceSummary();
        this.setupCaseInstance(cis);
        return cis;
    }

    protected void setupCaseInstance(CaseInstanceSummary cis) {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest();
        placeRequest.addParameter(containerId, cis.getContainerId());
        placeRequest.addParameter(caseId, cis.getCaseId());
        Mockito.when((Object)this.caseManagementService.getCaseInstance(cis.getContainerId(), cis.getCaseId())).thenReturn((Object)cis);
        this.getPresenter().onStartup((PlaceRequest)placeRequest);
    }

    public abstract AbstractCaseInstancePresenter getPresenter();
}

