/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.comments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.cm.client.comments.CaseCommentsPresenter;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.workbench.cm.model.CaseCommentSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class CaseCommentsPresenterTest
extends AbstractCaseInstancePresenterTest {
    private final String commentId = "commentId";
    private final String author = "author";
    private final String text = "text";
    private final Date addedAt = new Date();
    @Mock
    CaseCommentsPresenter.CaseCommentsView caseCommentsView;
    @Mock
    User identity;
    @InjectMocks
    CaseCommentsPresenter presenter;

    public CaseCommentsPresenter getPresenter() {
        return this.presenter;
    }

    @Test
    public void testLoadCaseInstance() {
        CaseInstanceSummary cis = CaseCommentsPresenterTest.newCaseInstanceSummary();
        CaseCommentSummary caseComment = CaseCommentSummary.builder().id("commentId").author("author").text("text").addedAt(this.addedAt).build();
        Mockito.when((Object)this.caseManagementService.getComments(cis.getContainerId(), cis.getCaseId(), Integer.valueOf(0), Integer.valueOf(this.presenter.getPageSize()))).thenReturn(Collections.singletonList(caseComment));
        this.setupCaseInstance(cis);
        ((CaseCommentsPresenter.CaseCommentsView)Mockito.verify((Object)this.caseCommentsView)).setCaseCommentList(Collections.singletonList(caseComment));
        this.verifyClearCaseInstance(1);
    }

    @Test
    public void testAddCaseComment() {
        CaseInstanceSummary cis = CaseCommentsPresenterTest.newCaseInstanceSummary();
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"author");
        this.setupCaseInstance(cis);
        this.presenter.addCaseComment("text");
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).addComment((String)Matchers.eq((Object)cis.getContainerId()), (String)Matchers.eq((Object)cis.getCaseId()), (String)Matchers.eq((Object)"author"), (String)Matchers.eq((Object)"text"));
        this.verifyClearCaseInstance(1);
    }

    @Test
    public void testUpdateCaseComment() {
        String newCommentText = "newCommentText";
        CaseInstanceSummary cis = CaseCommentsPresenterTest.newCaseInstanceSummary();
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"author");
        CaseCommentSummary caseComment = CaseCommentSummary.builder().id("commentId").author("author").text("text").addedAt(this.addedAt).build();
        Mockito.when((Object)this.caseManagementService.getComments(cis.getContainerId(), cis.getCaseId(), Integer.valueOf(0), Integer.valueOf(this.presenter.getPageSize()))).thenReturn(Collections.singletonList(caseComment));
        this.setupCaseInstance(cis);
        this.presenter.updateCaseComment(caseComment, newCommentText);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).updateComment((String)Matchers.eq((Object)cis.getContainerId()), (String)Matchers.eq((Object)cis.getCaseId()), (String)Matchers.eq((Object)"commentId"), (String)Matchers.eq((Object)"author"), (String)Matchers.eq((Object)newCommentText));
        ((CaseCommentsPresenter.CaseCommentsView)Mockito.verify((Object)this.caseCommentsView, (VerificationMode)Mockito.times((int)2))).setCaseCommentList(Collections.singletonList(caseComment));
        this.verifyClearCaseInstance(2);
    }

    @Test
    public void testDeleteComment() {
        CaseInstanceSummary cis = CaseCommentsPresenterTest.newCaseInstanceSummary();
        CaseCommentSummary caseComment = CaseCommentSummary.builder().id("commentId").author("author").text("text").addedAt(this.addedAt).build();
        Mockito.when((Object)this.caseManagementService.getComments(cis.getContainerId(), cis.getCaseId(), Integer.valueOf(0), Integer.valueOf(this.presenter.getPageSize()))).thenReturn(Collections.singletonList(caseComment));
        this.setupCaseInstance(cis);
        this.presenter.deleteCaseComment(caseComment);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeComment((String)Matchers.eq((Object)cis.getContainerId()), (String)Matchers.eq((Object)cis.getCaseId()), (String)Matchers.eq((Object)"commentId"));
        ((CaseCommentsPresenter.CaseCommentsView)Mockito.verify((Object)this.caseCommentsView, (VerificationMode)Mockito.times((int)2))).setCaseCommentList(Collections.singletonList(caseComment));
        this.verifyClearCaseInstance(2);
    }

    @Test
    public void onStartupShouldNotCallCaseService_whenAnyParameterNull() {
        String[][] invalidPlaceRequestParams = new String[][]{{null, null, null}, {null, null, "caseId"}, {null, "containerId", null}, {"serverTemplateId", null, null}, {"serverTemplateId", null, "caseId"}, {"serverTemplateId", "containerId", null}};
        Arrays.stream(invalidPlaceRequestParams).forEach(invalidParams -> this.verifyGetCaseInstanceCalled((String[])invalidParams, 0));
        String[] validPlaceRequestParams = new String[]{"serverTemplateId", "containerId", "caseId"};
        this.verifyGetCaseInstanceCalled(validPlaceRequestParams, 1);
    }

    private void verifyClearCaseInstance(int times) {
        ((CaseCommentsPresenter.CaseCommentsView)Mockito.verify((Object)this.caseCommentsView, (VerificationMode)Mockito.times((int)times))).clearCommentInputForm();
    }

    private void verifyGetCaseInstanceCalled(String[] placeRequestParams, int timesCalled) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("containerId", placeRequestParams[1]);
        params.put("caseId", placeRequestParams[2]);
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("Case Comments", params, false);
        this.presenter.onStartup((PlaceRequest)placeRequest);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)timesCalled))).getCaseInstance(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testSortComments() {
        CaseInstanceSummary cis = CaseCommentsPresenterTest.newCaseInstanceSummary();
        String comment1_id = "comment1";
        String comment2_id = "comment2";
        Date first = new Date(1000L);
        Date second = new Date(2000L);
        CaseCommentSummary caseComment1 = CaseCommentSummary.builder().id(comment1_id).author("author").text("text").addedAt(first).build();
        CaseCommentSummary caseComment2 = CaseCommentSummary.builder().id(comment2_id).author("author").text("text").addedAt(second).build();
        Mockito.when((Object)this.caseManagementService.getComments(cis.getContainerId(), cis.getCaseId(), Integer.valueOf(0), Integer.valueOf(this.presenter.getPageSize()))).thenReturn(Arrays.asList(caseComment1, caseComment2));
        this.setupCaseInstance(cis);
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseCommentsPresenter.CaseCommentsView)Mockito.verify((Object)this.caseCommentsView)).setCaseCommentList((List)captor.capture());
        Assert.assertEquals((Object)comment2_id, (Object)((CaseCommentSummary)((List)captor.getValue()).get(0)).getId());
        Assert.assertEquals((Object)comment1_id, (Object)((CaseCommentSummary)((List)captor.getValue()).get(1)).getId());
        this.presenter.sortComments(true);
        ((CaseCommentsPresenter.CaseCommentsView)Mockito.verify((Object)this.caseCommentsView, (VerificationMode)Mockito.times((int)2))).setCaseCommentList((List)captor.capture());
        Assert.assertEquals((Object)comment1_id, (Object)((CaseCommentSummary)((List)captor.getValue()).get(0)).getId());
        Assert.assertEquals((Object)comment2_id, (Object)((CaseCommentSummary)((List)captor.getValue()).get(1)).getId());
    }

    @Test
    public void testLoadMoreComments() {
        CaseInstanceSummary cis = CaseCommentsPresenterTest.newCaseInstanceSummary();
        ArrayList<CaseCommentSummary> caseCommentSummary = new ArrayList<CaseCommentSummary>();
        for (int i = 0; i < 55; ++i) {
            CaseCommentSummary comment = CaseCommentSummary.builder().id("comment" + i).author("author").text("text").addedAt(this.addedAt).build();
            caseCommentSummary.add(comment);
        }
        Mockito.when((Object)this.caseManagementService.getComments(cis.getContainerId(), cis.getCaseId(), Integer.valueOf(0), Integer.valueOf(this.presenter.getPageSize()))).thenReturn(caseCommentSummary.subList(0, 20));
        this.setupCaseInstance(cis);
        this.presenter.loadMoreCaseComments();
        Assert.assertEquals((long)1L, (long)this.presenter.getCurrentPage());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).getComments(cis.getContainerId(), cis.getCaseId(), Integer.valueOf(this.presenter.getCurrentPage()), Integer.valueOf(this.presenter.getPageSize()));
    }
}

