/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.newcase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.client.events.CaseCreatedEvent;
import org.jbpm.workbench.cm.client.newcase.NewCaseInstancePresenter;
import org.jbpm.workbench.cm.client.util.CaseRolesValidations;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class NewCaseInstancePresenterTest {
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    EventSourceMock<CaseCreatedEvent> caseCreatedEvent;
    @Mock
    NewCaseInstancePresenter.NewCaseInstanceView view;
    Caller<CaseManagementService> caseService;
    @Mock
    CaseManagementService caseManagementService;
    @Mock
    TranslationService translationService;
    @Mock
    CaseRolesValidations caseRolesValidations;
    @Mock
    User identity;
    @InjectMocks
    NewCaseInstancePresenter presenter;

    @Before
    public void init() {
        this.caseService = new CallerMock((Object)this.caseManagementService);
        this.presenter.setCaseService(this.caseService);
        this.presenter.setNotification(this.notificationEvent);
        this.presenter.setNewCaseEvent(this.caseCreatedEvent);
    }

    @Test
    public void testCreateInvalidCaseInstance() {
        this.presenter.createCaseInstance(null, Mockito.anyString(), null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire((Object)((NotificationEvent)captor.capture()));
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.ERROR, (Object)((NotificationEvent)captor.getValue()).getType());
    }

    @Test
    public void testCreateCaseInstance() {
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().id("id").name("name").containerId("containerId").build();
        Mockito.when((Object)this.caseManagementService.getCaseDefinitions()).thenReturn(Arrays.asList(cds));
        String owner = "userx";
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"userx");
        Mockito.when((Object)this.caseRolesValidations.validateRolesAssignments((CaseDefinitionSummary)Mockito.any(CaseDefinitionSummary.class), Mockito.anyList())).thenReturn((Object)Collections.EMPTY_LIST);
        this.presenter.show();
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).clearCaseDefinitions();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).setCaseDefinitions((List)captor.capture());
        List list = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)cds, list.get(0));
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).setOwner("userx");
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).show();
        this.presenter.createCaseInstance(cds.getUniqueId(), "userx", Collections.emptyList());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).startCaseInstance(cds.getContainerId(), cds.getId(), "userx", Collections.emptyList());
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).hide();
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire((Object)((NotificationEvent)Mockito.any(NotificationEvent.class)));
        ((EventSourceMock)Mockito.verify(this.caseCreatedEvent)).fire((Object)((CaseCreatedEvent)Mockito.any(CaseCreatedEvent.class)));
    }

    @Test
    public void testLoadCaseRoles_incompleteCaseId() {
        String caseDefinitionId = "itorders.orderhardware";
        String caseContainerId = "itorders_1.0.0-SNAPSHOT";
        HashMap<String, Integer> rolesMap = new HashMap<String, Integer>();
        rolesMap.put("owner", 1);
        rolesMap.put("manager", 1);
        rolesMap.put("supplier", 2);
        CaseDefinitionSummary caseDefinition = CaseDefinitionSummary.builder().id("itorders.orderhardware").containerId("itorders_1.0.0-SNAPSHOT").roles(rolesMap).build();
        this.presenter.setCaseDefinitions(Collections.singletonList(caseDefinition));
        this.presenter.loadCaseRoles("itorders.orderhardware");
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).clearRoles();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testLoadCaseRoles_singleRoleOwner() {
        String caseDefinitionId = "testProject.caseDef";
        String caseContainerId = "testProject_1.0";
        CaseDefinitionSummary caseDefinition = CaseDefinitionSummary.builder().id("testProject.caseDef").containerId("testProject_1.0").roles(Collections.singletonMap("owner", 1)).build();
        this.presenter.setCaseDefinitions(Collections.singletonList(caseDefinition));
        String caseUniqueId = "testProject.caseDef|testProject_1.0";
        this.presenter.loadCaseRoles("testProject.caseDef|testProject_1.0");
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).clearRoles();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testLoadCaseRoles_multipleRoles() {
        String caseDefinitionId = "itorders.orderhardware";
        String caseContainerId = "itorders_1.0.0-SNAPSHOT";
        HashMap<String, Integer> rolesMap = new HashMap<String, Integer>();
        rolesMap.put("owner", 1);
        rolesMap.put("manager", 1);
        rolesMap.put("supplier", 2);
        CaseDefinitionSummary caseDefinition = CaseDefinitionSummary.builder().id("itorders.orderhardware").containerId("itorders_1.0.0-SNAPSHOT").roles(rolesMap).build();
        this.presenter.setCaseDefinitions(Collections.singletonList(caseDefinition));
        String caseUniqueId = "itorders.orderhardware|itorders_1.0.0-SNAPSHOT";
        this.presenter.loadCaseRoles("itorders.orderhardware|itorders_1.0.0-SNAPSHOT");
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).clearRoles();
        ArgumentCaptor listCaptor = ArgumentCaptor.forClass(List.class);
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).setRoles((List)listCaptor.capture());
        List caseRoleAssignmentList = (List)listCaptor.getValue();
        Assertions.assertThat((List)caseRoleAssignmentList).hasSize(2);
        ArrayList<String> caseRolesList = new ArrayList<String>();
        caseRolesList.add(((CaseRoleAssignmentSummary)caseRoleAssignmentList.get(0)).getName());
        caseRolesList.add(((CaseRoleAssignmentSummary)caseRoleAssignmentList.get(1)).getName());
        Assertions.assertThat(caseRolesList).containsExactlyInAnyOrder((Object[])new String[]{"manager", "supplier"});
    }

    @Test
    public void testValidateCaseOwnerAssignment_validAssignment() {
        String caseOwners = "caseOwner";
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.presenter.validateCaseOwnerAssignment("caseOwner")).as("isAssignmentValid", new Object[0])).isTrue();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testValidateCaseOwnerAssignment_validAssignmentAfterFiltering() {
        String caseOwners = "caseOwner";
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.presenter.validateCaseOwnerAssignment(" ,  ,caseOwner ,,, ")).as("isAssignmentValid", new Object[0])).isTrue();
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).setOwner("caseOwner");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testValidateCaseOwnerAssignment_emptyInput() {
        ArrayList<String> emptyInputs = new ArrayList<String>(Arrays.asList(null, "    ", " , "));
        emptyInputs.forEach(emptyInput -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.presenter.validateCaseOwnerAssignment(emptyInput)).as("isAssignmentValid", new Object[0])).isFalse());
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).setOwner(Mockito.anyString());
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).showCaseOwnerError((String)Mockito.any());
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.times((int)3))).format((String)Mockito.eq((Object)"PleaseProvideCaseOwner"), new Object[0]);
    }

    @Test
    public void testValidateCaseOwnerAssignment_caseOwnerRoleCardinalityExceeded() {
        String caseOwnerRole = "owner";
        Integer ownerRoleCardinality = 1;
        String caseOwners = "testOwner1, testOwner2";
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.presenter.validateCaseOwnerAssignment("testOwner1, testOwner2")).as("isAssignmentValid", new Object[0])).isFalse();
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setOwner(Mockito.anyString());
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).showCaseOwnerError((String)Mockito.any());
        ((TranslationService)Mockito.verify((Object)this.translationService)).format((String)Mockito.eq((Object)"InvalidRoleAssignment"), new Object[]{Mockito.eq((Object)"owner"), Mockito.eq((Object)ownerRoleCardinality)});
    }
}

