/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.util;

import java.util.Collections;
import java.util.Date;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenter;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.jbpm.workbench.cm.util.CaseStatus;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

public abstract class AbstractCaseInstancePresenterTest {
    @Mock
    protected CaseManagementService caseManagementService;
    protected Caller<CaseManagementService> caseService;
    @Mock
    TranslationService translationService;

    protected static CaseInstanceSummary newCaseInstanceSummary() {
        return CaseInstanceSummary.builder().caseId("caseId").description("description").status(CaseStatus.OPEN).containerId("containerId").owner("admin").completedAt(new Date()).startedAt(new Date()).caseDefinitionId("caseDefinitionId").roleAssignments(Collections.emptyList()).build();
    }

    @Before
    public void init() {
        this.caseService = new CallerMock((Object)this.caseManagementService);
        this.getPresenter().setCaseService(this.caseService);
        ((TranslationService)Mockito.doAnswer(im -> im.getArguments()[0]).when((Object)this.translationService)).format(Matchers.anyString(), new Object[0]);
    }

    protected CaseInstanceSummary setupCaseInstance(String serverTemplateId) {
        CaseInstanceSummary cis = AbstractCaseInstancePresenterTest.newCaseInstanceSummary();
        this.setupCaseInstance(cis, serverTemplateId);
        return cis;
    }

    protected void setupCaseInstance(CaseInstanceSummary cis, String serverTemplateId) {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest();
        placeRequest.addParameter("serverTemplateId", serverTemplateId);
        placeRequest.addParameter("containerId", cis.getContainerId());
        placeRequest.addParameter("caseId", cis.getCaseId());
        Mockito.when((Object)this.caseManagementService.getCaseInstance(serverTemplateId, cis.getContainerId(), cis.getCaseId())).thenReturn((Object)cis);
        this.getPresenter().onStartup((PlaceRequest)placeRequest);
    }

    public abstract AbstractCaseInstancePresenter getPresenter();
}

