/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.server;

import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.io.FileUtils;
import org.guvnor.ala.build.maven.config.impl.MavenBuildConfigImpl;
import org.guvnor.ala.build.maven.config.impl.MavenBuildExecConfigImpl;
import org.guvnor.ala.build.maven.config.impl.MavenProjectConfigImpl;
import org.guvnor.ala.build.maven.executor.MavenBuildConfigExecutor;
import org.guvnor.ala.build.maven.executor.MavenBuildExecConfigExecutor;
import org.guvnor.ala.build.maven.executor.MavenDependencyConfigExecutor;
import org.guvnor.ala.build.maven.executor.MavenProjectConfigExecutor;
import org.guvnor.ala.build.maven.model.MavenBinary;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.StageUtil;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.registry.BuildRegistry;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.registry.local.InMemoryBuildRegistry;
import org.guvnor.ala.registry.local.InMemorySourceRegistry;
import org.guvnor.ala.source.git.config.impl.GitConfigImpl;
import org.guvnor.ala.source.git.executor.GitConfigExecutor;
import org.jbpm.workbench.ks.utils.KieServerUtils;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.client.KieServicesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.services.cdi.Startup;

@ApplicationScoped
@Startup
public class DemoExamplesProvisioningService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DemoExamplesProvisioningService.class);
    private KieServicesClient kieServicesClient;
    private PipelineExecutor executor;
    private Pipeline examplePipe;

    @PostConstruct
    public void init() {
        InMemorySourceRegistry sourceRegistry = new InMemorySourceRegistry();
        InMemoryBuildRegistry buildRegistry = new InMemoryBuildRegistry();
        this.executor = new PipelineExecutor(Arrays.asList(new GitConfigExecutor((SourceRegistry)sourceRegistry), new MavenProjectConfigExecutor((SourceRegistry)sourceRegistry), new MavenBuildConfigExecutor(), new MavenDependencyConfigExecutor((BuildRegistry)buildRegistry), new MavenBuildExecConfigExecutor((BuildRegistry)buildRegistry)));
        Stage sourceConfig = StageUtil.config((String)"Git Source", s -> new GitConfigImpl());
        Stage projectConfig = StageUtil.config((String)"Maven Project", s -> new MavenProjectConfigImpl());
        Stage buildConfig = StageUtil.config((String)"Maven Build Config", s -> new MavenBuildConfigImpl(Collections.singletonList("install"), new Properties()));
        Stage buildExec = StageUtil.config((String)"Maven Build", s -> new MavenBuildExecConfigImpl());
        this.examplePipe = PipelineFactory.startFrom((Stage)sourceConfig).andThen(projectConfig).andThen(buildConfig).andThen(buildExec).buildAs("jBPM Case Management examples pipeline");
        if ("true".equalsIgnoreCase(System.getProperty("org.kie.demo")) && !Strings.isNullOrEmpty((String)System.getProperty("org.kie.server.location"))) {
            this.kieServicesClient = KieServerUtils.createAdminKieServicesClient((String[])new String[]{"CaseMgmt"});
            SimpleAsyncExecutorService.getDefaultInstance().execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void provisionExamples() throws Exception {
        File tempDir = null;
        try {
            tempDir = Files.createTempDirectory("jbpm-cm-demo", new FileAttribute[0]).toFile();
            this.provisionExample(tempDir.getAbsolutePath(), "true", "itorders");
            this.provisionExample(tempDir.getAbsolutePath(), "false", "itorders-data");
            this.provisionExample(tempDir.getAbsolutePath(), "false", "itorders-dynamic");
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(tempDir);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)tempDir);
    }

    private void provisionExample(String tempDir, String createRepo, String projectDir) {
        Input input = new Input();
        input.put((Object)"repo-name", (Object)"case-examples");
        input.put((Object)"create-repo", (Object)createRepo);
        input.put((Object)"branch", (Object)"master");
        input.put((Object)"out-dir", (Object)tempDir);
        input.put((Object)"origin", (Object)"https://github.com/mswiderski/case-examples.git");
        input.put((Object)"project-dir", (Object)projectDir);
        this.executor.execute(input, this.examplePipe, b -> this.createKieServerContainer(b), new PipelineEventListener[0]);
    }

    private void createKieServerContainer(MavenBinary mavenBinary) {
        String containerId = mavenBinary.getArtifactId() + "-" + mavenBinary.getVersion();
        ReleaseId releaseId = new ReleaseId(mavenBinary.getGroupId(), mavenBinary.getArtifactId(), mavenBinary.getVersion());
        KieContainerResource resource = new KieContainerResource(containerId, releaseId);
        LOGGER.info("Creating Kie Server container with id: {}", (Object)containerId);
        this.kieServicesClient.createContainer(containerId, resource);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

