/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.server;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.jbpm.workbench.ks.utils.KieServerUtils;
import org.kie.server.client.CaseServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.ApplicationStarted;
import org.uberfire.commons.services.cdi.Startup;

@ApplicationScoped
@Startup
public class AppSetup {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppSetup.class);
    @Inject
    private Event<ApplicationStarted> applicationStartedEvent;
    @Inject
    private AuthenticationService authenticationService;

    @PostConstruct
    public void onStartup() {
        this.applicationStartedEvent.fire((Object)new ApplicationStarted());
    }

    @Produces
    @ApplicationScoped
    public KieServicesClient produceKieServicesClient() {
        LOGGER.info("Creating KieServicesClient...");
        return KieServerUtils.createKieServicesClient((String[])new String[]{"CaseMgmt", "BPM"});
    }

    @Produces
    @ApplicationScoped
    public CaseServicesClient produceCaseServicesClient(KieServicesClient kieServicesClient) {
        LOGGER.info("Creating CaseServicesClient...");
        return (CaseServicesClient)kieServicesClient.getServicesClient(CaseServicesClient.class);
    }

    @Produces
    @ApplicationScoped
    public UserTaskServicesClient produceUserTaskServicesClient(KieServicesClient kieServicesClient) {
        LOGGER.info("Creating UserTaskServicesClient...");
        return (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
    }

    @Produces
    @RequestScoped
    public User getIdentity() {
        return this.authenticationService.getUser();
    }
}

