/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jbpm.workbench.common.client.util.UTCDateBox;
import org.jbpm.workbench.common.client.util.UTCTimeBoxImplShared;

public class UTCTimeBoxImplHtml4
extends UTCTimeBoxImplShared {
    private static final String CLASSNAME_INVALID = "invalid";
    private static final long INTERVAL = 1800000L;
    private static final long DAY = 86400000L;
    private Select textbox = new Select();
    private Long lastKnownValue;

    public UTCTimeBoxImplHtml4() {
        TextBoxHandler handler = new TextBoxHandler();
        this.textbox.addDomHandler((EventHandler)handler, BlurEvent.getType());
        this.textbox.addValueChangeHandler((ValueChangeHandler)handler);
        this.textbox.setFixedMenuSize(5);
        this.initWidget((Widget)this.textbox);
    }

    @Override
    public void setTimeFormat(DateTimeFormat timeFormat) {
        super.setTimeFormat(timeFormat);
        this.generateTimeOptions();
    }

    private void generateTimeOptions() {
        int numOptions = 48;
        for (int i = 0; i < numOptions; ++i) {
            long offsetFromMidnight = (long)i * 1800000L;
            String value = this.generateTimeValue(offsetFromMidnight);
            Option option = new Option();
            option.setText(value);
            option.setValue(value);
            this.textbox.add((Widget)option);
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                UTCTimeBoxImplHtml4.this.textbox.refresh();
            }
        });
    }

    private String generateTimeValue(long offsetFromMidnight) {
        long time = UTCDateBox.timezoneOffsetMillis(new Date(0L)) + offsetFromMidnight;
        return this.timeFormat.format(new Date(time));
    }

    public Select getTextBox() {
        return this.textbox;
    }

    public boolean hasValue() {
        return this.getText().trim().length() > 0;
    }

    public boolean hasValidValue() {
        return !this.hasValue() || this.getValue() != null;
    }

    public Long getValue() {
        return this.text2value(this.getText());
    }

    public void setValue(Long value, boolean fireEvents) {
        this.setValue(value, true, fireEvents);
    }

    protected void setValue(Long value, boolean updateTextBox, boolean fireEvents) {
        if (updateTextBox) {
            this.syncTextToValue(value);
        }
        Long oldValue = this.lastKnownValue;
        this.lastKnownValue = value;
        if (fireEvents && !this.isSameValue(oldValue, value)) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    protected boolean isSameValue(Long a, Long b) {
        return a == null ? b == null : a.equals(b);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Long> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public String getText() {
        return this.textbox.getValue();
    }

    public void setText(String text) {
        this.textbox.setValue((Object)text);
        this.syncValueToText();
    }

    protected void syncTextToValue(Long value) {
        Long valueToSelect = this.text2value(this.value2text(value));
        for (Option option : this.textbox) {
            Long optionValue = this.text2value(option.getValue());
            if (optionValue > valueToSelect) continue;
            this.textbox.setValue((Object)option.getValue());
        }
    }

    protected void syncValueToText() {
        this.setValue(this.text2value(this.getText()), false, true);
    }

    @Override
    public void validate() {
        boolean valid = true;
        if (this.hasValue()) {
            Long value = this.getValue();
            if (value != null) {
                this.setText(this.value2text(value));
            } else {
                valid = false;
            }
        }
        this.setStyleName(CLASSNAME_INVALID, !valid);
    }

    @Override
    public void setVisibleLength(int length) {
        this.textbox.setFixedMenuSize(length);
    }

    @Override
    public void setTabIndex(int tabIndex) {
        this.textbox.setTabIndex(tabIndex);
    }

    public void clearInvalidStyle() {
        this.removeStyleName(CLASSNAME_INVALID);
    }

    private class TextBoxHandler
    implements BlurHandler,
    ValueChangeHandler<String> {
        private TextBoxHandler() {
        }

        public void onBlur(BlurEvent event) {
            UTCTimeBoxImplHtml4.this.clearInvalidStyle();
            UTCTimeBoxImplHtml4.this.validate();
        }

        public void onValueChange(ValueChangeEvent<String> event) {
            UTCTimeBoxImplHtml4.this.clearInvalidStyle();
            UTCTimeBoxImplHtml4.this.validate();
        }
    }
}

