/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list.base;

import com.google.common.base.Strings;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.event.Observes;
import org.jbpm.workbench.common.client.list.base.AbstractListView;
import org.jbpm.workbench.common.client.list.base.events.SearchEvent;
import org.jbpm.workbench.common.client.menu.RestoreDefaultFiltersMenuBuilder;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.model.QueryFilter;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.ext.widgets.common.client.menu.RefreshSelectorMenuBuilder;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.paging.PageResponse;

public abstract class AbstractListPresenter<T>
implements RefreshMenuBuilder.SupportsRefresh,
RefreshSelectorMenuBuilder.SupportsRefreshInterval,
RestoreDefaultFiltersMenuBuilder.SupportsRestoreDefaultFilters {
    protected AsyncDataProvider<T> dataProvider;
    protected QueryFilter currentFilter;
    protected String textSearchStr = "";
    private Constants constants = (Constants)GWT.create(Constants.class);
    protected boolean addingDefaultFilters = false;
    protected Timer refreshTimer = null;
    protected boolean autoRefreshEnabled = false;
    protected int autoRefreshSeconds = 0;

    protected abstract AbstractListView.ListView getListView();

    public AbstractListPresenter() {
        this.initDataProvider();
    }

    public boolean isAddingDefaultFilters() {
        return this.addingDefaultFilters;
    }

    public void setAddingDefaultFilters(boolean addingDefaultFilters) {
        this.addingDefaultFilters = addingDefaultFilters;
    }

    public void setRefreshTimer(Timer refreshTimer) {
        this.refreshTimer = refreshTimer;
    }

    public Timer getRefreshTimer() {
        return this.refreshTimer;
    }

    public void setAutoRefreshEnabled(boolean autoRefreshEnabled) {
        this.autoRefreshEnabled = autoRefreshEnabled;
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefreshEnabled;
    }

    protected void updateRefreshTimer() {
        if (this.refreshTimer == null) {
            this.refreshTimer = new Timer(){

                public void run() {
                    AbstractListPresenter.this.getData(AbstractListPresenter.this.getListView().getListGrid().getVisibleRange());
                }
            };
        } else {
            this.refreshTimer.cancel();
        }
        if (this.autoRefreshEnabled && this.autoRefreshSeconds > 10) {
            this.refreshTimer.schedule(this.autoRefreshSeconds * 1000);
        }
    }

    public abstract void getData(Range var1);

    public void onGridPreferencesStoreLoaded() {
    }

    protected void initDataProvider() {
        this.dataProvider = new AsyncDataProvider<T>(){

            protected void onRangeChanged(HasData<T> display) {
                AbstractListPresenter.this.getListView().showBusyIndicator(AbstractListPresenter.this.constants.Loading());
                Range visibleRange = display.getVisibleRange();
                AbstractListPresenter.this.getData(visibleRange);
            }
        };
    }

    public void updateDataOnCallback(PageResponse response) {
        this.getListView().hideBusyIndicator();
        this.dataProvider.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
        this.dataProvider.updateRowData(response.getStartRowIndex(), response.getPageRowList());
        this.updateRefreshTimer();
    }

    public void updateDataOnCallback(List<T> instanceSummaries, int startRange, int totalRowCount, boolean isExact) {
        this.getListView().hideBusyIndicator();
        this.dataProvider.updateRowCount(totalRowCount, isExact);
        this.dataProvider.updateRowData(startRange, instanceSummaries);
        this.updateRefreshTimer();
    }

    public void addDataDisplay(HasData<T> display) {
        this.dataProvider.addDataDisplay(display);
    }

    public AsyncDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    public void onRefresh() {
        this.refreshGrid();
    }

    public void refreshGrid() {
        if (this.getListView().getListGrid() != null) {
            this.getListView().getListGrid().setVisibleRangeAndClearData(this.getListView().getListGrid().getVisibleRange(), true);
        }
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        String filterString = searchEvent.getFilter();
        this.textSearchStr = filterString == null ? "" : filterString.toLowerCase();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("textSearch", this.textSearchStr);
        if (this.currentFilter != null) {
            this.currentFilter.setParams(params);
        }
        HasData next = (HasData)this.dataProvider.getDataDisplays().iterator().next();
        if (Strings.isNullOrEmpty((String)filterString)) {
            next.setVisibleRangeAndClearData(next.getVisibleRange(), true);
        } else {
            next.setVisibleRangeAndClearData(new Range(0, next.getVisibleRange().getLength()), true);
        }
    }

    @Override
    public void onRestoreDefaultFilters() {
        this.getListView().showRestoreDefaultFilterConfirmationPopup();
    }

    public void onUpdateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        this.autoRefreshEnabled = enableAutoRefresh;
        this.setAutoRefreshSeconds(newInterval);
        this.updateRefreshTimer();
    }

    protected int getAutoRefreshSeconds() {
        return this.autoRefreshSeconds;
    }

    protected void setAutoRefreshSeconds(int refreshSeconds) {
        this.autoRefreshSeconds = refreshSeconds;
    }

    @OnClose
    public void onClose() {
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
    }

    public String getTextSearchStr() {
        return this.textSearchStr;
    }

    protected void setDataProvider(AsyncDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
    }
}

