/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.menu;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSortedSet;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.events.ServerTemplateSelected;
import org.jbpm.workbench.ks.events.KieServerDataSetRegistered;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@ApplicationScoped
public class ServerTemplateSelectorMenuBuilder
implements MenuFactory.CustomMenuBuilder {
    @Inject
    private ServerTemplateSelectorView view;
    @Inject
    private Caller<SpecManagementService> specManagementService;
    @Inject
    private Event<ServerTemplateSelected> serverTemplateSelectedEvent;

    @PostConstruct
    public void init() {
        this.view.setServerTemplateChangeHandler((ParameterizedCommand<String>)((ParameterizedCommand)e -> this.serverTemplateSelectedEvent.fire((Object)new ServerTemplateSelected(e))));
        this.loadServerTemplates();
    }

    protected void loadServerTemplates() {
        ((SpecManagementService)this.specManagementService.call(serverTemplates -> {
            this.view.removeAllServerTemplates();
            ImmutableSortedSet ids = FluentIterable.from((Iterable)serverTemplates).filter(s -> s.getServerInstanceKeys() != null && !s.getServerInstanceKeys().isEmpty()).transform(s -> s.getId()).toSortedSet(String.CASE_INSENSITIVE_ORDER);
            for (String id : ids) {
                this.view.addServerTemplate(id);
            }
            if (ids.size() == 1) {
                this.view.selectServerTemplate((String)ids.iterator().next());
            } else {
                String selectedServerTemplate = this.view.getSelectedServerTemplate();
                if (selectedServerTemplate != null) {
                    if (ids.contains(selectedServerTemplate)) {
                        this.view.selectServerTemplate(selectedServerTemplate);
                    } else {
                        this.view.clearSelectedServerTemplate();
                    }
                }
            }
            this.view.setVisible(ids.size() > 1);
        })).listServerTemplates();
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return new BaseMenuCustom<IsWidget>(){

            public IsWidget build() {
                return ServerTemplateSelectorMenuBuilder.this.view;
            }

            public boolean isEnabled() {
                return true;
            }

            public void setEnabled(boolean enabled) {
            }
        };
    }

    public void onServerTemplateDeleted(@Observes ServerTemplateDeleted serverTemplateDeleted) {
        this.loadServerTemplates();
    }

    public void onServerTemplateUpdated(@Observes ServerTemplateUpdated serverTemplateUpdated) {
        this.loadServerTemplates();
    }

    public void onKieServerDataSetRegistered(@Observes KieServerDataSetRegistered kieServerDataSetRegistered) {
        this.loadServerTemplates();
    }

    @Inject
    public void setSpecManagementService(Caller<SpecManagementService> specManagementService) {
        this.specManagementService = specManagementService;
    }

    public String getSelectedServerTemplate() {
        return this.view.getSelectedServerTemplate();
    }

    public static interface ServerTemplateSelectorView
    extends IsWidget {
        public void selectServerTemplate(String var1);

        public void setVisible(boolean var1);

        public void clearSelectedServerTemplate();

        public String getSelectedServerTemplate();

        public void addServerTemplate(String var1);

        public void removeAllServerTemplates();

        public void setServerTemplateChangeHandler(ParameterizedCommand<String> var1);
    }
}

