/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.uberfire.ext.widgets.common.client.common.DatePicker;

public class UTCDateBox
extends Composite
implements HasValue<Long>,
HasValueChangeHandlers<Long>,
HasEnabled {
    private DatePicker datePicker = (DatePicker)GWT.create(DatePicker.class);
    public static final long DAY_IN_MS = 86400000L;

    public UTCDateBox() {
        this.datePicker.setFormat(DateUtils.getDateFormatMask());
        this.initWidget((Widget)this.datePicker);
    }

    public Long getValue() {
        return UTCDateBox.date2utc(this.datePicker.getValue());
    }

    public void setValue(Long value) {
        this.setValue(value, false);
    }

    public void setValue(Long value, boolean fireEvents) {
        this.datePicker.setValue(UTCDateBox.utc2date(value), fireEvents);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler handler) {
        return this.datePicker.addValueChangeHandler(handler);
    }

    public boolean isEnabled() {
        return this.datePicker.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.datePicker.setEnabled(enabled);
    }

    public DatePicker getDateBox() {
        return this.datePicker;
    }

    public static final long trimTimeToMidnight(long time) {
        return time - time % 86400000L;
    }

    public static final Date utc2date(Long time) {
        if (time == null || time < 0L) {
            return null;
        }
        time = time + UTCDateBox.timezoneOffsetMillis(new Date(time));
        return new Date(time);
    }

    public static final Long date2utc(Date date) {
        if (date == null) {
            return null;
        }
        long time = date.getTime();
        return time -= UTCDateBox.timezoneOffsetMillis(date);
    }

    public static final Long getValueForToday() {
        return UTCDateBox.trimTimeToMidnight(UTCDateBox.date2utc(new Date()));
    }

    public static final long timezoneOffsetMillis(Date date) {
        return date.getTimezoneOffset() * 60 * 1000;
    }
}

