/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Composite;
import java.util.Date;
import org.jbpm.workbench.common.client.util.UTCDateBox;
import org.jbpm.workbench.common.client.util.UTCTimeBoxImpl;

public abstract class UTCTimeBoxImplShared
extends Composite
implements UTCTimeBoxImpl {
    protected static DateTimeFormat[] fallbackTimeFormats = null;
    protected static String[] fallbackFormatStrings = new String[]{"hh:mma", "HH:mm"};
    protected DateTimeFormat timeFormat;

    @Override
    public void setTimeFormat(DateTimeFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    @Override
    public void setVisibleLength(int length) {
    }

    @Override
    public void validate() {
    }

    public final void setValue(Long value) {
        this.setValue(value, false);
    }

    public UTCTimeBoxImplShared() {
        if (fallbackTimeFormats == null) {
            fallbackTimeFormats = new DateTimeFormat[fallbackFormatStrings.length];
            for (int i = 0; i < fallbackFormatStrings.length; ++i) {
                UTCTimeBoxImplShared.fallbackTimeFormats[i] = DateTimeFormat.getFormat((String)fallbackFormatStrings[i]);
            }
        }
    }

    protected final String value2text(Long value) {
        return UTCTimeBoxImplShared.formatUsingFormat(value, this.timeFormat);
    }

    protected final Long text2value(String text) {
        Long ret;
        if (text == null) {
            return null;
        }
        if ((text = text.trim()).length() == 0) {
            return null;
        }
        if (text.endsWith("p") || text.endsWith("a")) {
            text = text + "m";
        }
        if ((ret = UTCTimeBoxImplShared.parseUsingFallbacks(text, this.timeFormat)) == null) {
            ret = UTCTimeBoxImplShared.parseUsingFallbacksWithColon(text, this.timeFormat);
        }
        return ret;
    }

    protected static final String formatUsingFormat(Long value, DateTimeFormat fmt) {
        if (value == null) {
            return "";
        }
        Date date = new Date(0L);
        date.setTime(UTCDateBox.timezoneOffsetMillis(date) + value);
        return fmt.format(date);
    }

    protected static final Long parseUsingFallbacksWithColon(String text, DateTimeFormat timeFormat) {
        if (text.indexOf(58) == -1) {
            int colon;
            text = text.replace(" ", "");
            int numdigits = 0;
            int lastdigit = 0;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (!Character.isDigit(c)) continue;
                ++numdigits;
                lastdigit = i;
            }
            if (numdigits == 1 || numdigits == 2) {
                colon = lastdigit + 1;
                text = text.substring(0, colon) + ":00" + text.substring(colon);
            } else if (numdigits > 2) {
                colon = lastdigit - 1;
                text = text.substring(0, colon) + ":" + text.substring(colon);
            }
            return UTCTimeBoxImplShared.parseUsingFallbacks(text, timeFormat);
        }
        return null;
    }

    protected static final Long parseUsingFormat(String text, DateTimeFormat fmt) {
        Date date = new Date(0L);
        int num = fmt.parse(text, 0, date);
        return num != 0 ? new Long(UTCTimeBoxImplShared.normalizeInLocalRange(date.getTime() - UTCDateBox.timezoneOffsetMillis(date))) : null;
    }

    protected static final Long parseUsingFallbacks(String text, DateTimeFormat primaryTimeFormat) {
        Long ret = UTCTimeBoxImplShared.parseUsingFormat(text, primaryTimeFormat);
        for (int i = 0; ret == null && i < fallbackTimeFormats.length; ++i) {
            ret = UTCTimeBoxImplShared.parseUsingFormat(text, fallbackTimeFormats[i]);
        }
        return ret;
    }

    protected static long normalizeInLocalRange(long time) {
        return (time + 86400000L) % 86400000L;
    }
}

