/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.resources.CommonResources;
import org.jbpm.workbench.common.model.GenericSummary;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractListView<T extends GenericSummary, V extends AbstractListPresenter>
extends Composite
implements RequiresResize {
    @Inject
    public User identity;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    protected PlaceManager placeManager;
    protected V presenter;
    protected ExtendedPagedTable<T> listGrid;
    protected NoSelectionModel<T> selectionModel;
    protected T selectedItem;
    protected int selectedRow = -1;
    protected RowStyles<T> selectedStyles = new RowStyles<T>(){

        public String getStyleNames(T row, int rowIndex) {
            if (rowIndex == AbstractListView.this.selectedRow) {
                return CommonResources.INSTANCE.css().selected();
            }
            return null;
        }
    };
    protected DefaultSelectionEventManager<T> noActionColumnManager;
    @Inject
    private Caller<UserPreferencesService> preferencesService;

    public void init(final V presenter, final GridGlobalPreferences preferences) {
        this.presenter = presenter;
        this.listGrid = new ExtendedPagedTable(preferences);
        this.listGrid.setShowLastPagerButton(true);
        this.listGrid.setShowFastFordwardPagerButton(true);
        this.initWidget((Widget)this.listGrid);
        ((AbstractListPresenter)presenter).addDataDisplay(this.listGrid);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<GridPreferencesStore>(){

            public void callback(GridPreferencesStore preferencesStore) {
                AbstractListView.this.listGrid.setPreferencesService(AbstractListView.this.preferencesService);
                if (preferencesStore == null) {
                    AbstractListView.this.listGrid.setGridPreferencesStore(new GridPreferencesStore(preferences));
                } else {
                    AbstractListView.this.listGrid.setGridPreferencesStore(preferencesStore);
                }
                presenter.onGridPreferencesStoreLoaded();
                AbstractListView.this.initColumns(AbstractListView.this.listGrid);
                AbstractListView.this.listGrid.loadPageSizePreferences();
            }
        })).loadUserPreferences(preferences.getKey(), UserPreferencesType.GRIDPREFERENCES);
    }

    public void onResize() {
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void showRestoreDefaultFilterConfirmationPopup() {
    }

    public ExtendedPagedTable<T> getListGrid() {
        return this.listGrid;
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    public abstract void initColumns(ExtendedPagedTable<T> var1);
}

