/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.common.collect.Iterables;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSetLookup;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AdvancedSearchFiltersViewImpl;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.client.util.DateRange;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetEditorManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractMultiGridView<T extends GenericSummary, V extends AbstractMultiGridPresenter>
extends Composite
implements MultiGridView<T, V> {
    public static final String TAB_SEARCH = "base";
    public static final String FILTER_TABLE_SETTINGS = "tableSettings";
    public static final String USER_DEFINED = "ud_";
    public static final String COL_ID_SELECT = "Select";
    public static final String COL_ID_ACTIONS = "Actions";
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private final Constants constants = Constants.INSTANCE;
    @Inject
    protected User identity;
    protected Button createTabButton = (Button)GWT.create(Button.class);
    @Inject
    protected Event<NotificationEvent> notification;
    protected DataSetEditorManager dataSetEditorManager;
    @Inject
    protected PlaceManager placeManager;
    @Inject
    protected AdvancedSearchFiltersViewImpl advancedSearchFiltersView;
    protected V presenter;
    protected FilterPagedTable<T> filterPagedTable = (FilterPagedTable)GWT.create(FilterPagedTable.class);
    protected ExtendedPagedTable<T> currentListGrid;
    @UiField
    protected org.gwtbootstrap3.client.ui.Column column;
    private Caller<UserPreferencesService> userPreferencesService;

    public AbstractMultiGridView() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.column.add(this.filterPagedTable.makeWidget());
        this.createTabButton.setIcon(IconType.PLUS);
        this.createTabButton.setSize(ButtonSize.SMALL);
    }

    public void init(V presenter) {
        this.presenter = presenter;
        this.createTabButton.addClickHandler(event -> this.createNewTab(presenter));
        ((UserPreferencesService)this.userPreferencesService.call(multiGridPreferencesStore -> {
            if (multiGridPreferencesStore == null) {
                multiGridPreferencesStore = new MultiGridPreferencesStore(this.getGridGlobalPreferencesKey());
            }
            this.loadTabsFromPreferences((MultiGridPreferencesStore)multiGridPreferencesStore, presenter);
        })).loadUserPreferences(this.getGridGlobalPreferencesKey(), UserPreferencesType.MULTIGRIDPREFERENCES);
    }

    protected void createNewTab(V presenter) {
        String key = this.getValidKeyForAdditionalListGrid(this.getGridGlobalPreferencesKey() + "_");
        Command addNewGrid = () -> {
            ExtendedPagedTable<T> extendedPagedTable = this.createGridInstance(key);
            extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
            this.filterPagedTable.createNewTab(extendedPagedTable, key, this.createTabButton, () -> {
                this.currentListGrid = extendedPagedTable;
                this.applyFilterOnPresenter(key);
            });
            this.applyFilterOnPresenter(key);
        };
        FilterSettings tableSettings = ((AbstractMultiGridPresenter)presenter).createTableSettingsPrototype();
        tableSettings.setKey(key);
        this.dataSetEditorManager.showTableSettingsEditor(this.filterPagedTable, this.getNewFilterPopupTitle(), tableSettings, addNewGrid);
    }

    protected void loadTabsFromPreferences(MultiGridPreferencesStore multiGridPreferencesStore, V presenter) {
        this.filterPagedTable.setMultiGridPreferencesStore(multiGridPreferencesStore);
        ((AbstractListPresenter)presenter).setAddingDefaultFilters(true);
        ArrayList<String> existingGrids = new ArrayList<String>(multiGridPreferencesStore.getGridsId());
        if (existingGrids.isEmpty()) {
            this.initDefaultFilters();
        } else {
            if (!existingGrids.contains(TAB_SEARCH)) {
                this.initSearchFilter();
            }
            existingGrids.forEach(key -> {
                ExtendedPagedTable<T> extendedPagedTable = this.loadGridInstance((String)key);
                extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                this.filterPagedTable.addTab(extendedPagedTable, key, () -> {
                    this.currentListGrid = extendedPagedTable;
                    this.applyFilterOnPresenter((String)key);
                }, false);
            });
            if (multiGridPreferencesStore.getGridsId().indexOf(TAB_SEARCH) != 0) {
                multiGridPreferencesStore.getGridsId().remove(TAB_SEARCH);
                multiGridPreferencesStore.getGridsId().add(0, TAB_SEARCH);
            }
        }
        multiGridPreferencesStore.setSelectedGrid(TAB_SEARCH);
        this.filterPagedTable.addAddTableButton(this.createTabButton);
        ((AbstractMultiGridPresenter)presenter).onGridPreferencesStoreLoaded();
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public void showRestoreDefaultFilterConfirmationPopup() {
        YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)this.constants.RestoreDefaultFilters(), (String)this.constants.AreYouSureRestoreDefaultFilters(), () -> {
            this.showBusyIndicator(this.constants.Loading());
            ((AbstractMultiGridPresenter)this.presenter).onRestoreTabs();
        }, null, () -> {});
        yesNoCancelPopup.show();
    }

    @Override
    public void restoreTabs() {
        ((AbstractListPresenter)this.presenter).setAddingDefaultFilters(true);
        ArrayList grids = new ArrayList(this.getMultiGridPreferencesStore().getGridsId());
        grids.forEach(key -> this.filterPagedTable.removeTab(key));
        this.filterPagedTable.removeTab(0);
        this.initDefaultFilters();
        this.filterPagedTable.addAddTableButton(this.createTabButton);
    }

    protected void controlBulkOperations(ExtendedPagedTable<T> extendedPagedTable) {
        Scheduler.get().scheduleDeferred(() -> this.enableWidgets((Widget)Iterables.getFirst((Iterable)extendedPagedTable.getRightActionsToolbar(), null), extendedPagedTable.hasSelectedItems()));
    }

    protected void enableWidgets(Widget widget, boolean enable) {
        if (widget == null) {
            return;
        }
        if (widget instanceof HasEnabled) {
            ((HasEnabled)widget).setEnabled(enable);
        }
        if (widget instanceof HasWidgets) {
            for (Widget w : (HasWidgets)widget) {
                this.enableWidgets(w, enable);
            }
        }
    }

    public String getValidKeyForAdditionalListGrid(String baseName) {
        return this.filterPagedTable.getValidKeyForAdditionalListGrid(baseName + USER_DEFINED);
    }

    public ExtendedPagedTable<T> createGridInstance(String key) {
        ExtendedPagedTable<T> newListGrid = this.createExtendedPagedTable(key);
        newListGrid.setShowLastPagerButton(false);
        newListGrid.setShowFastFordwardPagerButton(false);
        newListGrid.setPreferencesService(this.userPreferencesService);
        this.initColumns(newListGrid);
        this.initSelectionModel(newListGrid);
        newListGrid.loadPageSizePreferences();
        newListGrid.createPageSizesListBox(5, 20, 5);
        return newListGrid;
    }

    protected ExtendedPagedTable<T> createExtendedPagedTable(String key) {
        ExtendedPagedTable table;
        GridGlobalPreferences pref;
        if (TAB_SEARCH.equals(key)) {
            pref = new GridGlobalPreferences(this.getGridGlobalPreferencesKey() + key, this.getInitColumns(), this.getBannedColumns());
            table = this.createAdvancedSearchTable(pref);
        } else {
            pref = new GridGlobalPreferences(key, this.getInitColumns(), this.getBannedColumns());
            table = new ExtendedPagedTable(pref);
        }
        table.setGridPreferencesStore(new GridPreferencesStore(pref));
        return table;
    }

    protected ExtendedPagedTable<T> createAdvancedSearchTable(GridGlobalPreferences preferences) {
        ExtendedPagedTable advancedSearchTable = new ExtendedPagedTable(preferences);
        advancedSearchTable.getElement().getStyle().setPaddingTop(0.0, Style.Unit.PX);
        advancedSearchTable.getTopToolbar().add((Widget)this.advancedSearchFiltersView);
        return advancedSearchTable;
    }

    public ExtendedPagedTable<T> loadGridInstance(String key) {
        ExtendedPagedTable<T> newListGrid = this.createExtendedPagedTable(key);
        newListGrid.setShowLastPagerButton(false);
        newListGrid.setShowFastFordwardPagerButton(false);
        newListGrid.dataGrid.addRedrawHandler(() -> this.controlBulkOperations(newListGrid));
        ((UserPreferencesService)this.userPreferencesService.call(preferencesStore -> {
            newListGrid.setPreferencesService(this.userPreferencesService);
            if (preferencesStore != null) {
                newListGrid.setGridPreferencesStore((GridPreferencesStore)preferencesStore);
            }
            this.initColumns(newListGrid);
            this.initSelectionModel(newListGrid);
            newListGrid.loadPageSizePreferences();
            newListGrid.createPageSizesListBox(5, 20, 5);
        })).loadUserPreferences(newListGrid.getGridPreferencesStore().getPreferenceKey(), UserPreferencesType.GRIDPREFERENCES);
        return newListGrid;
    }

    @Override
    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    @Override
    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Override
    public ExtendedPagedTable<T> getListGrid() {
        return this.currentListGrid;
    }

    public abstract void initColumns(ExtendedPagedTable<T> var1);

    public abstract void initSelectionModel(ExtendedPagedTable<T> var1);

    public abstract List<String> getInitColumns();

    public abstract List<String> getBannedColumns();

    public abstract String getGridGlobalPreferencesKey();

    public abstract String getNewFilterPopupTitle();

    public MultiGridPreferencesStore getMultiGridPreferencesStore() {
        if (this.filterPagedTable != null) {
            return this.filterPagedTable.getMultiGridPreferencesStore();
        }
        return null;
    }

    public void initDefaultFilters() {
        this.initSearchFilter();
    }

    protected void initSearchFilter() {
        FilterSettings settings = ((AbstractMultiGridPresenter)this.presenter).createSearchTabSettings();
        settings.setTableName(this.constants.Search());
        settings.setTableDescription(this.constants.SearchResults());
        settings.setKey(TAB_SEARCH);
        this.addNewTab(settings);
    }

    public void initTabFilter(FilterSettings tableSettings, String key, String tabName, String tabDesc, String dataSetUUID) {
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        tableSettings.setUUID(dataSetUUID);
        this.addNewTab(tableSettings);
    }

    public void addNewTab(FilterSettings tableSettings) {
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(tableSettings.getKey(), tabSettingsValues);
        ExtendedPagedTable<T> extendedPagedTable = this.createGridInstance(tableSettings.getKey());
        this.currentListGrid = extendedPagedTable;
        extendedPagedTable.setDataProvider((AbstractDataProvider)((AbstractListPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab(extendedPagedTable, tableSettings.getKey(), () -> {
            this.currentListGrid = extendedPagedTable;
            this.applyFilterOnPresenter(tableSettings.getKey());
        }, false);
    }

    @Override
    public void selectFirstTabAndEnableQueries() {
        Scheduler.get().scheduleDeferred(this.getSelectFirstTabAndEnableQueriesCommand());
    }

    protected Scheduler.ScheduledCommand getSelectFirstTabAndEnableQueriesCommand() {
        return () -> {
            ((AbstractListPresenter)this.presenter).setAddingDefaultFilters(false);
            this.getMultiGridPreferencesStore().setSelectedGrid(TAB_SEARCH);
            this.filterPagedTable.setSelectedTab();
        };
    }

    @Override
    public void applyFilterOnPresenter(String key) {
        this.applyFilterOnPresenter(this.getTableFilterSettings(key));
    }

    public void applyFilterOnPresenter(FilterSettings filterSettings) {
        ((AbstractMultiGridPresenter)this.presenter).filterGrid(filterSettings);
    }

    protected FilterSettings getTableFilterSettings(String key) {
        HashMap<String, Object> params = this.getGridSettings(key);
        String tableSettingsJSON = (String)params.get(FILTER_TABLE_SETTINGS);
        return this.dataSetEditorManager.getStrToTableSettings(tableSettingsJSON);
    }

    @Override
    public FilterSettings getAdvancedSearchFilterSettings() {
        return this.getTableFilterSettings(TAB_SEARCH);
    }

    @Override
    public void saveAdvancedSearchFilterSettings(FilterSettings settings) {
        HashMap<String, Object> gridSettings = this.getGridSettings(TAB_SEARCH);
        gridSettings.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(settings));
        this.filterPagedTable.saveTabSettings(TAB_SEARCH, gridSettings);
    }

    protected HashMap<String, Object> getGridSettings(String key) {
        return this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key);
    }

    public void setIdentity(User identity) {
        this.identity = identity;
    }

    @Inject
    public void setUserPreferencesService(Caller<UserPreferencesService> userPreferencesService) {
        this.userPreferencesService = userPreferencesService;
        this.filterPagedTable.setPreferencesService(userPreferencesService);
    }

    @Inject
    public void setDataSetEditorManager(DataSetEditorManager dataSetEditorManager) {
        this.dataSetEditorManager = dataSetEditorManager;
    }

    public FilterPagedTable<T> getFilterPagedTable() {
        return this.filterPagedTable;
    }

    public void setFilterPagedTable(FilterPagedTable<T> filterPagedTable) {
        this.filterPagedTable = filterPagedTable;
    }

    public Column<T, String> createTextColumn(String columnId, final Function<T, String> valueFunction) {
        Column column = new Column<T, String>((Cell)new TextCell()){

            public String getValue(T domain) {
                return (String)valueFunction.apply(domain);
            }
        };
        column.setSortable(true);
        column.setDataStoreName(columnId);
        return column;
    }

    public Column<T, Number> createNumberColumn(String columnId, final Function<T, Number> valueFunction) {
        Column column = new Column<T, Number>((Cell)new NumberCell()){

            public Number getValue(T domain) {
                return (Number)valueFunction.apply(domain);
            }
        };
        column.setSortable(true);
        column.setDataStoreName(columnId);
        return column;
    }

    protected ColumnMeta<T> initChecksColumn(final ExtendedPagedTable<T> extendedPagedTable) {
        CheckboxCell checkboxCell = new CheckboxCell(true, false);
        Column checkColumn = new Column<T, Boolean>((Cell)checkboxCell){

            public Boolean getValue(T pis) {
                return pis.isSelected();
            }
        };
        Header<Boolean> selectPageHeader = new Header<Boolean>((Cell)checkboxCell){

            public Boolean getValue() {
                return extendedPagedTable.isAllItemsSelected();
            }
        };
        selectPageHeader.setUpdater(value -> {
            this.getListGrid().getVisibleItems().forEach(pis -> pis.setSelected(value.booleanValue()));
            this.getListGrid().redraw();
        });
        checkColumn.setSortable(false);
        checkColumn.setDataStoreName(COL_ID_SELECT);
        ColumnMeta checkColMeta = new ColumnMeta(checkColumn, "");
        checkColMeta.setHeader((Header)selectPageHeader);
        return checkColMeta;
    }

    @Override
    public int getRefreshValue() {
        return this.getMultiGridPreferencesStore().getRefreshInterval();
    }

    @Override
    public void saveRefreshValue(int newValue) {
        this.filterPagedTable.saveNewRefreshInterval(newValue);
    }

    @Override
    public void addTextFilter(String label, String placeholder, Consumer<String> addCallback, Consumer<String> removeCallback) {
        this.advancedSearchFiltersView.addTextFilter(label, placeholder, addCallback, removeCallback);
    }

    @Override
    public void addNumericFilter(String label, String placeholder, Consumer<String> addCallback, Consumer<String> removeCallback) {
        this.advancedSearchFiltersView.addNumericFilter(label, placeholder, addCallback, removeCallback);
    }

    @Override
    public void addSelectFilter(String label, Map<String, String> options, Boolean liveSearch, Consumer<String> addCallback, Consumer<String> removeCallback) {
        this.advancedSearchFiltersView.addSelectFilter(label, options, liveSearch, addCallback, removeCallback);
    }

    @Override
    public <T> void addActiveFilter(String labelKey, String labelValue, T value, Consumer<T> removeCallback) {
        this.advancedSearchFiltersView.addActiveFilter(labelKey, labelValue, value, removeCallback);
    }

    @Override
    public void addDataSetSelectFilter(String label, String tableKey, DataSetLookup lookup, String textColumnId, String valueColumnId, Consumer<String> addCallback, Consumer<String> removeCallback) {
        this.advancedSearchFiltersView.addDataSetSelectFilter(label, tableKey, lookup, textColumnId, valueColumnId, addCallback, removeCallback);
    }

    @Override
    public void addDateRangeFilter(String label, String placeholder, Consumer<DateRange> addCallback, Consumer<DateRange> removeCallback) {
        this.advancedSearchFiltersView.addDateRangeFilter(label, placeholder, addCallback, removeCallback);
    }

    @Override
    public void removeAllActiveFilters() {
        this.advancedSearchFiltersView.removeAllActiveFilters();
    }

    static interface Binder
    extends UiBinder<Widget, AbstractMultiGridView> {
    }
}

