/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class TaskUtils {
    public static String TASK_STATUS_CREATED = "Created";
    public static String TASK_STATUS_READY = "Ready";
    public static String TASK_STATUS_RESERVED = "Reserved";
    public static String TASK_STATUS_IN_PROGRESS = "InProgress";
    public static String TASK_STATUS_SUSPENDED = "Suspended";
    public static String TASK_STATUS_FAILED = "Failed";
    public static String TASK_STATUS_ERROR = "Error";
    public static String TASK_STATUS_EXITED = "Exited";
    public static String TASK_STATUS_OBSOLETE = "Obsolete";
    public static String TASK_STATUS_COMPLETED = "Completed";

    public static List<String> getStatusByType(TaskType type) {
        ImmutableList status = null;
        switch (type) {
            case ACTIVE: {
                status = ImmutableList.of((Object)TASK_STATUS_READY, (Object)TASK_STATUS_RESERVED, (Object)TASK_STATUS_IN_PROGRESS);
                break;
            }
            case GROUP: {
                status = ImmutableList.of((Object)TASK_STATUS_READY);
                break;
            }
            case ALL: {
                status = ImmutableList.of((Object)TASK_STATUS_CREATED, (Object)TASK_STATUS_READY, (Object)TASK_STATUS_RESERVED, (Object)TASK_STATUS_IN_PROGRESS, (Object)TASK_STATUS_SUSPENDED, (Object)TASK_STATUS_FAILED, (Object)TASK_STATUS_ERROR, (Object)TASK_STATUS_EXITED, (Object)TASK_STATUS_OBSOLETE, (Object)TASK_STATUS_COMPLETED);
                break;
            }
            case PERSONAL: {
                status = ImmutableList.of((Object)TASK_STATUS_IN_PROGRESS, (Object)TASK_STATUS_CREATED, (Object)TASK_STATUS_RESERVED);
                break;
            }
            case ADMIN: {
                status = ImmutableList.of((Object)TASK_STATUS_READY, (Object)TASK_STATUS_IN_PROGRESS, (Object)TASK_STATUS_CREATED, (Object)TASK_STATUS_RESERVED, (Object)TASK_STATUS_SUSPENDED);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized view type '" + (Object)((Object)type) + "'!");
            }
        }
        return Lists.newArrayList((Iterable)status);
    }

    public static enum TaskType {
        PERSONAL,
        ACTIVE,
        GROUP,
        ALL,
        ADMIN;

    }
}

