/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.resources.CommonResources;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetEditorManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractMultiGridView<T extends GenericSummary, V extends AbstractMultiGridPresenter>
extends Composite
implements RequiresResize,
MultiGridView<T, V> {
    public static String FILTER_TABLE_SETTINGS = "tableSettings";
    public static String USER_DEFINED = "ud_";
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @Inject
    public User identity;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    protected DataSetEditorManager dataSetEditorManager;
    @Inject
    protected PlaceManager placeManager;
    @Inject
    private Caller<UserPreferencesService> preferencesService;
    @UiField
    org.gwtbootstrap3.client.ui.Column column;
    protected V presenter;
    protected FilterPagedTable<T> filterPagedTable;
    protected ExtendedPagedTable<T> currentListGrid;
    protected RowStyles<T> selectedStyles = new RowStyles<T>(){

        public String getStyleNames(T row, int rowIndex) {
            if (rowIndex == AbstractMultiGridView.this.selectedRow) {
                return CommonResources.INSTANCE.css().selected();
            }
            return null;
        }
    };
    protected NoSelectionModel<T> selectionModel;
    protected T selectedItem;
    protected int selectedRow = -1;
    protected Column actionsColumn;
    protected DefaultSelectionEventManager<T> noActionColumnManager;
    public GridGlobalPreferences currentGlobalPreferences;
    public Button createTabButton;

    public AbstractMultiGridView() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(final V presenter, final GridGlobalPreferences preferences, final Button createNewGridButton) {
        this.presenter = presenter;
        this.currentGlobalPreferences = preferences;
        this.createTabButton = createNewGridButton;
        this.filterPagedTable = (FilterPagedTable)GWT.create(FilterPagedTable.class);
        this.column.add(this.filterPagedTable.makeWidget());
        this.filterPagedTable.setPreferencesService(this.preferencesService);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<MultiGridPreferencesStore>(){

            public void callback(MultiGridPreferencesStore multiGridPreferencesStore) {
                if (multiGridPreferencesStore == null) {
                    multiGridPreferencesStore = new MultiGridPreferencesStore(preferences.getKey());
                }
                String selectedGridId = multiGridPreferencesStore.getSelectedGrid();
                AbstractMultiGridView.this.filterPagedTable.setMultiGridPreferencesStore(multiGridPreferencesStore);
                presenter.onGridPreferencesStoreLoaded();
                ArrayList existingGrids = multiGridPreferencesStore.getGridsId();
                if (existingGrids != null && existingGrids.size() > 0) {
                    AbstractMultiGridView.this.resetDefaultFilterTitleAndDescription();
                    presenter.setAddingDefaultFilters(true);
                    for (int i = 0; i < existingGrids.size(); ++i) {
                        String key = (String)existingGrids.get(i);
                        final ExtendedPagedTable extendedPagedTable = AbstractMultiGridView.this.loadGridInstance(preferences, key);
                        AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                        extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                        final String filterKey = key;
                        AbstractMultiGridView.this.filterPagedTable.addTab(extendedPagedTable, key, new Command(){

                            public void execute() {
                                AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                                AbstractMultiGridView.this.applyFilterOnPresenter(filterKey);
                            }
                        });
                        if (AbstractMultiGridView.this.currentListGrid == null || !key.equals(selectedGridId)) continue;
                        AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                    }
                    AbstractMultiGridView.this.filterPagedTable.addAddTableButton(createNewGridButton);
                    presenter.setAddingDefaultFilters(false);
                    if (selectedGridId != null) {
                        multiGridPreferencesStore.setSelectedGrid(selectedGridId);
                        ((UserPreferencesService)AbstractMultiGridView.this.preferencesService.call()).saveUserPreferences((UserPreference)multiGridPreferencesStore);
                        AbstractMultiGridView.this.filterPagedTable.setSelectedTab();
                    }
                } else {
                    AbstractMultiGridView.this.initDefaultFilters(preferences, createNewGridButton);
                }
                AbstractMultiGridView.this.initSelectionModel();
            }
        })).loadUserPreferences(preferences.getKey(), UserPreferencesType.MULTIGRIDPREFERENCES);
    }

    public void onResize() {
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public void showRestoreDefaultFilterConfirmationPopup() {
        YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)Constants.INSTANCE.RestoreDefaultFilters(), (String)Constants.INSTANCE.AreYouSureRestoreDefaultFilters(), (Command)new Command(){

            public void execute() {
                AbstractMultiGridView.this.showBusyIndicator(Constants.INSTANCE.Loading());
                AbstractMultiGridView.this.restoreTabs();
            }
        }, null, (Command)new Command(){

            public void execute() {
            }
        });
        yesNoCancelPopup.show();
    }

    public void restoreTabs() {
        ArrayList existingGrids = this.getMultiGridPreferencesStore().getGridsId();
        ArrayList allTabs = new ArrayList(existingGrids.size());
        ((AbstractListPresenter)this.presenter).setAddingDefaultFilters(true);
        if (existingGrids != null && existingGrids.size() > 0) {
            int i;
            for (i = 0; i < existingGrids.size(); ++i) {
                allTabs.add(existingGrids.get(i));
            }
            for (i = 0; i < allTabs.size(); ++i) {
                this.filterPagedTable.removeTab((String)allTabs.get(i));
            }
        }
        this.filterPagedTable.removeTab(0);
        this.initDefaultFilters(this.currentGlobalPreferences, this.createTabButton);
    }

    public void initGenericToolBar(ExtendedPagedTable<T> extendedPagedTable) {
    }

    public String getValidKeyForAdditionalListGrid(String baseName) {
        return this.filterPagedTable.getValidKeyForAdditionalListGrid(baseName + USER_DEFINED);
    }

    public ExtendedPagedTable<T> createGridInstance(GridGlobalPreferences preferences, String key) {
        ExtendedPagedTable newListGrid = new ExtendedPagedTable(10, preferences);
        newListGrid.setShowLastPagerButton(false);
        newListGrid.setShowFastFordwardPagerButton(false);
        newListGrid.setPreferencesService(this.preferencesService);
        newListGrid.setGridPreferencesStore(new GridPreferencesStore(preferences));
        this.initColumns(newListGrid);
        this.initGenericToolBar(newListGrid);
        newListGrid.loadPageSizePreferences();
        newListGrid.createPageSizesListBox(5, 20, 5);
        this.initExtraButtons(newListGrid);
        return newListGrid;
    }

    public ExtendedPagedTable<T> loadGridInstance(final GridGlobalPreferences preferences, String key) {
        final ExtendedPagedTable newListGrid = new ExtendedPagedTable(10, preferences);
        newListGrid.setShowLastPagerButton(false);
        newListGrid.setShowFastFordwardPagerButton(false);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<GridPreferencesStore>(){

            public void callback(GridPreferencesStore preferencesStore) {
                newListGrid.setPreferencesService(AbstractMultiGridView.this.preferencesService);
                if (preferencesStore == null) {
                    newListGrid.setGridPreferencesStore(new GridPreferencesStore(preferences));
                } else {
                    newListGrid.setGridPreferencesStore(preferencesStore);
                }
                AbstractMultiGridView.this.initColumns(newListGrid);
                AbstractMultiGridView.this.initGenericToolBar(newListGrid);
                newListGrid.loadPageSizePreferences();
                newListGrid.createPageSizesListBox(5, 20, 5);
            }
        })).loadUserPreferences(key, UserPreferencesType.GRIDPREFERENCES);
        this.initExtraButtons(newListGrid);
        return newListGrid;
    }

    @Override
    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    @Override
    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Override
    public ExtendedPagedTable<T> getListGrid() {
        return this.currentListGrid;
    }

    public abstract void initColumns(ExtendedPagedTable<T> var1);

    public abstract void initSelectionModel();

    public MultiGridPreferencesStore getMultiGridPreferencesStore() {
        if (this.filterPagedTable != null) {
            return this.filterPagedTable.getMultiGridPreferencesStore();
        }
        return null;
    }

    public void initExtraButtons(ExtendedPagedTable<T> extendedPagedTable) {
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
    }

    public void selectFirstTabAndEnableQueries(final String firsTabKey) {
        ((AbstractListPresenter)this.presenter).setAddingDefaultFilters(false);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                AbstractMultiGridView.this.getMultiGridPreferencesStore().setSelectedGrid(firsTabKey);
                AbstractMultiGridView.this.filterPagedTable.setSelectedTab();
            }
        });
    }

    public void applyFilterOnPresenter(HashMap<String, Object> params) {
        String tableSettingsJSON = (String)params.get(FILTER_TABLE_SETTINGS);
        FilterSettings tableSettings = this.dataSetEditorManager.getStrToTableSettings(tableSettingsJSON);
        ((AbstractMultiGridPresenter)this.presenter).filterGrid(tableSettings);
    }

    @Override
    public void applyFilterOnPresenter(String key) {
        this.initSelectionModel();
        this.applyFilterOnPresenter(this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key));
    }

    public void setIdentity(User identity) {
        this.identity = identity;
    }

    public void setPreferencesService(Caller<UserPreferencesService> preferencesService) {
        this.preferencesService = preferencesService;
    }

    public abstract void resetDefaultFilterTitleAndDescription();

    protected void saveTabSettings(String key, String name, String description) {
        HashMap tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key);
        if (tabSettingsValues != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, name);
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, description);
            this.filterPagedTable.saveTabSettings(key, tabSettingsValues);
        }
    }

    public FilterPagedTable<T> getFilterPagedTable() {
        return this.filterPagedTable;
    }

    public void setFilterPagedTable(FilterPagedTable<T> filterPagedTable) {
        this.filterPagedTable = filterPagedTable;
    }

    public Column<T, String> createTextColumn(String columnId, final Function<T, String> valueFunction) {
        Column column = new Column<T, String>((Cell)new TextCell()){

            public String getValue(T domain) {
                return (String)valueFunction.apply(domain);
            }
        };
        column.setSortable(true);
        column.setDataStoreName(columnId);
        return column;
    }

    public Column<T, Number> createNumberColumn(String columnId, final Function<T, Number> valueFunction) {
        Column column = new Column<T, Number>((Cell)new NumberCell()){

            public Number getValue(T domain) {
                return (Number)valueFunction.apply(domain);
            }
        };
        column.setSortable(true);
        column.setDataStoreName(columnId);
        return column;
    }

    @Override
    public int getRefreshValue() {
        return this.getMultiGridPreferencesStore().getRefreshInterval();
    }

    @Override
    public void saveRefreshValue(int newValue) {
        this.filterPagedTable.saveNewRefreshInterval(newValue);
    }

    static interface Binder
    extends UiBinder<Widget, AbstractMultiGridView> {
    }
}

