/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.common.client.list.ActiveFilterItem;
import org.jbpm.workbench.common.client.list.AdvancedSearchFiltersViewImpl;
import org.jbpm.workbench.common.client.util.DateRange;
import org.jbpm.workbench.common.client.util.UTCDateBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class AdvancedSearchFiltersViewImplTest {
    @Mock
    DataBinder<List<ActiveFilterItem>> dataBinder;
    @Mock
    List<ActiveFilterItem> modelList;
    @Mock
    TranslationService translationService;
    @InjectMocks
    AdvancedSearchFiltersViewImpl view;

    @Before
    public void setup() {
        Mockito.when((Object)this.dataBinder.getModel()).thenReturn(this.modelList);
    }

    @Test
    public void testDateChangeNoValue() {
        UTCDateBox fromDate = (UTCDateBox)Mockito.mock(UTCDateBox.class);
        Mockito.when((Object)fromDate.getValue()).thenReturn(null, (Object[])new Long[]{null, 1L});
        UTCDateBox toDate = (UTCDateBox)Mockito.mock(UTCDateBox.class);
        Mockito.when((Object)toDate.getValue()).thenReturn(null, (Object[])new Long[]{1L, null});
        this.view.onDateValueChange("", fromDate, toDate, null, null);
        this.view.onDateValueChange("", fromDate, toDate, null, null);
        this.view.onDateValueChange("", fromDate, toDate, null, null);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.dataBinder});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.modelList});
    }

    @Test
    public void testDateChange() {
        UTCDateBox fromDate = (UTCDateBox)Mockito.mock(UTCDateBox.class);
        Mockito.when((Object)fromDate.getValue()).thenReturn((Object)System.currentTimeMillis());
        UTCDateBox toDate = (UTCDateBox)Mockito.mock(UTCDateBox.class);
        Mockito.when((Object)toDate.getValue()).thenReturn((Object)System.currentTimeMillis());
        Consumer addCallback = (Consumer)Mockito.mock(Consumer.class);
        this.view.onDateValueChange("", fromDate, toDate, addCallback, null);
        ((List)Mockito.verify(this.modelList)).add(Mockito.any(ActiveFilterItem.class));
        ((UTCDateBox)Mockito.verify((Object)fromDate)).setValue(null);
        ((UTCDateBox)Mockito.verify((Object)toDate)).setValue(null);
        ((Consumer)Mockito.verify((Object)addCallback)).accept(Mockito.any(DateRange.class));
    }

    @Test
    public void testNumericInput() {
        this.testValidKeyCode(8);
        this.testValidKeyCode(57);
        this.testValidKeyCode(104);
        this.testValidKeyCode(96);
        this.testInvalidKeyCode(109);
        this.testInvalidKeyCode(107);
        this.testInvalidKeyCode(32);
        this.testInvalidKeyCode(45);
    }

    protected void testInvalidKeyCode(int keyCode) {
        this.testKeyCode(keyCode, 1);
    }

    protected void testKeyCode(int keyCode, int wantedNumberOfInvocations) {
        KeyboardEvent event = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        Mockito.when((Object)event.getKeyCode()).thenReturn((Object)keyCode);
        this.view.getNumericInputListener().call((Event)event);
        ((KeyboardEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).preventDefault();
    }

    protected void testValidKeyCode(int keyCode) {
        this.testKeyCode(keyCode, 0);
    }
}

