/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.jbpm.workbench.common.client.events.SearchEvent;
import org.jbpm.workbench.common.client.list.AbstractScreenListPresenter;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetQueryHelper;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.menu.RefreshSelectorMenuBuilder;
import org.uberfire.lifecycle.OnOpen;

public abstract class AbstractMultiGridPresenter<T extends GenericSummary, V extends MultiGridView>
extends AbstractScreenListPresenter<T>
implements RefreshSelectorMenuBuilder.SupportsRefreshInterval {
    protected DataSetQueryHelper dataSetQueryHelper;
    protected RefreshSelectorMenuBuilder refreshSelectorMenuBuilder = new RefreshSelectorMenuBuilder((RefreshSelectorMenuBuilder.SupportsRefreshInterval)this);
    protected V view;

    @Inject
    public void setDataSetQueryHelper(DataSetQueryHelper dataSetQueryHelper) {
        this.dataSetQueryHelper = dataSetQueryHelper;
    }

    @Inject
    public void setView(V view) {
        this.view = view;
    }

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    @Override
    public void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
    }

    @Override
    public void onUpdateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        super.onUpdateRefreshInterval(enableAutoRefresh, newInterval);
        this.view.saveRefreshValue(newInterval);
    }

    @Override
    public void onGridPreferencesStoreLoaded() {
        this.refreshSelectorMenuBuilder.loadOptions(this.view.getRefreshValue());
    }

    @Override
    protected ListView getListView() {
        return this.view;
    }

    @WorkbenchPartView
    public UberView<T> getView() {
        return this.view;
    }

    public abstract FilterSettings createTableSettingsPrototype();

    public abstract FilterSettings createSearchTabSettings();

    public abstract void setupAdvancedSearchView();

    @Override
    @OnOpen
    public void onOpen() {
        super.onOpen();
        this.setupAdvancedSearchView();
    }

    protected void addAdvancedSearchFilter(ColumnFilter columnFilter) {
        FilterSettings settings = this.view.getAdvancedSearchFilterSettings();
        if (settings.getDataSetLookup().getFirstFilterOp() != null) {
            settings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{columnFilter});
        } else {
            DataSetFilter filter = new DataSetFilter();
            filter.addFilterColumn(new ColumnFilter[]{columnFilter});
            settings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        }
        this.view.saveAdvancedSearchFilterSettings(settings);
        this.filterGrid(settings);
    }

    protected void removeAdvancedSearchFilter(ColumnFilter columnFilter) {
        FilterSettings settings = this.view.getAdvancedSearchFilterSettings();
        if (settings.getDataSetLookup().getFirstFilterOp() != null) {
            settings.getDataSetLookup().getFirstFilterOp().getColumnFilterList().remove(columnFilter);
            this.view.saveAdvancedSearchFilterSettings(settings);
            this.filterGrid(settings);
        }
    }
}

