/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSetLookup;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AdvancedSearchFiltersViewImpl;
import org.jbpm.workbench.common.client.list.AdvancedSearchTable;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.resources.CommonResources;
import org.jbpm.workbench.common.client.resources.css.CommonCSS;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.client.util.DateRange;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetEditorManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractMultiGridView<T extends GenericSummary, V extends AbstractMultiGridPresenter>
extends Composite
implements MultiGridView<T, V> {
    public static final String TAB_SEARCH = "base";
    public static final String FILTER_TABLE_SETTINGS = "tableSettings";
    public static final String USER_DEFINED = "ud_";
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private final CommonCSS commonCSS = CommonResources.INSTANCE.css();
    private final Constants constants = Constants.INSTANCE;
    @Inject
    public User identity;
    @Inject
    protected Event<NotificationEvent> notification;
    protected DataSetEditorManager dataSetEditorManager;
    @Inject
    protected PlaceManager placeManager;
    private Caller<UserPreferencesService> preferencesService;
    @Inject
    protected AdvancedSearchFiltersViewImpl advancedSearchFiltersView;
    @UiField
    org.gwtbootstrap3.client.ui.Column column;
    protected V presenter;
    protected FilterPagedTable<T> filterPagedTable = (FilterPagedTable)GWT.create(FilterPagedTable.class);
    protected ExtendedPagedTable<T> currentListGrid;
    protected RowStyles<T> selectedStyles = new RowStyles<T>(){

        public String getStyleNames(T row, int rowIndex) {
            if (rowIndex == AbstractMultiGridView.this.selectedRow) {
                return AbstractMultiGridView.this.commonCSS.selected();
            }
            return null;
        }
    };
    protected T selectedItem;
    protected int selectedRow = -1;
    public GridGlobalPreferences currentGlobalPreferences;
    public Button createTabButton = (Button)GWT.create(Button.class);

    public AbstractMultiGridView() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.column.add(this.filterPagedTable.makeWidget());
        this.createTabButton.setIcon(IconType.PLUS);
        this.createTabButton.setSize(ButtonSize.SMALL);
    }

    public void init(final V presenter, final GridGlobalPreferences preferences) {
        this.presenter = presenter;
        this.currentGlobalPreferences = preferences;
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<MultiGridPreferencesStore>(){

            public void callback(MultiGridPreferencesStore multiGridPreferencesStore) {
                if (multiGridPreferencesStore == null) {
                    multiGridPreferencesStore = new MultiGridPreferencesStore(preferences.getKey());
                }
                String selectedGridId = multiGridPreferencesStore.getSelectedGrid();
                AbstractMultiGridView.this.filterPagedTable.setMultiGridPreferencesStore(multiGridPreferencesStore);
                presenter.onGridPreferencesStoreLoaded();
                ArrayList existingGrids = multiGridPreferencesStore.getGridsId();
                if (existingGrids != null && existingGrids.size() > 0) {
                    AbstractMultiGridView.this.resetDefaultFilterTitleAndDescription();
                    presenter.setAddingDefaultFilters(true);
                    for (int i = 0; i < existingGrids.size(); ++i) {
                        String key = (String)existingGrids.get(i);
                        ExtendedPagedTable extendedPagedTable = AbstractMultiGridView.this.loadGridInstance(preferences, key);
                        AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                        extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                        AbstractMultiGridView.this.filterPagedTable.addTab(extendedPagedTable, key, () -> {
                            AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                            AbstractMultiGridView.this.applyFilterOnPresenter(key);
                        }, false);
                        if (AbstractMultiGridView.this.currentListGrid == null || !key.equals(selectedGridId)) continue;
                        AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                    }
                    AbstractMultiGridView.this.filterPagedTable.addAddTableButton(AbstractMultiGridView.this.createTabButton);
                    presenter.setAddingDefaultFilters(false);
                    if (selectedGridId != null) {
                        multiGridPreferencesStore.setSelectedGrid(selectedGridId);
                        ((UserPreferencesService)AbstractMultiGridView.this.preferencesService.call()).saveUserPreferences((UserPreference)multiGridPreferencesStore);
                        AbstractMultiGridView.this.filterPagedTable.setSelectedTab();
                    }
                } else {
                    AbstractMultiGridView.this.initDefaultFilters(preferences, AbstractMultiGridView.this.createTabButton);
                }
            }
        })).loadUserPreferences(preferences.getKey(), UserPreferencesType.MULTIGRIDPREFERENCES);
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public void showRestoreDefaultFilterConfirmationPopup() {
        YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)this.constants.RestoreDefaultFilters(), (String)this.constants.AreYouSureRestoreDefaultFilters(), (Command)new Command(){

            public void execute() {
                AbstractMultiGridView.this.showBusyIndicator(AbstractMultiGridView.this.constants.Loading());
                AbstractMultiGridView.this.restoreTabs();
            }
        }, null, (Command)new Command(){

            public void execute() {
            }
        });
        yesNoCancelPopup.show();
    }

    public void restoreTabs() {
        ArrayList existingGrids = this.getMultiGridPreferencesStore().getGridsId();
        ArrayList allTabs = new ArrayList(existingGrids.size());
        ((AbstractListPresenter)this.presenter).setAddingDefaultFilters(true);
        if (existingGrids != null && existingGrids.size() > 0) {
            int i;
            for (i = 0; i < existingGrids.size(); ++i) {
                allTabs.add(existingGrids.get(i));
            }
            for (i = 0; i < allTabs.size(); ++i) {
                this.filterPagedTable.removeTab((String)allTabs.get(i));
            }
        }
        this.filterPagedTable.removeTab(0);
        this.initDefaultFilters(this.currentGlobalPreferences, this.createTabButton);
    }

    public void initGenericToolBar(ExtendedPagedTable<T> extendedPagedTable) {
    }

    public String getValidKeyForAdditionalListGrid(String baseName) {
        return this.filterPagedTable.getValidKeyForAdditionalListGrid(baseName + USER_DEFINED);
    }

    public ExtendedPagedTable<T> createGridInstance(GridGlobalPreferences preferences, String key) {
        ExtendedPagedTable<T> newListGrid = this.createExtendedPagedTable(preferences, key);
        newListGrid.setShowLastPagerButton(false);
        newListGrid.setShowFastFordwardPagerButton(false);
        newListGrid.setPreferencesService(this.preferencesService);
        newListGrid.setGridPreferencesStore(new GridPreferencesStore(preferences));
        this.initColumns(newListGrid);
        this.initGenericToolBar(newListGrid);
        this.initSelectionModel(newListGrid);
        newListGrid.loadPageSizePreferences();
        newListGrid.createPageSizesListBox(5, 20, 5);
        return newListGrid;
    }

    protected ExtendedPagedTable<T> createExtendedPagedTable(GridGlobalPreferences preferences, String key) {
        return TAB_SEARCH.equals(key) ? this.createAdvancedSearchTable(preferences) : new AdvancedSearchTable<T>(preferences);
    }

    protected AdvancedSearchTable<T> createAdvancedSearchTable(GridGlobalPreferences preferences) {
        AdvancedSearchTable advancedSearchTable = new AdvancedSearchTable(preferences);
        advancedSearchTable.getTopToolbar().add((Widget)this.advancedSearchFiltersView);
        return advancedSearchTable;
    }

    public ExtendedPagedTable<T> loadGridInstance(final GridGlobalPreferences preferences, String key) {
        final ExtendedPagedTable<T> newListGrid = this.createExtendedPagedTable(preferences, key);
        newListGrid.setShowLastPagerButton(false);
        newListGrid.setShowFastFordwardPagerButton(false);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<GridPreferencesStore>(){

            public void callback(GridPreferencesStore preferencesStore) {
                newListGrid.setPreferencesService(AbstractMultiGridView.this.preferencesService);
                if (preferencesStore == null) {
                    newListGrid.setGridPreferencesStore(new GridPreferencesStore(preferences));
                } else {
                    newListGrid.setGridPreferencesStore(preferencesStore);
                }
                AbstractMultiGridView.this.initColumns(newListGrid);
                AbstractMultiGridView.this.initGenericToolBar(newListGrid);
                AbstractMultiGridView.this.initSelectionModel(newListGrid);
                newListGrid.loadPageSizePreferences();
                newListGrid.createPageSizesListBox(5, 20, 5);
            }
        })).loadUserPreferences(key, UserPreferencesType.GRIDPREFERENCES);
        return newListGrid;
    }

    @Override
    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    @Override
    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Override
    public ExtendedPagedTable<T> getListGrid() {
        return this.currentListGrid;
    }

    public abstract void initColumns(ExtendedPagedTable<T> var1);

    public abstract void initSelectionModel(ExtendedPagedTable<T> var1);

    public MultiGridPreferencesStore getMultiGridPreferencesStore() {
        if (this.filterPagedTable != null) {
            return this.filterPagedTable.getMultiGridPreferencesStore();
        }
        return null;
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        ((AbstractListPresenter)this.presenter).setAddingDefaultFilters(true);
        FilterSettings settings = ((AbstractMultiGridPresenter)this.presenter).createSearchTabSettings();
        settings.setTableName(this.constants.Search());
        settings.setTableDescription(this.constants.SearchResults());
        settings.setKey(TAB_SEARCH);
        this.addNewTab(preferences, settings);
    }

    public void addNewTab(GridGlobalPreferences preferences, FilterSettings tableSettings) {
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(tableSettings.getKey(), tabSettingsValues);
        ExtendedPagedTable<T> extendedPagedTable = this.createGridInstance(preferences, tableSettings.getKey());
        this.currentListGrid = extendedPagedTable;
        extendedPagedTable.setDataProvider((AbstractDataProvider)((AbstractListPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab(extendedPagedTable, tableSettings.getKey(), () -> {
            this.currentListGrid = extendedPagedTable;
            this.applyFilterOnPresenter(tableSettings.getKey());
        }, false);
    }

    public void selectFirstTabAndEnableQueries() {
        Scheduler.get().scheduleDeferred(this.getSelectFirstTabAndEnableQueriesCommand());
    }

    protected Scheduler.ScheduledCommand getSelectFirstTabAndEnableQueriesCommand() {
        return () -> {
            ((AbstractListPresenter)this.presenter).setAddingDefaultFilters(false);
            this.getMultiGridPreferencesStore().setSelectedGrid(TAB_SEARCH);
            this.filterPagedTable.setSelectedTab();
        };
    }

    @Override
    public void applyFilterOnPresenter(String key) {
        this.applyFilterOnPresenter(this.getTableFilterSettings(key));
    }

    public void applyFilterOnPresenter(FilterSettings filterSettings) {
        ((AbstractMultiGridPresenter)this.presenter).filterGrid(filterSettings);
    }

    protected FilterSettings getTableFilterSettings(String key) {
        HashMap<String, Object> params = this.getGridSettings(key);
        String tableSettingsJSON = (String)params.get(FILTER_TABLE_SETTINGS);
        return this.dataSetEditorManager.getStrToTableSettings(tableSettingsJSON);
    }

    @Override
    public FilterSettings getAdvancedSearchFilterSettings() {
        return this.getTableFilterSettings(TAB_SEARCH);
    }

    @Override
    public void saveAdvancedSearchFilterSettings(FilterSettings settings) {
        HashMap<String, Object> gridSettings = this.getGridSettings(TAB_SEARCH);
        gridSettings.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(settings));
        this.filterPagedTable.saveTabSettings(TAB_SEARCH, gridSettings);
    }

    protected HashMap<String, Object> getGridSettings(String key) {
        return this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key);
    }

    public void setIdentity(User identity) {
        this.identity = identity;
    }

    @Inject
    public void setPreferencesService(Caller<UserPreferencesService> preferencesService) {
        this.preferencesService = preferencesService;
        this.filterPagedTable.setPreferencesService(preferencesService);
    }

    @Inject
    public void setDataSetEditorManager(DataSetEditorManager dataSetEditorManager) {
        this.dataSetEditorManager = dataSetEditorManager;
    }

    public void resetDefaultFilterTitleAndDescription() {
        this.saveTabSettings(TAB_SEARCH, this.constants.Search(), this.constants.SearchResults());
    }

    protected void saveTabSettings(String key, String name, String description) {
        HashMap<String, Object> tabSettingsValues = this.getGridSettings(key);
        if (tabSettingsValues != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, name);
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, description);
            this.filterPagedTable.saveTabSettings(key, tabSettingsValues);
        }
    }

    public FilterPagedTable<T> getFilterPagedTable() {
        return this.filterPagedTable;
    }

    public void setFilterPagedTable(FilterPagedTable<T> filterPagedTable) {
        this.filterPagedTable = filterPagedTable;
    }

    public Column<T, String> createTextColumn(String columnId, final Function<T, String> valueFunction) {
        Column column = new Column<T, String>((Cell)new TextCell()){

            public String getValue(T domain) {
                return (String)valueFunction.apply(domain);
            }
        };
        column.setSortable(true);
        column.setDataStoreName(columnId);
        return column;
    }

    public Column<T, Number> createNumberColumn(String columnId, final Function<T, Number> valueFunction) {
        Column column = new Column<T, Number>((Cell)new NumberCell()){

            public Number getValue(T domain) {
                return (Number)valueFunction.apply(domain);
            }
        };
        column.setSortable(true);
        column.setDataStoreName(columnId);
        return column;
    }

    @Override
    public int getRefreshValue() {
        return this.getMultiGridPreferencesStore().getRefreshInterval();
    }

    @Override
    public void saveRefreshValue(int newValue) {
        this.filterPagedTable.saveNewRefreshInterval(newValue);
    }

    @Override
    public void addTextFilter(String label, String placeholder, Consumer<String> addCallback, Consumer<String> removeCallback) {
        this.advancedSearchFiltersView.addTextFilter(label, placeholder, addCallback, removeCallback);
    }

    @Override
    public void addNumericFilter(String label, String placeholder, Consumer<String> addCallback, Consumer<String> removeCallback) {
        this.advancedSearchFiltersView.addNumericFilter(label, placeholder, addCallback, removeCallback);
    }

    @Override
    public void addSelectFilter(String label, Map<String, String> options, Boolean liveSearch, Consumer<String> addCallback, Consumer<String> removeCallback) {
        this.advancedSearchFiltersView.addSelectFilter(label, options, liveSearch, addCallback, removeCallback);
    }

    @Override
    public <T> void addActiveFilter(String labelKey, String labelValue, T value, Consumer<T> removeCallback) {
        this.advancedSearchFiltersView.addActiveFilter(labelKey, labelValue, value, removeCallback);
    }

    @Override
    public void addDataSetSelectFilter(String label, String tableKey, DataSetLookup lookup, String textColumnId, String valueColumnId, Consumer<String> addCallback, Consumer<String> removeCallback) {
        this.advancedSearchFiltersView.addDataSetSelectFilter(label, tableKey, lookup, textColumnId, valueColumnId, addCallback, removeCallback);
    }

    @Override
    public void addDateRangeFilter(String label, Consumer<DateRange> addCallback, Consumer<DateRange> removeCallback) {
        this.advancedSearchFiltersView.addDateRangeFilter(label, addCallback, removeCallback);
    }

    static interface Binder
    extends UiBinder<Widget, AbstractMultiGridView> {
    }
}

