/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSetLookup;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.NodeList;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.OptionsCollection;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.databinding.client.components.ListContainer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.dataset.DataSetAwareSelect;
import org.jbpm.workbench.common.client.list.ActiveFilterItem;
import org.jbpm.workbench.common.client.list.ActiveFilterItemRemoved;
import org.jbpm.workbench.common.client.list.ActiveFilterItemView;
import org.jbpm.workbench.common.client.list.AdvancedSearchFiltersView;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.client.util.DateRange;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.common.client.util.UTCDateBox;
import org.uberfire.client.views.pfly.widgets.Select;

@Dependent
@Templated
public class AdvancedSearchFiltersViewImpl
extends Composite
implements AdvancedSearchFiltersView {
    private final Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="dropdown-filter-text")
    Span filterText;
    @Inject
    @DataField(value="active-filters-text")
    Span activeFiltersText;
    @Inject
    @DataField(value="filters-input")
    Div filtersInput;
    @Inject
    @DataField(value="remove-all-filters")
    Anchor removeAll;
    @Inject
    @DataField(value="filters")
    UnorderedList filters;
    @Inject
    @DataField(value="active-filters")
    @ListContainer(value="ul")
    @Bound
    private ListComponent<ActiveFilterItem, ActiveFilterItemView> activeFilters;
    @Inject
    @AutoBound
    private DataBinder<List<ActiveFilterItem>> activeFiltersList;
    @Inject
    @DataField(value="select-filters")
    private Div selectFilters;
    @Inject
    private ManagedInstance<Select> selectProvider;
    @Inject
    private ManagedInstance<DataSetAwareSelect> dataSetSelectProvider;

    @PostConstruct
    public void init() {
        this.removeAll.setTextContent(this.constants.ClearAll());
        this.activeFiltersText.setTextContent(this.constants.ActiveFilters());
        this.activeFiltersList.setModel(new ArrayList());
        this.activeFilters.addComponentCreationHandler(v -> DOMUtil.removeCSSClass((HTMLElement)this.removeAll, (String)"hidden"));
        this.activeFilters.addComponentDestructionHandler(v -> {
            if (((List)this.activeFiltersList.getModel()).isEmpty()) {
                DOMUtil.addCSSClass((HTMLElement)this.removeAll, (String)"hidden");
            }
            v.getValue().getCallback().accept(v.getValue().getValue());
        });
    }

    @Override
    public void addTextFilter(String label, String placeholder, Consumer<String> addCallback, Consumer<String> removeCallback) {
        this.createFilterOption(label);
        this.createInput(label, placeholder, input -> input.setType("text"), addCallback, removeCallback);
    }

    @Override
    public void addNumericFilter(String label, String placeholder, Consumer<String> addCallback, Consumer<String> removeCallback) {
        this.createFilterOption(label);
        this.createInput(label, placeholder, input -> {
            input.setType("number");
            input.setAttribute("min", "0");
            input.addEventListener("keypress", this.getNumericInputListener(), false);
        }, addCallback, removeCallback);
    }

    protected EventListener<KeyboardEvent> getNumericInputListener() {
        return e -> {
            if (!(e.getKeyCode() >= 96 && e.getKeyCode() <= 105 || e.getKeyCode() >= 48 && e.getKeyCode() <= 57 || e.getKeyCode() == 8)) {
                e.preventDefault();
            }
        };
    }

    @Override
    public void addDataSetSelectFilter(String label, String tableKey, DataSetLookup lookup, String textColumnId, String valueColumnId, Consumer<String> addCallback, Consumer<String> removeCallback) {
        DataSetAwareSelect select = (DataSetAwareSelect)this.dataSetSelectProvider.get();
        select.setDataSetLookup(lookup);
        select.setTextColumnId(textColumnId);
        select.setValueColumnId(valueColumnId);
        select.setTableKey(tableKey);
        this.setupSelect(label, false, select.getSelect(), addCallback, removeCallback);
    }

    @Override
    public void addDateRangeFilter(String label, Consumer<DateRange> addCallback, Consumer<DateRange> removeCallback) {
        UTCDateBox fromDate = (UTCDateBox)((Object)GWT.create(UTCDateBox.class));
        UTCDateBox toDate = (UTCDateBox)((Object)GWT.create(UTCDateBox.class));
        fromDate.addValueChangeHandler(e -> this.onDateValueChange(label, fromDate, toDate, addCallback, removeCallback));
        toDate.addValueChangeHandler(e -> this.onDateValueChange(label, fromDate, toDate, addCallback, removeCallback));
        Div div = (Div)Window.getDocument().createElement("div");
        div.setAttribute("data-filter", label);
        div.getClassList().add("input-group");
        div.getClassList().add("filter-control");
        div.getClassList().add("hidden");
        DOMUtil.appendWidgetToElement((HTMLElement)div, (Widget)fromDate);
        Div divTo = (Div)Window.getDocument().createElement("div");
        divTo.getClassList().add("input-group-addon");
        divTo.setTextContent("to");
        div.appendChild((Node)divTo);
        DOMUtil.appendWidgetToElement((HTMLElement)div, (Widget)toDate);
        this.filtersInput.appendChild((Node)div);
        this.createFilterOption(label);
        if (this.filterText.getTextContent().isEmpty()) {
            this.setCurrentFilter(label);
        }
    }

    protected void onDateValueChange(String label, UTCDateBox fromDate, UTCDateBox toDate, Consumer<DateRange> addCallback, Consumer<DateRange> removeCallback) {
        if (toDate.getValue() == null || fromDate.getValue() == null) {
            return;
        }
        Date toDateValue = UTCDateBox.utc2date(toDate.getValue());
        Date fromDateValue = UTCDateBox.utc2date(fromDate.getValue());
        DateRange dateRange = new DateRange(fromDateValue, toDateValue);
        this.addActiveFilter(label, this.constants.From() + " " + DateUtils.getDateTimeStr(fromDateValue) + " " + this.constants.To() + " " + DateUtils.getDateTimeStr(toDateValue), dateRange, removeCallback);
        toDate.setValue(null);
        fromDate.setValue(null);
        addCallback.accept(dateRange);
    }

    @Override
    public void addSelectFilter(String label, Map<String, String> options, Boolean liveSearch, Consumer<String> addCallback, Consumer<String> removeCallback) {
        Select select = (Select)this.selectProvider.get();
        options.forEach((k, v) -> select.addOption(v, k));
        this.setupSelect(label, liveSearch, select, addCallback, removeCallback);
    }

    private void setupSelect(String label, Boolean liveSearch, Select select, Consumer<String> addCallback, Consumer<String> removeCallback) {
        select.setTitle(label);
        select.setLiveSearch(liveSearch);
        select.setWidth("auto");
        select.getElement().getClassList().add("selectpicker");
        select.getElement().getClassList().add("form-control");
        this.selectFilters.appendChild((Node)select.getElement());
        select.refresh();
        select.getElement().addEventListener("change", event -> {
            if (!select.getValue().isEmpty()) {
                OptionsCollection options = select.getOptions();
                for (int i = 0; i < options.getLength(); ++i) {
                    Option item = (Option)options.item(i);
                    if (!item.getSelected()) continue;
                    this.addActiveFilter(label, item.getText(), select.getValue(), removeCallback);
                    addCallback.accept(select.getValue());
                    select.setValue("");
                    break;
                }
            }
        }, false);
    }

    private void createInput(String label, String placeholder, Consumer<Input> customizeCallback, Consumer<String> addCallback, Consumer<String> removeCallback) {
        Input input = (Input)Window.getDocument().createElement("input");
        customizeCallback.accept(input);
        input.setAttribute("placeholder", placeholder);
        input.setAttribute("data-filter", label);
        input.getClassList().add("form-control");
        input.getClassList().add("filter-control");
        input.getClassList().add("hidden");
        input.addEventListener("keypress", e -> {
            if (e.getKeyCode() == 13 && !input.getValue().isEmpty()) {
                this.addActiveFilter(label, input.getValue(), input.getValue(), removeCallback);
                addCallback.accept(input.getValue());
                input.setValue("");
            }
        }, false);
        this.filtersInput.appendChild((Node)input);
        if (this.filterText.getTextContent().isEmpty()) {
            this.setCurrentFilter(label);
        }
    }

    private void createFilterOption(String label) {
        Anchor a = (Anchor)Window.getDocument().createElement("a");
        a.setTextContent(label);
        a.addEventListener("click", e -> this.setCurrentFilter(label), false);
        ListItem li = (ListItem)Window.getDocument().createElement("li");
        li.setAttribute("data-filter", label);
        li.appendChild((Node)a);
        this.filters.appendChild((Node)li);
    }

    public void setCurrentFilter(String label) {
        this.filterText.setTextContent(label);
        for (Element child : DOMUtil.elementIterable((NodeList)this.filters.getChildNodes())) {
            if (label.equals(child.getAttribute("data-filter"))) {
                DOMUtil.addCSSClass((HTMLElement)((HTMLElement)child), (String)"hidden");
                continue;
            }
            DOMUtil.removeCSSClass((HTMLElement)((HTMLElement)child), (String)"hidden");
        }
        for (Element child : DOMUtil.elementIterable((NodeList)this.filtersInput.getChildNodes())) {
            if (label.equals(child.getAttribute("data-filter"))) {
                DOMUtil.removeCSSClass((HTMLElement)((HTMLElement)child), (String)"hidden");
                continue;
            }
            DOMUtil.addCSSClass((HTMLElement)((HTMLElement)child), (String)"hidden");
        }
    }

    @Override
    public <T> void addActiveFilter(String labelKey, String labelValue, T value, Consumer<T> removeCallback) {
        ((List)this.activeFiltersList.getModel()).add(new ActiveFilterItem<T>(labelKey, labelValue, value, removeCallback));
    }

    public void onRemoveActiveFilter(@Observes ActiveFilterItemRemoved event) {
        ((List)this.activeFiltersList.getModel()).remove(event.getActiveFilterItem());
    }

    @EventHandler(value={"remove-all-filters"})
    public void onRemoveAll(@ForEvent(value={"click"}) Event e) {
        ((List)this.activeFiltersList.getModel()).clear();
    }
}

