/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import java.util.Date;
import org.jbpm.workbench.common.client.util.DateRange;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;

public class DateUtils {
    public static String DEFAULT_DATE_FORMAT_MASK = "dd/MM/yyyy";
    public static String DEFAULT_DATE_AND_TIME_FORMAT_MASK = "dd/MM/yyyy HH:mm";
    public static String DEFAULT_TIME_FORMAT_MASK = "HH:mm";

    public static Date createDate(String dateString) {
        return DateUtils.createDate(dateString, "yyyy-MM-dd");
    }

    public static Date createDate(String dateString, String dateFormat) {
        DateTimeFormat fmt = DateTimeFormat.getFormat((String)dateFormat);
        return fmt.parse(dateString);
    }

    public static DateRange getWorkWeekDateRange(Date date) {
        return DateUtils.getDateRangeStartingOnMonday(date, 5);
    }

    public static DateRange getWeekDateRange(Date date) {
        return DateUtils.getDateRangeStartingOnMonday(date, 7);
    }

    private static DateRange getDateRangeStartingOnMonday(Date dateWithinTheWeek, int nrOfDaysTotal) {
        int day;
        Date startDate = new Date(dateWithinTheWeek.getTime());
        int daysAfterMonday = day = startDate.getDay() - 1;
        if (day == -1) {
            daysAfterMonday = 6;
        }
        CalendarUtil.addDaysToDate((Date)startDate, (int)(-daysAfterMonday));
        Date endDate = new Date(startDate.getTime());
        CalendarUtil.addDaysToDate((Date)endDate, (int)(nrOfDaysTotal - 1));
        return new DateRange(startDate, endDate);
    }

    public static DateRange getMonthDateRange(Date date) {
        Date startDate = new Date(date.getTime());
        CalendarUtil.setToFirstDayOfMonth((Date)startDate);
        startDate.setHours(0);
        Date endDate = new Date(date.getTime());
        CalendarUtil.setToFirstDayOfMonth((Date)endDate);
        CalendarUtil.addMonthsToDate((Date)endDate, (int)1);
        CalendarUtil.addDaysToDate((Date)endDate, (int)-1);
        endDate.setHours(0);
        return new DateRange(startDate, endDate);
    }

    public static boolean isDateInRange(Date date, DateRange dateRange) {
        return date.compareTo(dateRange.getStartDate()) >= 0 && date.compareTo(dateRange.getEndDate()) <= 0;
    }

    public static int compareDates(Date firstDate, Date secondDate) {
        Date firstDateClone = new Date(firstDate.getYear(), firstDate.getMonth(), firstDate.getDate());
        Date secondDateClone = new Date(secondDate.getYear(), secondDate.getMonth(), secondDate.getDate());
        return firstDateClone.compareTo(secondDateClone);
    }

    public static boolean areDatesEqual(Date firstDate, Date secondDate) {
        return DateUtils.compareDates(firstDate, secondDate) == 0;
    }

    public static Date getSameOrClosestDateInPreviousMonth(Date date) {
        Date desiredDate = new Date(date.getTime());
        CalendarUtil.addMonthsToDate((Date)desiredDate, (int)-1);
        if (desiredDate.getMonth() == date.getMonth()) {
            CalendarUtil.setToFirstDayOfMonth((Date)desiredDate);
            CalendarUtil.addDaysToDate((Date)desiredDate, (int)-1);
        }
        return desiredDate;
    }

    public static Date getSameOrClosestDateInNextMonth(Date date) {
        Date desiredDate = new Date(date.getTime());
        CalendarUtil.addMonthsToDate((Date)desiredDate, (int)1);
        if (desiredDate.getMonth() > date.getMonth() + 1) {
            CalendarUtil.setToFirstDayOfMonth((Date)desiredDate);
            CalendarUtil.addDaysToDate((Date)desiredDate, (int)-1);
        }
        return desiredDate;
    }

    public static String getDateFormatMask() {
        try {
            String fmt = ApplicationPreferences.getDroolsDateFormat();
            return fmt != null ? fmt : DEFAULT_DATE_FORMAT_MASK;
        }
        catch (Exception e) {
            return DEFAULT_DATE_FORMAT_MASK;
        }
    }

    public static String getDateTimeFormatMask() {
        try {
            String fmt = ApplicationPreferences.getDroolsDateTimeFormat();
            return fmt != null ? fmt : DEFAULT_DATE_AND_TIME_FORMAT_MASK;
        }
        catch (Exception e) {
            return DEFAULT_DATE_AND_TIME_FORMAT_MASK;
        }
    }

    public static String getTimeFormatMask() {
        return DEFAULT_TIME_FORMAT_MASK;
    }

    public static String getDateStr(Date date) {
        if (date != null) {
            DateTimeFormat format = DateTimeFormat.getFormat((String)DateUtils.getDateFormatMask());
            return format.format(date);
        }
        return "";
    }

    public static String getDateTimeStr(Date date) {
        if (date != null) {
            DateTimeFormat format = DateTimeFormat.getFormat((String)DateUtils.getDateTimeFormatMask());
            return format.format(date);
        }
        return "";
    }

    public static String getLocaleDateStr(Date date) {
        return DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_SHORT).format(date);
    }

    public static String getLocaleDateTimeStr(Date date) {
        return DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(date);
    }
}

