/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasValue;

public class InputWidget
extends FocusWidget
implements HasValue<String> {
    private String lastValue = null;

    public InputWidget(String type) {
        super((Element)DOM.createElement((String)"input"));
        this.getElement().setAttribute("type", type);
        this.addDomHandler((EventHandler)new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                InputWidget.this.fireValueChangeHandler(InputWidget.this.getValue());
            }
        }, ChangeEvent.getType());
        this.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                InputWidget.this.fireValueChangeHandler(InputWidget.this.getValue());
            }
        });
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public String getValue() {
        return this.getElement().getPropertyString("value");
    }

    public void setValue(String value) {
        this.setValue(value, false);
    }

    public void setValue(String value, boolean fireEvents) {
        if (value == null) {
            value = "";
        }
        this.getElement().setPropertyString("value", value);
        if (fireEvents) {
            this.fireValueChangeHandler(value);
        } else {
            this.lastValue = value;
        }
    }

    private void fireValueChangeHandler(String value) {
        ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)this, (Object)this.lastValue, (Object)value);
        this.lastValue = value;
    }
}

