/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.dataset;

import java.util.function.Consumer;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.jbpm.workbench.common.client.dataset.DataSetAwareSelect;
import org.jbpm.workbench.df.client.events.DataSetReadyEvent;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.ks.integration.ConsoleDataSetLookup;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.Select;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetAwareSelectTest {
    @Mock
    DataSetClientServices dataSetClientServices;
    @Spy
    FilterSettings filterSettings;
    @Mock
    Select select;
    @InjectMocks
    DataSetAwareSelect dataSetAwareSelect;

    @Before
    public void setup() {
        ((Select)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ((Consumer)invocation.getArguments()[0]).accept(DataSetAwareSelectTest.this.select);
                return null;
            }
        }).when((Object)this.select)).refresh((Consumer)Matchers.any(Consumer.class));
    }

    @Test
    public void testDifferentTableKey() {
        this.filterSettings.setKey("anotherkey");
        this.dataSetAwareSelect.setTableKey("key");
        this.dataSetAwareSelect.onDataSetReady(new DataSetReadyEvent(this.filterSettings));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.dataSetClientServices});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.select});
    }

    @Test
    public void testEmptyServerTemplate() {
        this.filterSettings.setKey("key");
        this.dataSetAwareSelect.setTableKey("key");
        this.dataSetAwareSelect.onDataSetReady(new DataSetReadyEvent(this.filterSettings));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.dataSetClientServices});
        ((Select)Mockito.verify((Object)this.select)).removeAllOptions();
    }

    @Test
    public void testLookupDataSet() throws Exception {
        String key = "key";
        String serverTemplateId = "test";
        String dataUUID = "dataUUID";
        String columnValue = "processNameValue";
        String columnText = "processNameText";
        this.filterSettings.setKey("key");
        this.dataSetAwareSelect.setTableKey("key");
        this.filterSettings.setServerTemplateId("test");
        DataSetLookup lookup = (DataSetLookup)Mockito.mock(DataSetLookup.class);
        Mockito.when((Object)lookup.getDataSetUUID()).thenReturn((Object)"dataUUID");
        this.dataSetAwareSelect.setDataSetLookup(lookup);
        this.dataSetAwareSelect.setValueColumnId("value");
        this.dataSetAwareSelect.setTextColumnId("test");
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
                Mockito.when((Object)dataSet.getRowCount()).thenReturn((Object)1);
                Mockito.when((Object)dataSet.getValueAt(0, "value")).thenReturn((Object)"processNameValue");
                Mockito.when((Object)dataSet.getValueAt(0, "test")).thenReturn((Object)"processNameText");
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(dataSet);
                return null;
            }
        }).when((Object)this.dataSetClientServices)).lookupDataSet((DataSetLookup)Matchers.any(DataSetLookup.class), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        this.dataSetAwareSelect.onDataSetReady(new DataSetReadyEvent(this.filterSettings));
        ArgumentCaptor captor = ArgumentCaptor.forClass(DataSetLookup.class);
        ((DataSetClientServices)Mockito.verify((Object)this.dataSetClientServices)).lookupDataSet((DataSetLookup)captor.capture(), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        Assert.assertTrue((boolean)(captor.getValue() instanceof ConsoleDataSetLookup));
        ConsoleDataSetLookup cdsl = (ConsoleDataSetLookup)captor.getValue();
        Assert.assertEquals((Object)"test", (Object)cdsl.getServerTemplateId());
        Assert.assertEquals((Object)"dataUUID", (Object)cdsl.getDataSetUUID());
        ((Select)Mockito.verify((Object)this.select)).addOption("processNameText", "processNameValue");
        ((Select)Mockito.verify((Object)this.select)).enable();
        ((Select)Mockito.verify((Object)this.select)).removeAllOptions();
    }

    @Test
    public void testLookupEmptyDataSet() throws Exception {
        String key = "key";
        String serverTemplateId = "test";
        String dataUUID = "dataUUID";
        this.filterSettings.setKey("key");
        this.dataSetAwareSelect.setTableKey("key");
        this.filterSettings.setServerTemplateId("test");
        DataSetLookup lookup = (DataSetLookup)Mockito.mock(DataSetLookup.class);
        Mockito.when((Object)lookup.getDataSetUUID()).thenReturn((Object)"dataUUID");
        this.dataSetAwareSelect.setDataSetLookup(lookup);
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
                Mockito.when((Object)dataSet.getRowCount()).thenReturn((Object)0);
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(dataSet);
                return null;
            }
        }).when((Object)this.dataSetClientServices)).lookupDataSet((DataSetLookup)Matchers.any(DataSetLookup.class), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        this.dataSetAwareSelect.onDataSetReady(new DataSetReadyEvent(this.filterSettings));
        ArgumentCaptor captor = ArgumentCaptor.forClass(DataSetLookup.class);
        ((DataSetClientServices)Mockito.verify((Object)this.dataSetClientServices)).lookupDataSet((DataSetLookup)captor.capture(), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        Assert.assertTrue((boolean)(captor.getValue() instanceof ConsoleDataSetLookup));
        ConsoleDataSetLookup cdsl = (ConsoleDataSetLookup)captor.getValue();
        Assert.assertEquals((Object)"test", (Object)cdsl.getServerTemplateId());
        Assert.assertEquals((Object)"dataUUID", (Object)cdsl.getDataSetUUID());
        ((Select)Mockito.verify((Object)this.select, (VerificationMode)Mockito.never())).addOption(Mockito.anyString(), Mockito.anyString());
        ((Select)Mockito.verify((Object)this.select)).disable();
        ((Select)Mockito.verify((Object)this.select)).removeAllOptions();
    }
}

