/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import org.gwtbootstrap3.client.ui.Button;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetEditorManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Scheduler.class})
public class AbstractMultiGridViewTest {
    private static final String TEST_KEY = "TEST";
    private static final String TEST_KEY_GRID1 = "TEST_1";
    private static final String TEST_KEY_GRID2 = "TEST_2";
    @Spy
    private AbstractMultiGridView testListView;
    @Mock
    private AbstractMultiGridPresenter presenter;
    @GwtMock
    protected Button mockButton;
    private CallerMock<UserPreferencesService> callerMockUserPreferencesService;
    @Mock
    private UserPreferencesService userPreferencesServiceMock;
    @Mock
    private MultiGridPreferencesStore multiGridPreferencesStore;
    @Mock
    AsyncDataProvider dataProviderMock;
    @GwtMock
    protected FilterPagedTable filterPagedTable;
    @Spy
    protected FilterSettings filterSettings;
    @Mock
    protected DataSetEditorManager dataSetEditorManager;

    @Before
    public void setupMocks() {
        this.callerMockUserPreferencesService = new CallerMock((Object)this.userPreferencesServiceMock);
        this.testListView.setPreferencesService(this.callerMockUserPreferencesService);
        this.testListView.setDataSetEditorManager(this.dataSetEditorManager);
        Mockito.when((Object)this.userPreferencesServiceMock.loadUserPreferences(TEST_KEY, UserPreferencesType.MULTIGRIDPREFERENCES)).thenReturn((Object)this.multiGridPreferencesStore);
        Mockito.when((Object)this.presenter.getDataProvider()).thenReturn((Object)this.dataProviderMock);
        Mockito.when((Object)this.presenter.createTableSettingsPrototype()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createSearchTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.filterPagedTable.getMultiGridPreferencesStore()).thenReturn((Object)this.multiGridPreferencesStore);
    }

    @Test
    public void initWithoutFiltersDefinedTest() {
        Mockito.when((Object)this.multiGridPreferencesStore.getSelectedGrid()).thenReturn((Object)"");
        Mockito.when((Object)this.multiGridPreferencesStore.getGridsId()).thenReturn(new ArrayList());
        GridGlobalPreferences ggp = new GridGlobalPreferences(TEST_KEY, new ArrayList(), new ArrayList());
        this.testListView.init(this.presenter, ggp);
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesServiceMock)).loadUserPreferences(TEST_KEY, UserPreferencesType.MULTIGRIDPREFERENCES);
        ((AbstractMultiGridView)Mockito.verify((Object)this.testListView)).initDefaultFilters(ggp, this.mockButton);
    }

    @Test
    public void initWithFilterStoredTest() {
        ArrayList<String> existingFilters = new ArrayList<String>();
        existingFilters.add(TEST_KEY_GRID1);
        existingFilters.add(TEST_KEY_GRID2);
        Mockito.when((Object)this.multiGridPreferencesStore.getGridsId()).thenReturn(existingFilters);
        GridGlobalPreferences ggp = new GridGlobalPreferences(TEST_KEY, new ArrayList(), new ArrayList());
        this.testListView.init(this.presenter, ggp);
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesServiceMock)).loadUserPreferences(TEST_KEY, UserPreferencesType.MULTIGRIDPREFERENCES);
        ((AbstractMultiGridView)Mockito.verify((Object)this.testListView)).resetDefaultFilterTitleAndDescription();
        ((AbstractMultiGridPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(true);
        ((AbstractMultiGridView)Mockito.verify((Object)this.testListView)).loadGridInstance(ggp, TEST_KEY_GRID1);
        ((AbstractMultiGridView)Mockito.verify((Object)this.testListView)).loadGridInstance(ggp, TEST_KEY_GRID2);
        ((AbstractMultiGridPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(false);
    }

    @Test
    public void validKeyForAdditionalFilterIncludesUserDefinedTest() {
        this.testListView.setFilterPagedTable(this.filterPagedTable);
        this.testListView.getValidKeyForAdditionalListGrid(TEST_KEY);
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable)).getValidKeyForAdditionalListGrid("TESTud_");
    }

    @Test
    public void selectFirstTabAndEnableQueriesTest() {
        GridGlobalPreferences ggp = new GridGlobalPreferences(TEST_KEY, new ArrayList(), new ArrayList());
        this.testListView.init(this.presenter, ggp);
        this.testListView.getSelectFirstTabAndEnableQueriesCommand().execute();
        ((AbstractMultiGridPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(false);
        ((MultiGridPreferencesStore)Mockito.verify((Object)this.multiGridPreferencesStore)).setSelectedGrid("base");
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable)).setSelectedTab();
    }

    @Test
    public void selectionIgnoreColumnTest() {
        ExtendedPagedTable extPagedTable = new ExtendedPagedTable(new GridGlobalPreferences());
        Column testCol = this.testListView.createTextColumn("testCol", val -> val);
        extPagedTable.addSelectionIgnoreColumn(testCol);
        Assert.assertFalse((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
        Assert.assertTrue((boolean)extPagedTable.removeSelectionIgnoreColumn(testCol));
        extPagedTable.addColumn(testCol, "");
        Assert.assertFalse((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
        extPagedTable.addSelectionIgnoreColumn(testCol);
        Assert.assertTrue((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
    }

    @Test
    public void testCreateExtendedPagedTable_PreferenceKeySet() {
        String filterKey = "filterKey";
        GridGlobalPreferences ggp = new GridGlobalPreferences(TEST_KEY, new ArrayList(), new ArrayList());
        this.testListView.init(this.presenter, ggp);
        Mockito.reset((Object[])new AbstractMultiGridPresenter[]{this.presenter});
        ExtendedPagedTable table = this.testListView.createExtendedPagedTable(ggp, filterKey);
        Assert.assertEquals((Object)filterKey, (Object)table.getGridPreferencesStore().getPreferenceKey());
        table = this.testListView.createExtendedPagedTable(ggp, "base");
        Assert.assertEquals((Object)(ggp.getKey() + "base"), (Object)table.getGridPreferencesStore().getPreferenceKey());
    }
}

