/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.common.client.list.ActiveFilterItem;
import org.jbpm.workbench.common.client.list.AdvancedSearchFiltersViewImpl;
import org.jbpm.workbench.common.client.util.DateRange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.Moment;

@RunWith(value=GwtMockitoTestRunner.class)
public class AdvancedSearchFiltersViewImplTest {
    @Mock
    DataBinder<List<ActiveFilterItem>> dataBinder;
    @Spy
    List<ActiveFilterItem> modelList = new ArrayList<ActiveFilterItem>();
    @Mock
    TranslationService translationService;
    @InjectMocks
    AdvancedSearchFiltersViewImpl view;

    @Before
    public void setup() {
        Mockito.when((Object)this.dataBinder.getModel()).thenReturn(this.modelList);
    }

    @Test
    public void testDateRangeChange() {
        Consumer addCallback = (Consumer)Mockito.mock(Consumer.class);
        String label = "label";
        String selectedLabel = "selectedLabel";
        Moment startMoment = (Moment)Mockito.mock(Moment.class);
        Date startDate = new Date();
        Mockito.when((Object)startMoment.asDate()).thenReturn((Object)startDate);
        Moment endMoment = (Moment)Mockito.mock(Moment.class);
        Date endDate = new Date();
        Mockito.when((Object)endMoment.asDate()).thenReturn((Object)endDate);
        this.view.onDateRangeValueChange("label", "selectedLabel", startMoment, endMoment, addCallback, null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((List)Mockito.verify(this.modelList)).add(captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)"label", (Object)((ActiveFilterItem)captor.getValue()).getLabelKey());
        Assert.assertEquals((Object)"selectedLabel", (Object)((ActiveFilterItem)captor.getValue()).getLabelValue());
        Assert.assertEquals((Object)startDate, (Object)((DateRange)((ActiveFilterItem)captor.getValue()).getValue()).getStartDate());
        Assert.assertEquals((Object)endDate, (Object)((DateRange)((ActiveFilterItem)captor.getValue()).getValue()).getEndDate());
        ((Consumer)Mockito.verify((Object)addCallback)).accept(Mockito.any(DateRange.class));
    }

    @Test
    public void testNumericInput() {
        this.testValidKeyCode(8);
        this.testValidKeyCode(57);
        this.testValidKeyCode(104);
        this.testValidKeyCode(96);
        this.testInvalidKeyCode(109);
        this.testInvalidKeyCode(107);
        this.testInvalidKeyCode(32);
        this.testInvalidKeyCode(45);
    }

    protected void testInvalidKeyCode(int keyCode) {
        this.testKeyCode(keyCode, 1);
    }

    protected void testKeyCode(int keyCode, int wantedNumberOfInvocations) {
        KeyboardEvent event = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        Mockito.when((Object)event.getKeyCode()).thenReturn((Object)keyCode);
        this.view.getNumericInputListener().call((Event)event);
        ((KeyboardEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).preventDefault();
    }

    protected void testValidKeyCode(int keyCode) {
        this.testKeyCode(keyCode, 0);
    }

    @Test
    public void testAddActiveFilter() {
        this.view.addActiveFilter("key1", "someValue", (Object)"someValue", null);
        Assert.assertEquals((long)1L, (long)this.modelList.size());
        this.view.addActiveFilter("key1", "anotherValue", (Object)"anotherValue", null);
        Assert.assertEquals((long)1L, (long)this.modelList.size());
    }
}

