/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.view.client.AsyncDataProvider;
import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.ConditionalKebabActionCell;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mocks.CallerMock;

public abstract class AbstractMultiGridViewTest<T extends GenericSummary> {
    @Spy
    protected FilterSettings filterSettings;
    @Mock
    protected AsyncDataProvider dataProviderMock;
    protected CallerMock<UserPreferencesService> userPreferencesService;
    @Mock
    protected UserPreferencesService userPreferencesServiceMock;
    @Spy
    protected MultiGridPreferencesStore multiGridPreferencesStore;
    @Spy
    protected GridPreferencesStore gridPreferencesStore;
    @Mock
    protected ManagedInstance<ConditionalKebabActionCell> conditionalKebabActionCell;

    protected abstract AbstractMultiGridView getView();

    protected abstract AbstractMultiGridPresenter getPresenter();

    public abstract List<String> getExpectedInitialColumns();

    public abstract List<String> getExpectedBannedColumns();

    public abstract Integer getExpectedNumberOfColumns();

    @Before
    public void setupMocks() {
        this.userPreferencesService = new CallerMock((Object)this.userPreferencesServiceMock);
        this.getView().setUserPreferencesService(this.userPreferencesService);
        Mockito.when((Object)this.getPresenter().getDataProvider()).thenReturn((Object)this.dataProviderMock);
        Mockito.when((Object)this.userPreferencesServiceMock.loadUserPreferences(Mockito.anyString(), (UserPreferencesType)Mockito.eq((Object)UserPreferencesType.GRIDPREFERENCES))).thenReturn((Object)new GridPreferencesStore(new GridGlobalPreferences()));
        Mockito.when((Object)this.conditionalKebabActionCell.get()).thenReturn(Mockito.mock(ConditionalKebabActionCell.class));
    }

    @Test
    public void selectionIgnoreColumnTest() {
        ExtendedPagedTable extPagedTable = new ExtendedPagedTable(new GridGlobalPreferences());
        Column testCol = this.getView().createTextColumn("testCol", val -> val);
        extPagedTable.addSelectionIgnoreColumn(testCol);
        Assert.assertFalse((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
        Assert.assertTrue((boolean)extPagedTable.removeSelectionIgnoreColumn(testCol));
        extPagedTable.addColumn(testCol, "");
        Assert.assertFalse((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
        extPagedTable.addSelectionIgnoreColumn(testCol);
        Assert.assertTrue((boolean)extPagedTable.isSelectionIgnoreColumn(extPagedTable.getColumnIndex(testCol)));
    }

    @Test
    public void testInitialColumns() {
        List<String> expectedInitColumns = this.getExpectedInitialColumns();
        Assert.assertEquals((long)expectedInitColumns.size(), (long)this.getView().getInitColumns().size());
        for (int i = 0; i < expectedInitColumns.size(); ++i) {
            Assert.assertEquals((Object)expectedInitColumns.get(i), this.getView().getInitColumns().get(i));
        }
    }

    @Test
    public void testBannedColumns() {
        List bannedColumns = this.getView().getBannedColumns();
        Assert.assertEquals((long)this.getExpectedBannedColumns().size(), (long)bannedColumns.size());
        for (int i = 0; i < bannedColumns.size(); ++i) {
            Assert.assertEquals((Object)this.getExpectedBannedColumns().get(i), bannedColumns.get(i));
        }
    }

    @Test
    public void testDataStoreNameIsSet() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        ((ListTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    Assert.assertNotNull((Object)columnMeta.getColumn().getDataStoreName());
                }
                return null;
            }
        }).when((Object)currentListGrid)).addColumns(Mockito.anyList());
        this.getView().initColumns(currentListGrid);
        ((ListTable)Mockito.verify((Object)currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void testInitColumns() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        ((ListTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertTrue((columns.size() == AbstractMultiGridViewTest.this.getExpectedNumberOfColumns().intValue() ? 1 : 0) != 0);
                return null;
            }
        }).when((Object)currentListGrid)).addColumns(Mockito.anyList());
        ArrayList columnPreferences = new ArrayList();
        Mockito.when((Object)currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStore);
        Mockito.when((Object)this.gridPreferencesStore.getColumnPreferences()).thenReturn(columnPreferences);
        this.getView().initColumns(currentListGrid);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{currentListGrid});
        ((ListTable)inOrder.verify((Object)currentListGrid)).addColumns(Mockito.anyList());
        ((ListTable)inOrder.verify((Object)currentListGrid)).setColumnWidth((Column)Mockito.any(), Mockito.anyDouble(), (Style.Unit)Mockito.any());
    }
}

