/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Optional;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.AbstractListPresenter;
import org.jbpm.workbench.common.client.menu.ManageSelector;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.events.ServerTemplateSelected;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ClosePlaceEvent;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Commands;
import org.uberfire.mvp.PlaceRequest;

public abstract class AbstractScreenListPresenter<T>
extends AbstractListPresenter<T> {
    protected User identity;
    private String detailScreenId;
    @Inject
    protected PlaceManager placeManager;
    @Inject
    private PerspectiveManager perspectiveManager;
    @Inject
    UberfireBreadcrumbs breadcrumbs;
    protected PlaceRequest place;
    protected ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder;
    @Inject
    protected ManageSelector manageSelector;
    private String selectedServerTemplate = "";

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.Manage();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitleDecorator() {
        return this.manageSelector.getManageSelectorWidget();
    }

    @OnOpen
    public void onOpen() {
        this.createListBreadcrumb();
        this.setSelectedServerTemplate(this.serverTemplateSelectorMenuBuilder.getSelectedServerTemplate());
    }

    public void onDetailScreenClosed(@Observes ClosePlaceEvent closed) {
        if (closed.getPlace() != null && this.detailScreenId != null && this.detailScreenId.equals(closed.getPlace().getIdentifier())) {
            this.createListBreadcrumb();
        }
    }

    @OnFocus
    public void onFocus() {
        this.setSelectedServerTemplate(this.serverTemplateSelectorMenuBuilder.getSelectedServerTemplate());
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
        this.breadcrumbs.addToolbar(this.getPerspectiveId(), (Element)this.serverTemplateSelectorMenuBuilder.getView().getElement());
    }

    public String getPerspectiveId() {
        return this.perspectiveManager.getCurrentPerspective().getIdentifier();
    }

    @Inject
    public void setIdentity(User identity) {
        this.identity = identity;
    }

    @Inject
    public void setServerTemplateSelectorMenuBuilder(ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder) {
        this.serverTemplateSelectorMenuBuilder = serverTemplateSelectorMenuBuilder;
    }

    public void onServerTemplateSelected(@Observes ServerTemplateSelected serverTemplateSelected) {
        this.setSelectedServerTemplate(serverTemplateSelected.getServerTemplateId());
    }

    public String getSelectedServerTemplate() {
        return this.selectedServerTemplate;
    }

    public void setSelectedServerTemplate(String selectedServerTemplate) {
        String newServerTemplate = Optional.ofNullable(selectedServerTemplate).orElse("").trim();
        if (!this.selectedServerTemplate.equals(newServerTemplate)) {
            this.selectedServerTemplate = newServerTemplate;
            this.refreshGrid();
        }
    }

    public abstract void createListBreadcrumb();

    public void setupListBreadcrumb(PlaceManager placeManager, String listLabel) {
        this.breadcrumbs.clearBreadcrumbs(this.getPerspectiveId());
        this.breadcrumbs.addBreadCrumb(this.getPerspectiveId(), Constants.INSTANCE.Home(), () -> placeManager.goTo("HomePerspective"));
        this.breadcrumbs.addBreadCrumb(this.getPerspectiveId(), listLabel, Commands.DO_NOTHING);
    }

    public void setupDetailBreadcrumb(PlaceManager placeManager, String listLabel, String detailLabel, String detailScreenId) {
        this.breadcrumbs.clearBreadcrumbs(this.getPerspectiveId());
        this.breadcrumbs.addBreadCrumb(this.getPerspectiveId(), Constants.INSTANCE.Home(), () -> placeManager.goTo("HomePerspective"));
        this.breadcrumbs.addBreadCrumb(this.getPerspectiveId(), listLabel, () -> this.closeDetails(detailScreenId));
        this.breadcrumbs.addBreadCrumb(this.getPerspectiveId(), detailLabel, Commands.DO_NOTHING);
        this.detailScreenId = detailScreenId;
    }

    private void closeDetails(String detailScreenId) {
        this.placeManager.closePlace(detailScreenId);
        this.createListBreadcrumb();
    }

    public void setUberfireBreadcrumbs(UberfireBreadcrumbs breadcrumbs) {
        this.breadcrumbs = breadcrumbs;
    }

    public void setPerspectiveManager(PerspectiveManager perspectiveManager) {
        this.perspectiveManager = perspectiveManager;
    }

    public void setPlaceManager(PlaceManager placeManager) {
        this.placeManager = placeManager;
    }
}

