/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.common.client.dom.Element;
import org.jbpm.workbench.common.client.list.AbstractScreenListPresenter;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.Commands;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractScreenListPresenterTest {
    private String PERSPECTIVE_ID = "perspectiveId";
    @Spy
    AbstractScreenListPresenter presenter;
    @Mock
    UberfireBreadcrumbs breadcrumbsMock;
    @Mock
    PerspectiveManager perspectiveManagerMock;
    @Mock
    PerspectiveActivity perspectiveActivityMock;
    @Mock
    ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilderMock;
    @Mock
    ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView serverTemplateSelectorElementViewMock;

    @Before
    public void setup() {
        Mockito.when((Object)this.perspectiveActivityMock.getIdentifier()).thenReturn((Object)this.PERSPECTIVE_ID);
        Mockito.when((Object)this.perspectiveManagerMock.getCurrentPerspective()).thenReturn((Object)this.perspectiveActivityMock);
        Mockito.when((Object)this.serverTemplateSelectorMenuBuilderMock.getView()).thenReturn((Object)this.serverTemplateSelectorElementViewMock);
        this.presenter.setPerspectiveManager(this.perspectiveManagerMock);
        this.presenter.setUberfireBreadcrumbs(this.breadcrumbsMock);
    }

    @Test
    public void testServerTemplate() {
        ((AbstractScreenListPresenter)Mockito.doNothing().when((Object)this.presenter)).refreshGrid();
        this.presenter.setSelectedServerTemplate("");
        Assert.assertEquals((Object)"", (Object)this.presenter.getSelectedServerTemplate());
        this.presenter.setSelectedServerTemplate(" ");
        Assert.assertEquals((Object)"", (Object)this.presenter.getSelectedServerTemplate());
        this.presenter.setSelectedServerTemplate("testId");
        Assert.assertEquals((Object)"testId", (Object)this.presenter.getSelectedServerTemplate());
        ((AbstractScreenListPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).refreshGrid();
        this.presenter.setSelectedServerTemplate("testId");
        Assert.assertEquals((Object)"testId", (Object)this.presenter.getSelectedServerTemplate());
        ((AbstractScreenListPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).refreshGrid();
    }

    @Test
    public void testListBreadCrumb() {
        String listLabel = "listLabel";
        PlaceManager placeManagerMock = (PlaceManager)Mockito.mock(PlaceManager.class);
        this.presenter.setupListBreadcrumb(placeManagerMock, listLabel);
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbsMock)).clearBreadcrumbs(this.PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbsMock)).addBreadCrumb((String)Mockito.eq((Object)this.PERSPECTIVE_ID), (String)Mockito.eq((Object)Constants.INSTANCE.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbsMock)).addBreadCrumb((String)Mockito.eq((Object)this.PERSPECTIVE_ID), (String)Mockito.eq((Object)listLabel), (Command)Mockito.eq((Object)Commands.DO_NOTHING));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.breadcrumbsMock});
    }

    @Test
    public void testSetupDetailBreadcrumb() {
        String listLabel = "listLabel";
        String detailLabel = "detailLabel";
        String detailScreenId = "screenId";
        PlaceManager placeManagerMock = (PlaceManager)Mockito.mock(PlaceManager.class);
        this.presenter.setPlaceManager(placeManagerMock);
        this.presenter.setupDetailBreadcrumb(placeManagerMock, listLabel, detailLabel, detailScreenId);
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbsMock)).clearBreadcrumbs(this.PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbsMock)).addBreadCrumb((String)Mockito.eq((Object)this.PERSPECTIVE_ID), (String)Mockito.eq((Object)Constants.INSTANCE.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbsMock)).addBreadCrumb((String)Mockito.eq((Object)this.PERSPECTIVE_ID), (String)Mockito.eq((Object)listLabel), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).closePlace(detailScreenId);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbsMock)).addBreadCrumb((String)Mockito.eq((Object)this.PERSPECTIVE_ID), (String)Mockito.eq((Object)detailLabel), (Command)Mockito.eq((Object)Commands.DO_NOTHING));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.breadcrumbsMock});
    }

    @Test
    public void testServerTemplateSelectorAddition() {
        this.presenter.setServerTemplateSelectorMenuBuilder(this.serverTemplateSelectorMenuBuilderMock);
        this.presenter.onStartup((PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbsMock)).addToolbar(this.PERSPECTIVE_ID, (Element)this.serverTemplateSelectorMenuBuilderMock.getView().getElement());
    }
}

