/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.util;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.List;

public class SLAComplianceCell
extends AbstractCell<Integer> {
    private static final String SLA_STYLE = "label";
    private static final String SLA_NA_PRESENT_STYLE = "label-default";
    private static final String SLA_PENDING_PRESENT_STYLE = "label-primary";
    private static final String SLA_MET_PRESENT_STYLE = "label-success";
    private static final String SLA_ABORTED_PRESENT_STYLE = "label-warning";
    private static final String SLA_VIOLATED_PRESENT_STYLE = "label-danger";
    private List<String> descriptions;

    public SLAComplianceCell(List<String> descriptions) {
        super(new String[0]);
        this.descriptions = descriptions;
    }

    public void render(Cell.Context context, Integer value, SafeHtmlBuilder sb) {
        ArrayList<String> tooltipClasses = new ArrayList<String>();
        tooltipClasses.add(SLA_STYLE);
        String description = this.descriptions.get(0);
        switch (value) {
            case 0: {
                description = this.descriptions.get(1);
                tooltipClasses.add(SLA_NA_PRESENT_STYLE);
                break;
            }
            case 1: {
                description = this.descriptions.get(2);
                tooltipClasses.add(SLA_PENDING_PRESENT_STYLE);
                break;
            }
            case 2: {
                description = this.descriptions.get(3);
                tooltipClasses.add(SLA_MET_PRESENT_STYLE);
                break;
            }
            case 4: {
                description = this.descriptions.get(4);
                tooltipClasses.add(SLA_ABORTED_PRESENT_STYLE);
                break;
            }
            case 3: {
                description = this.descriptions.get(5);
                tooltipClasses.add(SLA_VIOLATED_PRESENT_STYLE);
                break;
            }
            default: {
                description = this.descriptions.get(0);
                tooltipClasses.add(SLA_NA_PRESENT_STYLE);
            }
        }
        Element span = DomGlobal.document.createElement("span");
        span.textContent = description;
        tooltipClasses.forEach(c -> span.classList.add(new String[]{c}));
        Element content = DomGlobal.document.createElement("span");
        content.appendChild((Node)span);
        sb.appendHtmlConstant(content.innerHTML);
    }
}

