/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.saved;

import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jbpm.workbench.common.client.filters.saved.SavedFilterRemoveEvent;
import org.jbpm.workbench.common.client.filters.saved.SavedFiltersViewImpl;
import org.jbpm.workbench.common.client.menu.RestoreDefaultFiltersMenuBuilder;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.df.client.events.SavedFilterAddedEvent;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.df.client.filter.SavedFilter;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.Commands;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

public class SavedFiltersPresenter
implements RestoreDefaultFiltersMenuBuilder.SupportsRestoreDefaultFilters {
    private final Constants constants = Constants.INSTANCE;
    private FilterSettingsManager filterSettingsManager;
    @Inject
    private SavedFiltersViewImpl view;

    @WorkbenchPartView
    public IsElement getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.SavedFilters();
    }

    @PostConstruct
    public void init() {
        this.loadSavedFilters();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RestoreDefaultFiltersMenuBuilder(this)).endMenu()).build();
    }

    public void setFilterSettingsManager(FilterSettingsManager filterSettingsManager) {
        this.filterSettingsManager = filterSettingsManager;
    }

    protected void loadSavedFilters() {
        this.filterSettingsManager.loadSavedFilters(filters -> filters.forEach(f -> this.view.addSavedFilter((SavedFilter)f)));
    }

    protected void removeSavedFilter(SavedFilter savedFilter) {
        this.filterSettingsManager.removeSavedFilterFromPreferences(savedFilter.getKey());
        this.view.removeSavedFilter(savedFilter);
    }

    protected void onRestoreFilters() {
        this.view.removeAllSavedFilters();
        this.filterSettingsManager.resetDefaultSavedFilters(filters -> filters.forEach(f -> this.view.addSavedFilter((SavedFilter)f)));
    }

    public void onSaveFilter(@Observes SavedFilterAddedEvent event) {
        this.view.addSavedFilter(event.getFilter());
    }

    public void onRemoveSavedFilter(@Observes SavedFilterRemoveEvent event) {
        YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)this.constants.RemoveSavedFilterTitle(), (String)this.constants.RemoveSavedFilterMessage(event.getSavedFilter().getName()), () -> this.removeSavedFilter(event.getSavedFilter()), null, (Command)Commands.DO_NOTHING);
        yesNoCancelPopup.show();
    }

    @Override
    public void onRestoreDefaultFilters() {
        YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)this.constants.RestoreDefaultFilters(), (String)this.constants.AreYouSureRestoreDefaultFilters(), () -> this.onRestoreFilters(), null, (Command)Commands.DO_NOTHING);
        yesNoCancelPopup.show();
    }
}

