/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.dataset;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.jboss.errai.common.client.dom.OptionsCollection;
import org.jbpm.workbench.common.client.dataset.DataSetAwareSelect;
import org.jbpm.workbench.df.client.events.DataSetReadyEvent;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.ks.integration.ConsoleDataSetLookup;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.Select;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetAwareSelectTest {
    private static final String VALUE_COLUMN_ID = "value";
    private static final String TEXT_COLUMN_ID = "text";
    @Mock
    DataSetClientServices dataSetClientServices;
    @Spy
    FilterSettings filterSettings;
    @Mock
    Select select;
    @InjectMocks
    DataSetAwareSelect dataSetAwareSelect;

    @Before
    public void setup() {
        ((Select)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ((Consumer)invocation.getArguments()[0]).accept(DataSetAwareSelectTest.this.select);
                return null;
            }
        }).when((Object)this.select)).refresh((Consumer)Matchers.any(Consumer.class));
        OptionsCollection options = (OptionsCollection)Mockito.mock(OptionsCollection.class);
        AtomicInteger optionsLength = new AtomicInteger(0);
        Mockito.when((Object)options.getLength()).thenAnswer(a -> optionsLength.get());
        Mockito.when((Object)this.select.getOptions()).thenReturn((Object)options);
        ((Select)Mockito.doAnswer(invocationOnMock -> optionsLength.incrementAndGet()).when((Object)this.select)).addOption(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void testEmptyServerTemplate() {
        this.filterSettings.setKey("key");
        this.dataSetAwareSelect.onDataSetReady(new DataSetReadyEvent(this.filterSettings));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.dataSetClientServices});
        ((Select)Mockito.verify((Object)this.select)).removeAllOptions();
    }

    @Test
    public void testLookupDataSet() throws Exception {
        String key = "key";
        String serverTemplateId = "test";
        String dataUUID = "dataUUID";
        String columnValue = "processNameValue";
        String columnText = "processNameText";
        this.filterSettings.setKey("key");
        this.filterSettings.setServerTemplateId("test");
        DataSetLookup lookup = (DataSetLookup)Mockito.mock(DataSetLookup.class);
        Mockito.when((Object)lookup.getDataSetUUID()).thenReturn((Object)"dataUUID");
        this.dataSetAwareSelect.setDataSetLookup(lookup);
        this.dataSetAwareSelect.setValueColumnId(VALUE_COLUMN_ID);
        this.dataSetAwareSelect.setTextColumnId(TEXT_COLUMN_ID);
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
                Mockito.when((Object)dataSet.getRowCount()).thenReturn((Object)1);
                Mockito.when((Object)dataSet.getValueAt(0, DataSetAwareSelectTest.VALUE_COLUMN_ID)).thenReturn((Object)"processNameValue");
                Mockito.when((Object)dataSet.getValueAt(0, DataSetAwareSelectTest.TEXT_COLUMN_ID)).thenReturn((Object)"processNameText");
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(dataSet);
                return null;
            }
        }).when((Object)this.dataSetClientServices)).lookupDataSet((DataSetLookup)Matchers.any(DataSetLookup.class), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        this.dataSetAwareSelect.onDataSetReady(new DataSetReadyEvent(this.filterSettings));
        ArgumentCaptor captor = ArgumentCaptor.forClass(DataSetLookup.class);
        ((DataSetClientServices)Mockito.verify((Object)this.dataSetClientServices)).lookupDataSet((DataSetLookup)captor.capture(), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        Assert.assertTrue((boolean)(captor.getValue() instanceof ConsoleDataSetLookup));
        ConsoleDataSetLookup cdsl = (ConsoleDataSetLookup)captor.getValue();
        Assert.assertEquals((Object)"test", (Object)cdsl.getServerTemplateId());
        Assert.assertEquals((Object)"dataUUID", (Object)cdsl.getDataSetUUID());
        ((Select)Mockito.verify((Object)this.select)).addOption("processNameText", "processNameValue");
        ((Select)Mockito.verify((Object)this.select)).enable();
        ((Select)Mockito.verify((Object)this.select)).removeAllOptions();
    }

    @Test
    public void testLookupDataSetEmptyStringOrNull() throws Exception {
        String key = "key";
        String serverTemplateId = "test";
        String dataUUID = "dataUUID";
        String columnValue = "processNameValue";
        String columnText = "processNameText";
        this.filterSettings.setKey("key");
        this.filterSettings.setServerTemplateId("test");
        DataSetLookup lookup = (DataSetLookup)Mockito.mock(DataSetLookup.class);
        Mockito.when((Object)lookup.getDataSetUUID()).thenReturn((Object)"dataUUID");
        this.dataSetAwareSelect.setDataSetLookup(lookup);
        this.dataSetAwareSelect.setValueColumnId(VALUE_COLUMN_ID);
        this.dataSetAwareSelect.setTextColumnId(TEXT_COLUMN_ID);
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
                Mockito.when((Object)dataSet.getRowCount()).thenReturn((Object)3);
                Mockito.when((Object)dataSet.getValueAt(0, DataSetAwareSelectTest.VALUE_COLUMN_ID)).thenReturn((Object)"processNameValue");
                Mockito.when((Object)dataSet.getValueAt(0, DataSetAwareSelectTest.TEXT_COLUMN_ID)).thenReturn((Object)"processNameText");
                Mockito.when((Object)dataSet.getValueAt(1, DataSetAwareSelectTest.VALUE_COLUMN_ID)).thenReturn((Object)"");
                Mockito.when((Object)dataSet.getValueAt(1, DataSetAwareSelectTest.TEXT_COLUMN_ID)).thenReturn((Object)"");
                Mockito.when((Object)dataSet.getValueAt(2, DataSetAwareSelectTest.VALUE_COLUMN_ID)).thenReturn(null);
                Mockito.when((Object)dataSet.getValueAt(2, DataSetAwareSelectTest.TEXT_COLUMN_ID)).thenReturn(null);
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(dataSet);
                return null;
            }
        }).when((Object)this.dataSetClientServices)).lookupDataSet((DataSetLookup)Matchers.any(DataSetLookup.class), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        this.dataSetAwareSelect.onDataSetReady(new DataSetReadyEvent(this.filterSettings));
        ArgumentCaptor captor = ArgumentCaptor.forClass(DataSetLookup.class);
        ((DataSetClientServices)Mockito.verify((Object)this.dataSetClientServices)).lookupDataSet((DataSetLookup)captor.capture(), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        Assert.assertTrue((boolean)(captor.getValue() instanceof ConsoleDataSetLookup));
        ConsoleDataSetLookup cdsl = (ConsoleDataSetLookup)captor.getValue();
        Assert.assertEquals((Object)"test", (Object)cdsl.getServerTemplateId());
        Assert.assertEquals((Object)"dataUUID", (Object)cdsl.getDataSetUUID());
        ((Select)Mockito.verify((Object)this.select)).addOption("processNameText", "processNameValue");
        ((Select)Mockito.verify((Object)this.select)).enable();
        ((Select)Mockito.verify((Object)this.select)).removeAllOptions();
    }

    @Test
    public void testLookupEmptyDataSet() throws Exception {
        String key = "key";
        String serverTemplateId = "test";
        String dataUUID = "dataUUID";
        this.filterSettings.setKey("key");
        this.filterSettings.setServerTemplateId("test");
        DataSetLookup lookup = (DataSetLookup)Mockito.mock(DataSetLookup.class);
        Mockito.when((Object)lookup.getDataSetUUID()).thenReturn((Object)"dataUUID");
        this.dataSetAwareSelect.setDataSetLookup(lookup);
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
                Mockito.when((Object)dataSet.getRowCount()).thenReturn((Object)0);
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(dataSet);
                return null;
            }
        }).when((Object)this.dataSetClientServices)).lookupDataSet((DataSetLookup)Matchers.any(DataSetLookup.class), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        this.dataSetAwareSelect.onDataSetReady(new DataSetReadyEvent(this.filterSettings));
        ArgumentCaptor captor = ArgumentCaptor.forClass(DataSetLookup.class);
        ((DataSetClientServices)Mockito.verify((Object)this.dataSetClientServices)).lookupDataSet((DataSetLookup)captor.capture(), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        Assert.assertTrue((boolean)(captor.getValue() instanceof ConsoleDataSetLookup));
        ConsoleDataSetLookup cdsl = (ConsoleDataSetLookup)captor.getValue();
        Assert.assertEquals((Object)"test", (Object)cdsl.getServerTemplateId());
        Assert.assertEquals((Object)"dataUUID", (Object)cdsl.getDataSetUUID());
        ((Select)Mockito.verify((Object)this.select, (VerificationMode)Mockito.never())).addOption(Mockito.anyString(), Mockito.anyString());
        ((Select)Mockito.verify((Object)this.select)).disable();
        ((Select)Mockito.verify((Object)this.select)).removeAllOptions();
    }
}

