/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jbpm.workbench.common.client.list.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.model.GenericSummary;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractListView<T extends GenericSummary, V extends AbstractListPresenter>
extends Composite
implements RequiresResize {
    @Inject
    public User identity;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    protected PlaceManager placeManager;
    protected V presenter;
    protected ExtendedPagedTable<T> listGrid;
    protected NoSelectionModel<T> selectionModel;
    protected T selectedItem;
    protected DefaultSelectionEventManager<T> noActionColumnManager;
    @Inject
    @DataField(value="column")
    protected HTMLDivElement column;
    private Caller<UserPreferencesService> preferencesService;

    public void init(final V presenter, final GridGlobalPreferences preferences) {
        this.presenter = presenter;
        this.listGrid = this.createListGrid(preferences);
        this.listGrid.setShowLastPagerButton(true);
        this.listGrid.setShowFastFordwardPagerButton(true);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<GridPreferencesStore>(){

            public void callback(GridPreferencesStore preferencesStore) {
                if (preferencesStore == null) {
                    AbstractListView.this.listGrid.setGridPreferencesStore(new GridPreferencesStore(preferences));
                } else {
                    AbstractListView.this.listGrid.setGridPreferencesStore(preferencesStore);
                }
                AbstractListView.this.initColumns(AbstractListView.this.listGrid);
                AbstractListView.this.listGrid.loadPageSizePreferences();
                AbstractListView.this.listGrid.setPreferencesService(AbstractListView.this.preferencesService);
                AbstractListView.this.addNewTableToColumn(AbstractListView.this.listGrid);
                presenter.addDataDisplay(AbstractListView.this.listGrid);
            }
        })).loadUserPreferences(preferences.getKey(), UserPreferencesType.GRIDPREFERENCES);
    }

    public void addNewTableToColumn(ExtendedPagedTable<T> newPagedTable) {
        new Elemental2DomUtil().appendWidgetToElement((HTMLElement)this.column, newPagedTable);
    }

    protected ExtendedPagedTable<T> createListGrid(GridGlobalPreferences preferences) {
        return new ExtendedPagedTable(preferences);
    }

    public void onResize() {
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public ExtendedPagedTable<T> getListGrid() {
        return this.listGrid;
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    public abstract void initColumns(ExtendedPagedTable<T> var1);

    @Inject
    public void setPreferencesService(Caller<UserPreferencesService> preferencesService) {
        this.preferencesService = preferencesService;
    }
}

