/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterAddEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterRemoveEvent;
import org.jbpm.workbench.common.client.filters.saved.SavedFilterSelectedEvent;
import org.jbpm.workbench.common.client.list.AbstractScreenListPresenter;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

public abstract class AbstractMultiGridPresenter<T extends GenericSummary, V extends MultiGridView>
extends AbstractScreenListPresenter<T> {
    protected DataSetQueryHelper dataSetQueryHelper;
    protected V view;
    protected AuthorizationManager authorizationManager;
    protected FilterSettingsManager filterSettingsManager;
    @Inject
    protected ErrorPopupPresenter errorPopup;

    @Inject
    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    @Inject
    public void setDataSetQueryHelper(DataSetQueryHelper dataSetQueryHelper) {
        this.dataSetQueryHelper = dataSetQueryHelper;
    }

    public void setFilterSettingsManager(FilterSettingsManager filterSettingsManager) {
        this.filterSettingsManager = filterSettingsManager;
    }

    public DataSetQueryHelper getDataSetQueryHelper() {
        return this.dataSetQueryHelper;
    }

    @Override
    protected ListView getListView() {
        return this.view;
    }

    @WorkbenchPartView
    public UberView<T> getView() {
        return this.view;
    }

    @Inject
    public void setView(V view) {
        this.view = view;
    }

    public void setupActiveSearchFilters() {
        this.setupDefaultActiveSearchFilters();
    }

    public abstract void setupDefaultActiveSearchFilters();

    @PostConstruct
    public void init() {
        BiConsumer<String, Consumer<String>> filterNameCallback = (name, callback) -> this.saveSearchFilterSettings((String)name, (Consumer<String>)callback);
        this.view.setSaveFilterCallback(filterNameCallback);
    }

    @Override
    @OnOpen
    public void onOpen() {
        super.onOpen();
        this.setFilterSettings(this.filterSettingsManager.createDefaultFilterSettingsPrototype(), table -> {
            this.setupActiveSearchFilters();
            this.addDataDisplay(table);
        });
    }

    public Predicate<String> getFilterEventPredicate() {
        return dataSetId -> this.getDataSetQueryHelper() != null && this.getDataSetQueryHelper().getCurrentTableSettings() != null && dataSetId != null && dataSetId.equals(this.getDataSetQueryHelper().getCurrentTableSettings().getUUID());
    }

    public void onBasicFilterAddEvent(@Observes BasicFilterAddEvent event) {
        if (this.getFilterEventPredicate().test(event.getDataSetId())) {
            this.addActiveFilter(event.getFilter(), event.getActiveFilterItem());
        }
    }

    public void onBasicFilterRemoveEvent(@Observes BasicFilterRemoveEvent event) {
        if (this.getFilterEventPredicate().test(event.getDataSetId())) {
            this.removeActiveFilter(event.getFilter(), event.getActiveFilterItem());
        }
    }

    protected void onSavedFilterSelectedEvent(@Observes SavedFilterSelectedEvent event) {
        this.filterSettingsManager.getFilterSettings(event.getSavedFilter().getKey(), filter -> this.addActiveFilters((FilterSettings)filter));
    }

    protected void setFilterSettings(FilterSettings filter, Consumer<ListTable<T>> readyCallback) {
        this.getDataSetQueryHelper().setCurrentTableSettings(filter);
        this.view.loadListTable(filter.getKey(), readyCallback);
    }

    protected void addActiveFilters(FilterSettings filter) {
        this.view.removeAllActiveFilters();
        this.setFilterSettings(filter, table -> {
            if (filter.getDataSetLookup().getFirstFilterOp() != null) {
                List filters = filter.getDataSetLookup().getFirstFilterOp().getColumnFilterList();
                filters.forEach(column -> {
                    ActiveFilterItem<Object> activeFilter = new ActiveFilterItem<Object>(column.getColumnId(), column.toString(), null, null, v -> this.removeActiveFilter((ColumnFilter)column));
                    this.view.addActiveFilter(activeFilter);
                });
            }
            this.addDataDisplay(table);
        });
    }

    @Override
    public void getData(Range visibleRange) {
        try {
            FilterSettings currentTableSettings = this.getDataSetQueryHelper().getCurrentTableSettings();
            currentTableSettings.setServerTemplateId(this.getSelectedServerTemplate());
            currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
            ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
            if (columnSortList != null && columnSortList.size() > 0) {
                this.getDataSetQueryHelper().setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                this.getDataSetQueryHelper().setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
            }
            this.getDataSetQueryHelper().setCurrentTableSettings(currentTableSettings);
            this.getDataSetQueryHelper().setDataSetHandler(currentTableSettings);
            this.getDataSetQueryHelper().lookupDataSet(Integer.valueOf(visibleRange.getStart()), this.getDataSetReadyCallback(visibleRange.getStart(), currentTableSettings));
        }
        catch (Exception e) {
            this.errorPopup.showMessage(Constants.INSTANCE.UnexpectedError(e.getMessage()));
            this.view.hideBusyIndicator();
        }
    }

    protected abstract void selectSummaryItem(T var1);

    protected abstract DataSetReadyCallback getDataSetReadyCallback(Integer var1, FilterSettings var2);

    protected <T> void addActiveFilter(ColumnFilter columnFilter, String labelKey, String labelValue, T value, Consumer<T> removeCallback) {
        this.addActiveFilter(columnFilter, new ActiveFilterItem<T>(labelKey, labelKey + ": " + labelValue, null, value, removeCallback));
    }

    protected <T> void addActiveFilter(ColumnFilter columnFilter, ActiveFilterItem<T> filter) {
        filter.setCallback(v -> this.removeActiveFilter(columnFilter));
        FilterSettings settings = this.getDataSetQueryHelper().getCurrentTableSettings();
        settings.addColumnFilter(columnFilter);
        this.view.addActiveFilter(filter);
        this.refreshGrid();
    }

    protected void removeActiveFilter(ColumnFilter columnFilter) {
        FilterSettings settings = this.getDataSetQueryHelper().getCurrentTableSettings();
        settings.removeColumnFilter(columnFilter);
        this.refreshGrid();
    }

    protected void removeActiveFilter(ColumnFilter columnFilter, ActiveFilterItem<T> filter) {
        this.view.removeActiveFilter(filter);
        this.removeActiveFilter(columnFilter);
    }

    public void saveSearchFilterSettings(String filterName, Consumer<String> callback) {
        FilterSettings settings = this.getDataSetQueryHelper().getCurrentTableSettings();
        settings.setTableName(filterName);
        settings.setTableDescription(filterName);
        this.filterSettingsManager.saveFilterIntoPreferences(settings, state -> callback.accept(state != false ? null : Constants.INSTANCE.FilterWithSameNameAlreadyExists()));
    }

    protected Optional<String> getSearchParameter(String parameterId) {
        return Optional.ofNullable(this.place.getParameter(parameterId, null));
    }

    protected void navigateToPerspective(String perspectiveId, String parameterName, String parameterValue) {
        DefaultPlaceRequest request = new DefaultPlaceRequest(perspectiveId);
        request.addParameter(parameterName, parameterValue);
        this.placeManager.goTo((PlaceRequest)request);
    }

    public boolean isUserAuthorizedForPerspective(String perspectiveId) {
        ResourceRef resourceRef = new ResourceRef(perspectiveId, (ResourceType)ActivityResourceType.PERSPECTIVE);
        return this.authorizationManager.authorize((Resource)resourceRef, this.identity);
    }

    public void openErrorView(String parameterId) {
    }

    public Predicate<T> getViewErrorsActionCondition() {
        return null;
    }
}

