/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.menu;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import javax.enterprise.event.Event;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.common.events.ServerTemplateSelected;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class ServerTemplateSelectorMenuBuilderTest {
    @InjectMocks
    ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder;
    @Mock
    ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorWidgetView viewWidget;
    @Mock
    ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView view;
    private CallerMock<SpecManagementService> specManagementServiceCaller;
    @Mock
    private SpecManagementService specManagementService;
    @Spy
    private Event<ServerTemplateSelected> serverTemplateSelectedEvent = new EventSourceMock();

    @Before
    public void setup() {
        ((Event)Mockito.doNothing().when(this.serverTemplateSelectedEvent)).fire(Matchers.any());
        this.specManagementServiceCaller = new CallerMock((Object)this.specManagementService);
        this.serverTemplateSelectorMenuBuilder.setSpecManagementService(this.specManagementServiceCaller);
    }

    @Test
    public void testAddServerTemplates() {
        String serverTemplateId = "id1";
        ServerTemplate st1 = new ServerTemplate("id1", "kie-server-template1");
        st1.addServerInstance(new ServerInstanceKey());
        ServerTemplate st2 = new ServerTemplate("id2", "kie-server-template2");
        st2.addServerInstance(new ServerInstanceKey());
        Mockito.when((Object)this.specManagementService.listServerTemplates()).thenReturn((Object)new ServerTemplateList(Arrays.asList(st1, st2)));
        Mockito.when((Object)this.view.getSelectedServerTemplate()).thenReturn((Object)"id1");
        this.serverTemplateSelectorMenuBuilder.init();
        ((SpecManagementService)Mockito.verify((Object)this.specManagementService)).listServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).setServerTemplateChangeHandler((ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).removeAllServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).addServerTemplate("id1");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).addServerTemplate("id2");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).getSelectedServerTemplate();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).selectServerTemplate("id1");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).setVisible(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testAddServerTemplatesSelectedRemoved() {
        ServerTemplate st1 = new ServerTemplate("id1", "kie-server-template1");
        st1.addServerInstance(new ServerInstanceKey());
        ServerTemplate st2 = new ServerTemplate("id2", "kie-server-template2");
        st2.addServerInstance(new ServerInstanceKey());
        Mockito.when((Object)this.specManagementService.listServerTemplates()).thenReturn((Object)new ServerTemplateList(Arrays.asList(st1, st2)));
        Mockito.when((Object)this.view.getSelectedServerTemplate()).thenReturn((Object)"id3");
        this.serverTemplateSelectorMenuBuilder.init();
        ((SpecManagementService)Mockito.verify((Object)this.specManagementService)).listServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).setServerTemplateChangeHandler((ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).removeAllServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).addServerTemplate("id1");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).addServerTemplate("id2");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).getSelectedServerTemplate();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).clearSelectedServerTemplate();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).setVisible(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testOneServerTemplate() {
        String serverTemplateId = "id1";
        ServerTemplate st1 = new ServerTemplate("id1", "kie-server-template1");
        st1.addServerInstance(new ServerInstanceKey());
        Mockito.when((Object)this.specManagementService.listServerTemplates()).thenReturn((Object)new ServerTemplateList(Collections.singletonList(st1)));
        this.serverTemplateSelectorMenuBuilder.init();
        ((SpecManagementService)Mockito.verify((Object)this.specManagementService)).listServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).setServerTemplateChangeHandler((ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).removeAllServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).addServerTemplate("id1");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).selectServerTemplate("id1");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).setVisible(false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testServerTemplateSelected() {
        String serverTemplateId = "id1";
        ServerTemplate st1 = new ServerTemplate("id1", "kie-server-template1");
        st1.addServerInstance(new ServerInstanceKey());
        Mockito.when((Object)this.specManagementService.listServerTemplates()).thenReturn((Object)new ServerTemplateList(Collections.singletonList(st1)));
        Mockito.when((Object)this.view.getSelectedServerTemplate()).thenReturn((Object)"id1");
        this.serverTemplateSelectorMenuBuilder.init();
        ((SpecManagementService)Mockito.verify((Object)this.specManagementService)).listServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).setServerTemplateChangeHandler((ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).removeAllServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).addServerTemplate("id1");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).selectServerTemplate("id1");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).setVisible(false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testServerTemplateSelectedRemoved() {
        String serverTemplateId = "id1";
        ServerTemplate st1 = new ServerTemplate("id1", "kie-server-template1");
        st1.addServerInstance(new ServerInstanceKey());
        Mockito.when((Object)this.specManagementService.listServerTemplates()).thenReturn((Object)new ServerTemplateList(Collections.singletonList(st1)));
        Mockito.when((Object)this.view.getSelectedServerTemplate()).thenReturn((Object)"id2");
        this.serverTemplateSelectorMenuBuilder.init();
        ((SpecManagementService)Mockito.verify((Object)this.specManagementService)).listServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).setServerTemplateChangeHandler((ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).removeAllServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).addServerTemplate("id1");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).selectServerTemplate("id1");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).setVisible(false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testServerTemplateUpdatedWithoutServerInstance() {
        String serverTemplateId = "id1";
        ServerTemplate st1 = new ServerTemplate("id1", "kie-server-template1");
        Mockito.when((Object)this.specManagementService.listServerTemplates()).thenReturn((Object)new ServerTemplateList(Collections.singletonList(st1)));
        this.serverTemplateSelectorMenuBuilder.onServerTemplateUpdated(new ServerTemplateUpdated(st1));
        ((SpecManagementService)Mockito.verify((Object)this.specManagementService)).listServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).removeAllServerTemplates();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addServerTemplate("id1");
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).setVisible(false);
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).getSelectedServerTemplate();
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.verify((Object)this.view)).clearSelectedServerTemplate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testServerTemplateUpdatedWithServerInstance() {
        String serverTemplateId = "id1";
        ServerTemplate st1 = new ServerTemplate("id1", "kie-server-template1");
        st1.addServerInstance(new ServerInstanceKey());
        Mockito.when((Object)this.specManagementService.listServerTemplates()).thenReturn((Object)new ServerTemplateList(Collections.singletonList(st1)));
        this.serverTemplateSelectorMenuBuilder.onServerTemplateUpdated(new ServerTemplateUpdated(st1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testServerTemplateChangeHandler() {
        String serverTemplateId = "id1";
        Mockito.when((Object)this.specManagementService.listServerTemplates()).thenReturn((Object)new ServerTemplateList(Collections.emptyList()));
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)Mockito.doAnswer(invocation -> {
            ParameterizedCommand command = (ParameterizedCommand)invocation.getArguments()[0];
            command.execute((Object)"id1");
            return null;
        }).when((Object)this.view)).setServerTemplateChangeHandler((ParameterizedCommand)Matchers.any());
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorWidgetView)Mockito.doAnswer(invocation -> {
            ParameterizedCommand command = (ParameterizedCommand)invocation.getArguments()[0];
            command.execute((Object)"id1");
            return null;
        }).when((Object)this.viewWidget)).setServerTemplateChangeHandler((ParameterizedCommand)Matchers.any());
        this.serverTemplateSelectorMenuBuilder.init();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.view, this.viewWidget, this.serverTemplateSelectedEvent});
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView)inOrder.verify((Object)this.view)).updateSelectedValue("id1");
        ((Event)inOrder.verify(this.serverTemplateSelectedEvent)).fire(Matchers.any());
        ((ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorWidgetView)inOrder.verify((Object)this.viewWidget)).updateSelectedValue("id1");
        ((Event)inOrder.verify(this.serverTemplateSelectedEvent)).fire(Matchers.any());
    }
}

