/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.filters.basic;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jboss.errai.common.client.api.IsElement;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItemAddedEvent;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItemRemovedEvent;
import org.jbpm.workbench.common.client.filters.active.ClearAllActiveFiltersEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterAddEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterRemoveEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersView;
import org.jbpm.workbench.common.client.filters.saved.SavedFilterSelectedEvent;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.lifecycle.OnOpen;

public abstract class BasicFiltersPresenter {
    private final Constants constants = Constants.INSTANCE;
    @Inject
    protected BasicFiltersView view;
    @Inject
    protected Event<BasicFilterAddEvent> basicFilterAddEvent;
    @Inject
    protected Event<BasicFilterRemoveEvent> basicFilterRemoveEvent;

    @WorkbenchPartView
    public IsElement getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Filters();
    }

    @PostConstruct
    public void init() {
        this.loadFilters();
    }

    @OnOpen
    public void onOpen() {
        this.view.clearAllSelectFilter();
    }

    public void onClearAllActiveFiltersEvent(@Observes ClearAllActiveFiltersEvent event) {
        this.view.clearAllSelectFilter();
    }

    public abstract void loadFilters();

    public abstract String getDataSetId();

    protected void addSearchFilter(ActiveFilterItem filter, ColumnFilter columnFilter) {
        this.basicFilterAddEvent.fire((Object)new BasicFilterAddEvent(this.getDataSetId(), filter, columnFilter));
    }

    protected void addSearchFilterList(String columnId, ActiveFilterItem<List<String>> filter) {
        ColumnFilter columnFilter = FilterFactory.in((String)columnId, filter.getValue());
        this.addSearchFilterList(filter, columnFilter);
    }

    protected void addSearchFilterList(ActiveFilterItem<List<String>> filter, ColumnFilter columnFilter) {
        if (filter.getValue().isEmpty()) {
            this.removeSearchFilter(filter, columnFilter);
        } else {
            this.addSearchFilter(filter, columnFilter);
        }
    }

    protected void removeSearchFilter(ActiveFilterItem filter, ColumnFilter columnFilter) {
        this.basicFilterRemoveEvent.fire((Object)new BasicFilterRemoveEvent(this.getDataSetId(), filter, columnFilter));
    }

    protected abstract void onActiveFilterAdded(ActiveFilterItem var1);

    public void onActiveFilterAddedEvent(@Observes ActiveFilterItemAddedEvent event) {
        this.onActiveFilterAdded(event.getActiveFilterItem());
    }

    public void onRemoveActiveFilter(@Observes ActiveFilterItemRemovedEvent event) {
        this.view.clearSelectFilter(event.getActiveFilterItem().getKey());
    }

    protected void onSavedFilterSelectedEvent(@Observes SavedFilterSelectedEvent event) {
        this.view.clearAllSelectFilter();
    }
}

