/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.common.client.list;

import java.util.Optional;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.jbpm.workbench.common.client.events.SearchEvent;
import org.jbpm.workbench.common.client.list.AbstractScreenListPresenter;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.menu.RefreshSelectorMenuBuilder;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

public abstract class AbstractMultiGridPresenter<T extends GenericSummary, V extends MultiGridView>
extends AbstractScreenListPresenter<T>
implements RefreshSelectorMenuBuilder.SupportsRefreshInterval {
    protected DataSetQueryHelper dataSetQueryHelper;
    protected RefreshSelectorMenuBuilder refreshSelectorMenuBuilder = new RefreshSelectorMenuBuilder((RefreshSelectorMenuBuilder.SupportsRefreshInterval)this);
    protected V view;
    private AuthorizationManager authorizationManager;

    @Inject
    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    @Inject
    public void setDataSetQueryHelper(DataSetQueryHelper dataSetQueryHelper) {
        this.dataSetQueryHelper = dataSetQueryHelper;
    }

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    @Override
    public void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
    }

    @Override
    public void onUpdateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        super.onUpdateRefreshInterval(enableAutoRefresh, newInterval);
        this.view.saveRefreshValue(newInterval);
    }

    @Override
    public void onGridPreferencesStoreLoaded() {
        this.refreshSelectorMenuBuilder.loadOptions(this.view.getRefreshValue());
        this.clearActiveSearchFilters();
        this.setupActiveSearchFilters();
        this.view.selectFirstTabAndEnableQueries();
    }

    public void onRestoreTabs() {
        this.view.restoreTabs();
        this.clearActiveSearchFilters();
        this.setupDefaultActiveSearchFilters();
        this.view.selectFirstTabAndEnableQueries();
    }

    @Override
    protected ListView getListView() {
        return this.view;
    }

    @WorkbenchPartView
    public UberView<T> getView() {
        return this.view;
    }

    @Inject
    public void setView(V view) {
        this.view = view;
    }

    public abstract FilterSettings createTableSettingsPrototype();

    public abstract FilterSettings createSearchTabSettings();

    public abstract void setupAdvancedSearchView();

    public void setupActiveSearchFilters() {
        this.setupDefaultActiveSearchFilters();
    }

    public abstract void setupDefaultActiveSearchFilters();

    @Override
    @OnOpen
    public void onOpen() {
        super.onOpen();
        this.setupAdvancedSearchView();
    }

    protected void clearActiveSearchFilters() {
        FilterSettings settings = this.view.getAdvancedSearchFilterSettings();
        settings.removeAllColumnFilters();
        this.view.saveAdvancedSearchFilterSettings(settings);
        this.view.removeAllActiveFilters();
    }

    protected void addAdvancedSearchFilter(ColumnFilter columnFilter) {
        FilterSettings settings = this.view.getAdvancedSearchFilterSettings();
        settings.addColumnFilter(columnFilter);
        this.view.saveAdvancedSearchFilterSettings(settings);
        this.filterGrid(settings);
    }

    protected void removeAdvancedSearchFilter(ColumnFilter columnFilter) {
        FilterSettings settings = this.view.getAdvancedSearchFilterSettings();
        if (settings.removeColumnFilter(columnFilter)) {
            this.view.saveAdvancedSearchFilterSettings(settings);
            this.filterGrid(settings);
        }
    }

    protected Optional<String> getSearchParameter(String parameterId) {
        return Optional.ofNullable(this.place.getParameter(parameterId, null));
    }

    protected void navigateToPerspective(String perspectiveId, String parameterName, String parameterValue) {
        DefaultPlaceRequest request = new DefaultPlaceRequest(perspectiveId);
        request.addParameter(parameterName, parameterValue);
        this.placeManager.goTo((PlaceRequest)request);
    }

    public boolean isUserAuthorizedForPerspective(String perspectiveId) {
        ResourceRef resourceRef = new ResourceRef(perspectiveId, (ResourceType)ActivityResourceType.PERSPECTIVE);
        return this.authorizationManager.authorize((Resource)resourceRef, this.identity);
    }
}

